; This file is part of ethflop, a floppy drive emulator over Ethernet
; Copyright (C) 2019-2024 Mateusz Viste ; MIT License
;
; Contains STRINGS used by the transient loader, but only those that:
;
; 1. are used BEFORE any frame is sent
; 2. fit exactly within 512 bytes
;
; These strings can be stored in the 512 placeholder for the frame buffer so
; its on-disk space is not wasted.


STR0_START:

STR_HLP0 db "ETHFLOP ver 20240920 ; a floppy drive emulator over Ethernet", 13, 10,\
            "Copyright (C) 2019-2024 Mateusz Viste ; MIT License", 13, 10, 10,\
            "USAGE:", 13, 10, 10,\
            "ethflop a           installs the ethflop TSR as A:", 13, 10,\
            "ethflop b           installs ethflop as B: (only if B: is declared in BIOS)", 13, 10,\
            "ethflop i DISKNAME  'inserts' the virtual floppy 'DISKNAME'", 13, 10,\
            "ethflop ip DSKNAME  same as 'i', but the inserted floppy is WRITE PROTECTED", 13, 10,\
            "ethflop r OLD NEW   renames virt. floppy 'OLD' to 'NEW'", 13, 10,\
            "ethflop e           'ejects' currently loaded virtual floppy", 13, 10,\
            "$"

STR0_END:

; fill the buffer up to exactly 512 bytes
FILLER times (512 - (STR0_END - STR0_START)) db 0
