DECLARE FUNCTION Bin2Dec& (value$)
DECLARE FUNCTION BIN$ (numb&)
DECLARE SUB Load (char&)
DECLARE FUNCTION Hex2Dec& (a$)
DECLARE FUNCTION CheckBlank% (g&)

PRINT
PRINT "CHKBLANK opens FOXTYPE.640, CHKBLANK.TXT and FOXTYPE.BLN, then reads each"
PRINT "line of CHKBLANK.TXT and compare if the given character is really blank"
PRINT "in FOXTYPE.DAT and reports it as zeroed to FOXTYPE.BLN."
PRINT
PRINT "Press any key to continue..."
DO: LOOP UNTIL INKEY$ <> ""

CLS
PRINT "Preparing FOXTYPE.BLN..."

OPEN "FOXTYPE.TMP" FOR OUTPUT AS #1
FOR x& = 0 TO 65535
   PRINT #1, "1";
NEXT x&
CLOSE #1

DIM SHARED Table(1 TO 16) AS STRING * 8

OPEN "CHKBLANK.TXT" FOR INPUT AS #1
PRINT "Checking the FOXTYPE.640 file for empty codepoints...";
PRINT
Wrong% = 0
DO
        IF EOF(1) THEN EXIT DO
        LINE INPUT #1, HexNumb$
        CheckingNumb& = Hex2Dec&(HexNumb$)
        IF CheckBlank%(CheckingNumb&) <> 0 THEN
                BEEP: PRINT "The U+"; HexNumb$; " character isn't empty!": Wrong% = 1
         ELSE
                PRINT CheckingNumb&; "...Ok"
                OPEN "FOXTYPE.TMP" FOR BINARY AS #3
                Tvar$ = "0"
                PUT #3, CheckingNumb& + 1, Tvar$
                CLOSE #3
        END IF
LOOP
CLOSE #1

PRINT
PRINT "BitPacking FOXTYPE.BLN..."

OPEN "FOXTYPE.BLN" FOR OUTPUT AS #1
OPEN "FOXTYPE.TMP" FOR BINARY AS #3
k$ = "@"
FOR x& = 1 TO 65536 STEP 8
        l$ = ""
        FOR y% = 1 TO 8
                GET #3, x& + y% - 1, k$
                l$ = l$ + k$
        NEXT y%
        PRINT #1, CHR$(Bin2Dec&(l$));
NEXT x&
CLOSE #1
CLOSE #3

PRINT
IF Wrong% = 1 THEN PRINT "Some glyphs aren't empty, please check it!" ELSE PRINT "FOXTYPE.640 is compliant with CHKBLANK.TXT."
KILL "FOXTYPE.TMP"
SYSTEM

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
BIN$ = wynik$

END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&

END FUNCTION

FUNCTION CheckBlank% (g&)

n% = 0
CALL Load(g&)

FOR x% = 1 TO 16
        IF Table(x%) <> "00000000" THEN n% = 1
NEXT x%

CheckBlank% = n%

END FUNCTION

FUNCTION Hex2Dec& (a$)
REM
REM  Function Hex2Dec - Converts a hexadecimal number to its decimal value
REM
REM  Warning: This function works only with numbers 0..FFFF !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
a$ = RIGHT$("0000" + a$, 4)

DIM aa(1 TO 4) AS LONG

FOR x% = 1 TO 4
aa(x%) = VAL(MID$(a$, x%, 1))

IF UCASE$(MID$(a$, x%, 1)) = "A" THEN aa(x%) = 10
IF UCASE$(MID$(a$, x%, 1)) = "B" THEN aa(x%) = 11
IF UCASE$(MID$(a$, x%, 1)) = "C" THEN aa(x%) = 12
IF UCASE$(MID$(a$, x%, 1)) = "D" THEN aa(x%) = 13
IF UCASE$(MID$(a$, x%, 1)) = "E" THEN aa(x%) = 14
IF UCASE$(MID$(a$, x%, 1)) = "F" THEN aa(x%) = 15

NEXT x%

a& = 0
a& = aa(4) + (aa(3) * 16) + (aa(2) * 256) + (aa(1) * 4096)
Hex2Dec& = a&

END FUNCTION

SUB Load (char&)

t1$ = "@"

OPEN "FOXTYPE.640" FOR BINARY AS #2
FOR x% = 1 TO 16
  GET #2, char& * 16 + x%, t1$
  Table(x%) = RIGHT$("00000000" + BIN$(ASC(t1$)), 8)
NEXT x%
CLOSE #2

END SUB

