DECLARE FUNCTION Bin2Dec& (value$)
DECLARE FUNCTION BIN$ (numb&)
DECLARE SUB Save (num&)
DECLARE SUB Load (bool&, Fil$)

DIM SHARED Table(1 TO 32) AS STRING * 16

CLS
PRINT
PRINT "IMPORT is a program which imports a foreign FOXTYPE.DAT type file and"
PRINT "compare it with the current FOXTYPE.DAT. Then it imports those glyphs"
PRINT "which are blank in the current version of FOXTYPE.DAT."
PRINT
PRINT "That program is working only with files containing 16x32 glyphs!"
PRINT
PRINT "Type the filename of the file you would like to import to FoxType:"
LINE INPUT "> ", File$
PRINT
PRINT "Processed char:";

FOR x& = 1 TO 65535
        LOCATE 11, 17: PRINT HEX$(x&);
        CALL Load(x&, "FOXTYPE.DAT")
        Blank% = 1
        FOR y% = 1 TO 32
            IF Table(y%) <> "0000000000000000" THEN Blank% = 0
        NEXT y%
        IF Blank% = 1 THEN
           CALL Load(x&, File$)
           CALL Save(x&)
           FOR y% = 1 TO 32
               IF Table(y%) <> "0000000000000000" THEN Blank% = 0
           NEXT y%
           IF Blank% = 0 THEN b& = b& + 1
        END IF
NEXT x&

PRINT
PRINT "Done!"; b&; " glyphs added."
END

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
        n& = numb& \ dzielnik& MOD 2
        dzielnik& = dzielnik& / 2
        x& = x& + n&
        IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"

BIN$ = wynik$
END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%

Bin2Dec& = Score&
END FUNCTION

SUB Load (bool&, Fil$)

char& = bool&

t1$ = "@"
t2$ = "@"

OPEN Fil$ FOR BINARY AS #1
FOR x% = 1 TO 32
  GET #1, char& * 64 + (2 * x%) - 1, t1$
  GET #1, char& * 64 + (2 * x%), t2$
  Table(x%) = RIGHT$("00000000" + BIN$(ASC(t1$)), 8) + RIGHT$("00000000" + BIN$(ASC(t2$)), 8)
NEXT x%
CLOSE #1

END SUB

SUB Save (num&)

OPEN "FOXTYPE.DAT" FOR BINARY AS #1
FOR x% = 1 TO 32
  t1$ = ""
  t2$ = ""
  t1$ = LEFT$(Table(x%), 8)
  t2$ = RIGHT$(Table(x%), 8)
  t1$ = CHR$(Bin2Dec&(t1$))
  t2$ = CHR$(Bin2Dec&(t2$))
  PUT #1, num& * 64 + (x% * 2) - 1, t1$
  PUT #1, num& * 64 + x% * 2, t2$
NEXT x%
CLOSE #1

END SUB

