DECLARE FUNCTION Bin2Dec& (value$)
DECLARE SUB Save (num&)
DECLARE FUNCTION Hex2Dec& (a$)

PRINT
PRINT "TXT2DAT converts the UNICODE.TXT file provided by Henrique to FOXTYPE.640."
PRINT
PRINT "Press any key to continue..."
DO: LOOP UNTIL INKEY$ <> ""

OPEN "UNICODE.TXT" FOR INPUT AS #2

DIM SHARED Table(1 TO 16) AS STRING * 8

DO
     LINE INPUT #2, Line$
     Charac& = Hex2Dec&(Line$)

     FOR x% = 1 TO 16
         LINE INPUT #2, Line$
         FOR y% = 1 TO 8
              IF MID$(Line$, y%, 1) = "." THEN MID$(Line$, y%, 1) = "0" ELSE MID$(Line$, y%, 1) = "1"
         NEXT y%
         Table(x%) = Line$
     NEXT x%

     CALL Save(Charac&)

LOOP UNTIL EOF(2)


CLOSE #2

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&

END FUNCTION

FUNCTION Hex2Dec& (a$)
REM
REM  Function Hex2Dec - Converts a hexadecimal number to its decimal value
REM
REM  Warning: This function works only with numbers 0..FFFF !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
a$ = RIGHT$("0000" + a$, 4)

DIM aa(1 TO 4) AS LONG

FOR x% = 1 TO 4
aa(x%) = VAL(MID$(a$, x%, 1))

IF UCASE$(MID$(a$, x%, 1)) = "A" THEN aa(x%) = 10
IF UCASE$(MID$(a$, x%, 1)) = "B" THEN aa(x%) = 11
IF UCASE$(MID$(a$, x%, 1)) = "C" THEN aa(x%) = 12
IF UCASE$(MID$(a$, x%, 1)) = "D" THEN aa(x%) = 13
IF UCASE$(MID$(a$, x%, 1)) = "E" THEN aa(x%) = 14
IF UCASE$(MID$(a$, x%, 1)) = "F" THEN aa(x%) = 15

NEXT x%

a& = 0
a& = aa(4) + (aa(3) * 16) + (aa(2) * 256) + (aa(1) * 4096)
Hex2Dec& = a&

END FUNCTION

SUB Save (num&)

OPEN "FOXTYPE.640" FOR BINARY AS #1
FOR x% = 1 TO 16
  t$ = ""
  t$ = Table(x%)
  t$ = CHR$(Bin2Dec&(t$))
  PUT #1, num& * 16 + x%, t$
NEXT x%
CLOSE #1

END SUB

