DECLARE FUNCTION Hex2Dec& (a$)
DECLARE FUNCTION Bin2Dec& (value$)
DECLARE FUNCTION BIN$ (numb&)
REM
REM UTF-8 Text file generator
REM
REM This program generates a text file called "0-FFFF.TXT" which contains
REM all Unicode characters in the range 0000-FFFFF.
REM

IF COMMAND$ = "" THEN
        PRINT "UTF-8 Char generator Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " 2006"
        PRINT
        PRINT
        PRINT "USAGE: UTFGEN xxxx           where xxxx is the hex number of the unicode char."
        PRINT
        PRINT "You can redirect the output to a file using:"
        PRINT "UTFGEN xxxx>file.txt (avoid any spaces between 'xxxx', '>' and 'file.txt')."
        GOTO Skip
END IF

b% = 0
c% = 0
FOR x% = 1 TO LEN(COMMAND$)
        IF MID$(COMMAND$, x%, 1) = HEX$(Hex2Dec&(MID$(COMMAND$, x%, 1))) THEN b% = x% ELSE c% = x%
NEXT x%

IF c% <> 0 THEN COMM$ = MID$(COMMAND$, 1, c%) ELSE COMM$ = MID$(COMMAND$, 1, b%)

DIM Table(1 TO 4) AS STRING

x& = Hex2Dec&(COMMAND$)

IF x& < 128 THEN PRINT CHR$(x&); : GOTO Skip

f$ = BIN$(x&)
Num% = 4
IF LEN(f$) <= 16 THEN Num% = 3
IF LEN(f$) <= 11 THEN Num% = 2

IF Num% = 2 THEN
         Table(2) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(1) = "110" + RIGHT$("00000" + f$, 5)
END IF

IF Num% = 3 THEN
         Table(3) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(2) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(1) = "1110" + RIGHT$("00000" + f$, 4)
END IF

IF Num% = 4 THEN
         Table(4) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(3) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(2) = "10" + RIGHT$("000000" + f$, 6)
         f$ = MID$(f$, 1, LEN(f$) - 6)
         Table(1) = "11110" + RIGHT$("00000" + f$, 3)
END IF

FOR x% = 1 TO Num%
         PRINT CHR$(Bin2Dec&(Table(x%)));
NEXT x%

Skip:

SYSTEM

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
BIN$ = wynik$

END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&

END FUNCTION

FUNCTION Hex2Dec& (a$)
REM
REM  Function Hex2Dec - Converts a hexadecimal number to its decimal value
REM
REM  Warning: This function works only with numbers 0..FFFF !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
a$ = RIGHT$("0000" + a$, 4)

DIM aa(1 TO 4) AS LONG

FOR x% = 1 TO 4
aa(x%) = VAL(MID$(a$, x%, 1))

IF UCASE$(MID$(a$, x%, 1)) = "A" THEN aa(x%) = 10
IF UCASE$(MID$(a$, x%, 1)) = "B" THEN aa(x%) = 11
IF UCASE$(MID$(a$, x%, 1)) = "C" THEN aa(x%) = 12
IF UCASE$(MID$(a$, x%, 1)) = "D" THEN aa(x%) = 13
IF UCASE$(MID$(a$, x%, 1)) = "E" THEN aa(x%) = 14
IF UCASE$(MID$(a$, x%, 1)) = "F" THEN aa(x%) = 15

NEXT x%

a& = 0
a& = aa(4) + (aa(3) * 16) + (aa(2) * 256) + (aa(1) * 4096)
Hex2Dec& = a&

END FUNCTION

