DECLARE FUNCTION Bin2Dec& (value$)
DECLARE SUB Load (char&)
DECLARE SUB Save (num&)
DECLARE FUNCTION BIN$ (numb&)
REM
REM This program takes the FOXTYPE.640 file which contain 8x16 chars, and
REM convert it to a 4-time bigger FOXTYPE.DAT which contain the same
REM chars, but converted to 16x32 matrixes.
REM

DIM SHARED Table(1 TO 16) AS STRING * 8
DIM SHARED Table16(1 TO 32) AS STRING * 16

CLS

FOR x& = 0 TO 65535
        LOCATE 1, 1: PRINT "Char: "; HEX$(x&)
        CALL Load(x&)

        FOR x% = 1 TO 16
                FOR y% = 1 TO 8
                        a$ = MID$(Table(x%), y%, 1)
                        MID$(Table16(x% * 2), y% * 2, 1) = a$
                        MID$(Table16(x% * 2 - 1), y% * 2, 1) = a$
                        MID$(Table16(x% * 2), y% * 2 - 1, 1) = a$
                        MID$(Table16(x% * 2 - 1), y% * 2 - 1, 1) = a$
                NEXT y%
        NEXT x%
        
        CALL Save(x&)
NEXT x&

PRINT "Done!"
SYSTEM

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
BIN$ = wynik$

END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&

END FUNCTION

SUB Load (char&)

OPEN "FOXTYPE.640" FOR BINARY AS #1
FOR x% = 1 TO 16
  GET #1, char& * 16 + x%, Table(x%)
  Table(x%) = RIGHT$("00000000" + BIN$(ASC(Table(x%))), 8)
NEXT x%
CLOSE #1

END SUB

SUB Save (num&)

OPEN "FOXTYPE.DAT" FOR BINARY AS #1
FOR x% = 1 TO 32
  t1$ = ""
  t2$ = ""
  t1$ = LEFT$(Table16(x%), 8)
  t2$ = RIGHT$(Table16(x%), 8)
  t1$ = CHR$(Bin2Dec&(t1$))
  t2$ = CHR$(Bin2Dec&(t2$))
  PUT #1, num& * 64 + (x% * 2) - 1, t1$
  PUT #1, num& * 64 + x% * 2, t2$
NEXT x%
CLOSE #1

END SUB

