DECLARE SUB SwapMatrix ()
DECLARE SUB MoveUp ()
DECLARE SUB MoveDown ()
DECLARE SUB MoveLeft ()
DECLARE SUB MoveRight ()
DECLARE SUB Hmirror ()
DECLARE SUB Vmirror ()
DECLARE SUB RefreshDisplay (Xpos%, Ypos%)
DECLARE SUB InitDisplay ()
DECLARE SUB Load (bool&)
DECLARE SUB Save (num&)
DECLARE FUNCTION BIN$ (numb&)
DECLARE FUNCTION Hex2Dec& (a$)
DECLARE FUNCTION Bin2Dec& (value$)

DIM SHARED Table(1 TO 32) AS STRING * 16
DIM SHARED WorkOn(1 TO 32) AS STRING * 16

SCREEN 12
Restart:

FOR x% = 1 TO 32
        WorkOn(x%) = "                                "
NEXT x%

CLS

COLOR 14
PRINT "      Character Editor for FoxType, Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " 2006"
COLOR 7
LOCATE 10, 1
LINE INPUT "Please enter the HEX number of the character you want edit: ", num$
CLS
COLOR 14
PRINT "      Character Editor for FoxType, Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " 2006"
COLOR 7
PRINT
PRINT "Edited character: "; RIGHT$("0000" + num$, 4);

LOCATE 10, 50: PRINT "ESC: Quit"
LOCATE 12, 50: PRINT "S: Save"
LOCATE 13, 50: PRINT "C: Copy from..."
LOCATE 14, 50: PRINT "W: Work on another..."
LOCATE 16, 50: PRINT "PgDn: Next char"
LOCATE 17, 50: PRINT "PgUp: Prev char"

LOCATE 6, 2: PRINT "SPC: Mark pixel";
LOCATE 7, 2: PRINT "TAB: Swap matrix";
LOCATE 9, 2: PRINT "H: HorMirror";
LOCATE 10, 2: PRINT "V: VerMirror";
LOCATE 12, 2: PRINT "8: Move up";
LOCATE 13, 2: PRINT "2: Move down";
LOCATE 14, 2: PRINT "4: Move left";
LOCATE 15, 2: PRINT "6: Move right";

num& = Hex2Dec&(num$)
CALL Load(num&)

Xpos% = 1
Ypos% = 1

CALL InitDisplay

DO

CALL RefreshDisplay(Xpos%, Ypos%)

DO: LastKey$ = INKEY$
LOOP UNTIL LastKey$ <> ""
LastKey$ = UCASE$(LastKey$)

IF LastKey$ = CHR$(0) + "H" AND Ypos% > 1 THEN Ypos% = Ypos% - 1
IF LastKey$ = CHR$(0) + "P" AND Ypos% < 32 THEN Ypos% = Ypos% + 1
IF LastKey$ = CHR$(0) + "K" AND Xpos% > 1 THEN Xpos% = Xpos% - 1
IF LastKey$ = CHR$(0) + "M" AND Xpos% < 16 THEN Xpos% = Xpos% + 1

IF LastKey$ = " " THEN
  IF MID$(Table(Ypos%), Xpos%, 1) = "1" THEN MID$(Table(Ypos%), Xpos%, 1) = "0" ELSE MID$(Table(Ypos%), Xpos%, 1) = "1"
END IF
IF LastKey$ = "S" THEN CALL Save(num&)
IF LastKey$ = "C" THEN CALL Load(-1)
IF LastKey$ = "H" THEN CALL Hmirror
IF LastKey$ = "V" THEN CALL Vmirror
IF LastKey$ = "W" THEN GOTO Restart
IF LastKey$ = "8" THEN CALL MoveUp
IF LastKey$ = "2" THEN CALL MoveDown
IF LastKey$ = "4" THEN CALL MoveLeft
IF LastKey$ = "6" THEN CALL MoveRight
IF LastKey$ = CHR$(0) + "Q" AND num& < 65535 THEN
        num& = num& + 1
        LOCATE 3, 19: PRINT RIGHT$("0000" + HEX$(num&), 4);
        CALL Load(num&)
        FOR x% = 1 TO 32
                WorkOn(x%) = "                                "
        NEXT x%
END IF
IF LastKey$ = CHR$(0) + "I" AND num& > 0 THEN
        num& = num& - 1
        LOCATE 3, 19: PRINT RIGHT$("0000" + HEX$(num&), 4);
        CALL Load(num&)
        FOR x% = 1 TO 32
                WorkOn(x%) = "                                "
        NEXT x%
END IF

IF LastKey$ = CHR$(9) THEN CALL SwapMatrix
LOOP UNTIL LastKey$ = CHR$(27)
CLS
SYSTEM

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
BIN$ = wynik$
END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&
END FUNCTION

FUNCTION Hex2Dec& (a$)
REM
REM  Function Hex2Dec - Converts a hexadecimal number to its decimal value
REM
REM  Warning: This function works only with numbers 0..FFFF !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
a$ = RIGHT$("0000" + a$, 4)

DIM aa(1 TO 4) AS LONG

FOR x% = 1 TO 4
aa(x%) = VAL(MID$(a$, x%, 1))

IF UCASE$(MID$(a$, x%, 1)) = "A" THEN aa(x%) = 10
IF UCASE$(MID$(a$, x%, 1)) = "B" THEN aa(x%) = 11
IF UCASE$(MID$(a$, x%, 1)) = "C" THEN aa(x%) = 12
IF UCASE$(MID$(a$, x%, 1)) = "D" THEN aa(x%) = 13
IF UCASE$(MID$(a$, x%, 1)) = "E" THEN aa(x%) = 14
IF UCASE$(MID$(a$, x%, 1)) = "F" THEN aa(x%) = 15

NEXT x%

a& = 0
a& = aa(4) + (aa(3) * 16) + (aa(2) * 256) + (aa(1) * 4096)
Hex2Dec& = a&
END FUNCTION

SUB Hmirror
DIM TempArray(1 TO 32) AS STRING * 16

FOR x% = 1 TO 32
      TempArray(33 - x%) = Table(x%)
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB InitDisplay

REM 176x352
LINE (181, 80)-(373, 464), 1, BF

LINE (411, 79)-(430, 114), 1, B

END SUB

SUB Load (bool&)

char& = bool&

IF bool& = -1 THEN
   COLOR 7
   LOCATE 2, 1
   LINE INPUT "Please enter the HEX number of the character you want load: ", num$
   LOCATE 2, 1: PRINT SPACE$(79);
   char& = Hex2Dec&(num$)
END IF

t1$ = "@"
t2$ = "@"

OPEN "FOXTYPE.DAT" FOR BINARY AS #1
FOR x% = 1 TO 32
  GET #1, char& * 64 + (2 * x%) - 1, t1$
  GET #1, char& * 64 + (2 * x%), t2$
  Table(x%) = RIGHT$("00000000" + BIN$(ASC(t1$)), 8) + RIGHT$("00000000" + BIN$(ASC(t2$)), 8)
NEXT x%
CLOSE #1
END SUB

SUB MoveDown

DIM TempArray(1 TO 32) AS STRING * 16

TempArray(1) = Table(32)

FOR x% = 2 TO 32
      TempArray(x%) = Table(x% - 1)
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB MoveLeft

DIM TempArray(1 TO 32) AS STRING * 16

FOR x% = 1 TO 32
      FOR y% = 1 TO 15
              MID$(TempArray(x%), y%, 1) = MID$(Table(x%), y% + 1, 1)
      NEXT y%
      MID$(TempArray(x%), 16, 1) = MID$(Table(x%), 1, 1)
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB MoveRight

DIM TempArray(1 TO 32) AS STRING * 16

FOR x% = 1 TO 32
      FOR y% = 2 TO 16
              MID$(TempArray(x%), y%, 1) = MID$(Table(x%), y% - 1, 1)
      NEXT y%
      MID$(TempArray(x%), 1, 1) = MID$(Table(x%), 16, 1)
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB MoveUp

DIM TempArray(1 TO 32) AS STRING * 16

TempArray(32) = Table(1)

FOR x% = 1 TO 31
      TempArray(x%) = Table(x% + 1)
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB RefreshDisplay (Xpos%, Ypos%)

FOR y% = 1 TO 32
  FOR x% = 1 TO 16
    IF MID$(Table(y%), x%, 1) = "1" THEN c% = 2 ELSE c% = 0
    IF MID$(Table(y%), x%, 1) <> MID$(WorkOn(y%), x%, 1) OR Xpos% = x% OR Ypos% = y% THEN
        MID$(WorkOn(y%), x%, 1) = MID$(Table$(y%), x%, 1)
        LINE (182 + 12 * (x% - 1), 81 + 12 * (y% - 1))-(182 + 12 * (x% - 1) + 10, 81 + 12 * (y% - 1) + 10), c%, BF
        PSET (412 + x%, 80 + y%), c% * 3 + 1
    END IF
  NEXT x%
NEXT y%

LOCATE 30, 1: PRINT "Position: ["; LTRIM$(STR$(Xpos%)); ","; RTRIM$(STR$(Ypos%)); "] ";
LINE (182 + 12 * (Xpos% - 1), 81 + 12 * (Ypos% - 1))-(182 + 12 * (Xpos% - 1) + 10, 81 + 12 * (Ypos% - 1) + 10), 14, B

END SUB

SUB Save (num&)

OPEN "FOXTYPE.DAT" FOR BINARY AS #1
FOR x% = 1 TO 32
  t1$ = ""
  t2$ = ""
  t1$ = LEFT$(Table(x%), 8)
  t2$ = RIGHT$(Table(x%), 8)
  t1$ = CHR$(Bin2Dec&(t1$))
  t2$ = CHR$(Bin2Dec&(t2$))
  PUT #1, num& * 64 + (x% * 2) - 1, t1$
  PUT #1, num& * 64 + x% * 2, t2$
NEXT x%
CLOSE #1

SOUND 900, 1
END SUB

SUB SwapMatrix

DIM TempArray(1 TO 32) AS STRING * 16

FOR x% = 1 TO 32
      FOR y% = 1 TO 16
              IF MID$(Table(x%), y%, 1) = "0" THEN
                  MID$(TempArray(x%), y%, 1) = "1"
               ELSE
                  MID$(TempArray(x%), y%, 1) = "0"
               END IF
      NEXT y%
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%

END SUB

SUB Vmirror

DIM TempArray(1 TO 32) AS STRING * 16

FOR x% = 1 TO 32
      FOR y% = 1 TO 16
              MID$(TempArray(x%), y%, 1) = MID$(Table(x%), 17 - y%, 1)
      NEXT y%
NEXT x%

FOR x% = 1 TO 32
      Table(x%) = TempArray(x%)
NEXT x%


END SUB

