{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

const
    DriverVersionCompat = 0; { Inferno Driver compatibility version, 0 = devel }

    { Standard DOS & Pascal Error Codes }
	erNo_Error                          = 0;
	erInvalid_Function_Number           = 1;
	erFile_Not_Found                    = 2;
	erPath_Not_Found                    = 3;
	erToo_Many_Open_Files               = 4;
	erFile_Access_Denied                = 5;
	erInvalid_File_Handle               = 6;
	erInsufficient_Memory               = 8;
	erInvalid_File_Access_Code          = 12;
	erInvalid_Data                      = 13;
	erInvalid_Drive_Number              = 15;
	erCannot_Remove_Current_Directory   = 16;
	erCannot_Rename_Across_Drives       = 17;
	erNo_More_Files                     = 18;
	erDisk_Write_Protected              = 19;
	erUnknown_Unit_ID                   = 20;
	erDisk_Not_Ready                    = 21;
	erUnknown_Command                   = 22;
	erDisk_CRC_error                    = 23;
	erDisk_Read_Error                   = 100;
	erDisk_Write_Error                  = 101;
	erFile_Not_Assigned                 = 102;
	erFile_Not_Open                     = 103;
	erFile_Not_Open_For_Input           = 104;
	erFile_Not_Open_For_Output          = 105;
	erInvalid_Numeric_Format            = 106;
	erDisk_Is_Writeprotected            = 150;
	erBad_Drive_Request_Struct_Length   = 151;
	erDrive_Not_Ready                   = 152;
	erCRC_Error_In_Data                 = 154;
	erDisk_Seek_Error                   = 156;
	erUnknown_Media_Type                = 157;
	erSector_Not_Found                  = 158;
	erPrinter_Out_Of_Paper              = 159;
	erDevice_Write_Fault                = 160;
	erDevice_Read_Fault                 = 161;
	erHardware_Failure                  = 162;
	erDivision_By_Zero                  = 200;
	erRange_Check_Error                 = 201;
	erStack_Overflow                    = 202;
	erHeap_Overflow                     = 203;
	erInvalid_Pointer_Operation         = 204;
	erFloating_Point_Overflow           = 205;
	erFloating_Point_Underflow          = 206;
	erInvalid_Floating_Point_Operation  = 207;
	erOverlay_Manager_Not_Installed     = 208;
	erOverlay_File_Read_Error           = 209;
	erObject_Not_Initialized            = 210;
	erCall_To_Abstract_Method           = 211;
	erStream_Registration_Error         = 212;
	erCollection_Index_Out_Of_Range     = 213;
	erCollection_Overflow               = 214;
	erArithmetic_Overflow               = 215;
	erGeneral_Protection_Fault          = 216;

	{ Custom Error Codes }
	erType_Check_Error                  = 220;
	erOperation_Not_Supported           = 221;
	erInvalid_File_Format               = 222;
	erStructure_Too_Large               = 223;
	erData_Verification_Error           = 224;
	erUnassigned_Pointer_Error          = 225;
	erDispose_Locked_Asset_Error        = 226;
	erCompressed_Image_Error            = 227;
    erInitialization_Failure	        = 230;
    erMaligned_Driver_Error             = 231;
    erUnsupported_Driver_Error          = 232;
    erInvalid_Driver_Error	            = 233;
    erDriver_Verification_Error         = 234;
	erGraphics_Driver_Failure           = 240;
	erAudio_Driver_Failure              = 241;
	erKeyboard_Driver_Failure           = 242;
	erMouse_Driver_Failure              = 243;
	erJoystick_Driver_Failure           = 244;
	erGraphics_Subsystem_Failure        = 245;
	erAudio_Subsystem_Failure           = 246;
	erMissing_Asset_Error               = 250;
	erInvalid_Asset_Error               = 251;

    { image mask draw modes }
    imCOPY  = 0;
    imAND   = 1;
    imNOT   = 2;
    imOR    = 3;
    imXOR   = 4;

    { Image, stage, etc. move/shift constants (same as keypad number order )}
    dmDownLeft  = 1; { Upper Right to Lower Left }
    dmDown      = 2; { Top to Bottom }
    dmDownRight = 3; { Upper Left to Lower Right }
    dmLeft      = 4; { Right to Left }
    dmNowhere   = 5;
    dmRight     = 6; { Left to Right }
    dmUpLeft    = 7; { Lower Right to Upper Left }
    dmUp        = 8; { Bottom to Top }
    dmUpRight   = 9; { Lower Left to Upper Right }

    { Sprite types }
    skDefault       = $00;
    skMenuItem      = $b0;
    skButtonItem    = $d0;
    skMouse         = $f0;

    { Sprite levels }
    slDefault       = $20;
    slMenuItem      = $b0;
    slButtonItem    = $d0;
    slMouse         = $f0;

    { Menu / Button States }
    msNone        = $00;
    msDisabled    = $01;
    msNormal      = $02;
    msHover       = $03;
    msClick       = $04;
    msActive      = $05; { only valid for sticky buttons }

    { Event types }
    evNull          = $0000;
    evKeyPress      = $0001;
    evKeyRelease    = $0002;
    evMouseClick    = $0010;
    evMouseRelease  = $0020;
    evMouseDouble   = $0040;
    evMouseMove     = $0080;
    evKeyboard      = $000f;
    evMouse         = $00f0;
    evCommand       = $1000;

    { Event commands }
    cmNone          = $0000;
    cmMenuFileu     = $0010;
    cmMenuEdit      = $0020;
    cmMenuTools     = $0030;
    cmMenuHelp      = $00F0;

    cmFileNew       = $0011;
    cmFileOpen      = $0012;
    cmFileSave      = $0013;
    cmFileSaveAs    = $0014;
    cmFileClose     = $0015;

    cmAbout         = $00f1;

    cmUser          = $1000;

    cmExit          = $ffff;
    cmSeparator     = $fffe;

    { Keyboard Shift State Flags }
    kssInsertState      = $0080;
    kssCapsLockState    = $0040;
    kssNumLockState     = $0020;
    kssScrollLockState  = $0010;
    kssAnyAlt           = $0008;
    kssAnyCtrl          = $0004;
    kssLeftShift        = $0002;
    kssRightShift       = $0001;
    kssInsert           = $8000;
    kssCapsLock         = $4000;
    kssNumLock          = $2000;
    kssScrollLock       = $1000;
    kssPauseState       = $0800;
    kssSysReqDown       = $0400;
    kssLeftAlt          = $0200;
    kssLeftCtrl         = $0100;

    kssUppercase        = kssLeftShift or kssRightShift or kssCapsLock or kssCapsLockState;

    { Keyboard State Flags }
    ksfCapsLock         = $0400; { Used to keep CapsLock in sync }
    ksfNumLock          = $0200;
    ksfScrollLock       = $0100;
    ksfEnhancedKeyboard = $0010;
    ksfRightAlt         = $0008;
    ksfRightCtrl        = $0004;

    { Keyboard Event KeyCodes }
    kbNone          = $0000;
    kbEscape        = $001B;
    kbEnter         = $000D;
    kbTab           = $0009;
    kbBackspace     = $0008;
    kbMinus         = $002D;
    kbUnderscore    = $005F;
    kbEqual         = $003D;
    kbPlus          = $002B;
    kbSpace         = $0020;

    kb0      = $0030; kbShift0 = $0029;
    kb1      = $0031; kbShift1 = $0021;
    kb2      = $0032; kbShift2 = $0040;
    kb3      = $0033; kbShift3 = $0023;
    kb4      = $0034; kbShift4 = $0024;
    kb5      = $0035; kbShift5 = $0025;
    kb6      = $0036; kbShift6 = $005E;
    kb7      = $0037; kbShift7 = $0026;
    kb8      = $0038; kbShift8 = $002A;
    kb9      = $0039; kbShift9 = $0028;
    kbA      = $0061; kbShiftA = $0041;
    kbB      = $0062; kbShiftB = $0042;
    kbC      = $0063; kbShiftC = $0043;
    kbD      = $0064; kbShiftD = $0044;
    kbE      = $0065; kbShiftE = $0045;
    kbF      = $0066; kbShiftF = $0046;
    kbG      = $0067; kbShiftG = $0047;
    kbH      = $0068; kbShiftH = $0048;
    kbI      = $0069; kbShiftI = $0049;
    kbJ      = $006A; kbShiftJ = $004A;
    kbK      = $006B; kbShiftK = $004B;
    kbL      = $006C; kbShiftL = $004C;
    kbM      = $006D; kbShiftM = $004D;
    kbN      = $006E; kbShiftN = $004E;
    kbO      = $006F; kbShiftO = $004F;
    kbP      = $0070; kbShiftP = $0050;
    kbQ      = $0071; kbShiftQ = $0051;
    kbR      = $0072; kbShiftR = $0052;
    kbS      = $0073; kbShiftS = $0053;
    kbT      = $0074; kbShiftT = $0054;
    kbU      = $0075; kbShiftU = $0055;
    kbV      = $0076; kbShiftV = $0056;
    kbW      = $0077; kbShiftW = $0057;
    kbX      = $0078; kbShiftX = $0058;
    kbY      = $0079; kbShiftY = $0059;
    kbZ      = $007A; kbShiftZ = $005A;

    { Keyboard Scan Codes }
    scEscape    = $0001;
    scTab       = $000f;
    scCaps      = $003a;
    scShiftLeft = $002a;
    scShiftRight= $0036;
    scCtrlLeft  = $001d;
    scCtrlRight = $e01d;
    scAltLeft   = $0038;
    scAltRight  = $e038;
    scReturn    = $001c;    scNumPadEnter       = $e01c;
    scBackspace = $000e;
    scF1        = $003b;
    scF2        = $003c;
    scF3        = $003d;
    scF4        = $003e;
    scF5        = $003f;
    scF6        = $0040;
    { some scF7 + keys not available in DOSBox on Mac }
    scF10       = $0044;
    scF12       = $0058;
    scPgUp      = $e049;    scNumPad9       = $0049;
    scPgDn      = $e051;    scNumPad3       = $0051;
    scHome      = $e047;    scNumPad7       = $0047;
    scEnd       = $e04f;    scNumPad1       = $004f;
    scUp        = $e048;    scNumPad8       = $0048;
    scDown      = $e050;    scNumPad2       = $0050;
    scLeft      = $e04b;    scNumPad4       = $004b;
    scRight     = $e04d;    scNumPad6       = $004d;
    scIns       = $e052;    scNumPad0       = $0052;
    scDel       = $e053;    scNumPadPeriod  = $0053;
                            scNumPad5       = $004c;
                            scNumPadPlus    = $004e;
                            scNumPadMinus   = $004a;
                            scNumPadMultiply= $0037;
                            scNumPadDivide  = $e035;
                            scNumPadClear   = $0045;
                            scNumLock       = scNumPadClear;
    { Real Hardware, Not in DOSBox on Mac }

    { note... Logitech Media Keyboard/ current driver when NumsLock is On it
      sends Ins, Del, Home, End, PgUp, PgDn, PrtScr scancode E02A then
      the Scancode for key (and keycode E000). With NumsLock disabled,
      it justs sends the normal scancode (keycode 0000). The Scroll wheel
      always just sends just Up/Down Scancode. Reverse is sent on key release.

      PrintScreen and Pause Keys do not send scancode when either Control key
      is pressed. Pause Key sequence is E11D then 0045. Driver just sends E145
      to differentiate from NumsLock/NumClear key.

      Keyboard driver is a work in progress. :-)

      }

    scF7        = $0041;
    scF8        = $0042;
    scF9        = $0043;
    scF11       = $0057;

    scPrtScr    = $e037; { Also SysReq Key }
    scScrollLock= $0046;
    scPause     = $e145; { also Break key}
    scLeftWin   = $e05b;
    scRightWin  = $e05c;
    scMenu      = $e05d;

    scGo        = $e069;
    scBack      = $e06a;
    scSleep     = $e05f;
    scFinance   = $e013;
    scMySites   = $e014;
    scCommunity = $e015;
    scFavorites = $e066;
    scITouch    = $e012;
    scEMail     = $e06c;
    scShopping  = $e011;
    scSearch    = $e065;
    scMyHome    = $e032;
    scMedia     = $e06d;
    scMute      = $e020;
    scVolDn     = $e02e;
    scVolUp     = $e030;
    scPrevTrack = $e010;
    scNextTrack = $e019;
    scPlayPause = $e022;
    scStop      = $e024;

    { FIndFirst/Next file attributes constants }
    faReadOnly   = $01;
    faHidden     = $02;
    faSystem     = $04;
    faVolumeID   = $08;
    faDirectory  = $10;
    faArchive    = $20;
    faAnyFile    = $3F;

    { File Types }
    ffUnknown       = 0;
    ffDriver        = 1;
    ffBitmapFont    = 2;
    ffImage         = 3;
    ffSprite        = 4;
    ffAudio         = 5;
    ffText          = 6;
    ffNLS           = 7;
    ffNLSText       = 8;
    ffBinary        = 9;

    { Asset Sources }
    asNowhere             = 0;
    asPreferAssetFile     = 1;
    asPreferStandAlone    = 2;
    asOnlyAssetFile       = 3;
    asOnlyStandAlone      = 4;
    asDefault             = asPreferStandAlone;

    { Pixel remapping modes }
    ipmIgnore        = 0; { ignore image file palette, only games }
    ipmComplete      = 1; { just override current palette, mostly for games }
    ipmMatch         = 2; { remap image to best match existing colors, stuff }
    ipmOverride      = 3; { best match and replace colors > 15, viewing apps }
    ipmPooled        = 4; { remap using color pool matching, general apps }

    { Image Compression Types }
    icaUncompressed  = 0;
    icaRunLine       = 1;    { RLE_8 }
    icaRunLine4      = 2;    { RLE_4; not supported at present }
    icaDataRun       = 128;  { Simplified type of RLE }
    icaCanNotCompress= 255;

    { File ID strings; Pretty much only used internally }
  	fiXBINRSRC    : string[10]  = 'XBINRSRCv2';
    fiBitFontFile : String[6]   = 'BITFNT';
    fiInferno     : String[9]   = 'INFERNO';

    dcVideo       : String[9]   = 'VIDEO';
    dcAudio       : String[9]   = 'AUDIO';
    dcKeyBoard    : String[9]   = 'KEYBOARD';
    dcMouse       : String[9]   = 'MOUSE';
    dcJoystick    : String[9]   = 'JOYSTICK';
    dcAllTypes    : String      = 'VIDEO,AUDIO,KEYBOARD,MOUSE,JOYSTICK';

    { Some other consts }
    PathDelim : Char = '\'; { Path/directory separator }
    NLSDelim  : Char = '|'; { Separates parameters for String Formatting  }
    NLSVarTag : Char = '%'; { Prefix in string for NLS tags, like % for %0, %1 }
{$ENDIF}

{$IFDEF SECTIMP}
{$ENDIF}