{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

type
    TVideoMode = record
        Mode, Width, Height, ColorDepth : word;
    end;
    PVideoModes = ^TVideoModes;
    TVideoModes = array[0..8190] of TVideoMode;
    TProcedure      = procedure;

    { Mandatory Types }
    TGetAsciiZ      = function : PAsciiZ;
    TGetModes       = function : PVideoModes;
    TOpenVideo      = function ( Mode : Word ) : integer;
    TCloseVideo     = TProcedure;
    TSetSync        = procedure (Enable : boolean);
    TSetBuffered    = procedure (Enable : boolean);
    TUpdateVideo    = TProcedure;
    TUpdateForce    = TProcedure;
    TGetPalettes    = procedure (var Palettes : TRGBPalettes);
    TSetPalettes    = procedure (Palettes : TRGBPalettes);
    TGetColorProfile= function (Profile : word; var Palettes : TRGBPalettes): boolean;
    TGetPixel       = function (X, Y : integer) : TColor;
    TPutPixel       = procedure (X, Y : integer; Color : TColor);
    TImageSize      = function (Width, Height : word) : word;
    TImageGetPixel  = function (Image : PImage; X, Y : integer) : word;
    TImagePutPixel  = procedure (var Image : PImage; X, Y : integer; Color : word);
    { Performance Types }
    TFill           = procedure (Color : TColor);
    TRegion         = procedure (x1, y1, x2, y2 : integer; Color : TColor);
    TImageFill      = procedure (var Image : PImage; Color : TColor);
    TImageRegion    = procedure (var Image : PImage; x1, y1, x2, y2 : integer; Color : TColor);
    TGetImage       = procedure (var Image : PImage; X, Y : integer);
    TPutImage       = procedure (Image : PImage; X, Y : integer);
    TPutImageMode   = procedure (Image : PImage; X, Y : integer; Mode : word);
    TPutMask        = procedure (Mask : PMask; X, Y : integer);
    TPutMaskMode    = procedure (Mask : PMask; X, Y : integer; Mode : word);
    TPutBits        = procedure (Bits : Pointer; x, y : integer; BytesW, BytesH : byte; Color : TColor);
    TPutImageBits   = procedure (var Image : PImage; Bits : Pointer; x, y : integer; BytesW, BytesH : byte; Color : TColor);
    TImageToMask    = function (Image : PImage; Color : TColor) : PMask;
    TMaskToImage    = function (Mask : PMask; Color : TColor) : PImage;
    TMaskInvert     = procedure (var Mask : PMask);
    TShift          = procedure (Direction: word; Count : Word; Fill : TFillColor);
    TShiftRegion    = procedure (x1, y1, x2, y2 : integer; Direction: TDirection; Count : Word; Fill : TFillColor);
    TShiftImage     = procedure (var Image : PImage; Direction: TDirection; Count : Word; Fill : TFillColor);
    TShiftImageRegion = procedure (var Image : PImage; x1, y1, x2, y2 : integer; Direction: word;
        Count : Word; Fill : TFillColor);
    TImageFlip      = procedure (var Image : PImage);
    TImageMirror    = TImageFlip;
    { High Level Types }
    TMemAlloc       = function(Size : word; Aligned : boolean) : Pointer;
    TMemRelease     = procedure(var P : pointer; Size : Word);
    TUpdatePrepare  = TProcedure;
    TUpdate         = TProcedure;
    TNewImage       = function (Width, Height : word) : PImage;
    TFreeImage      = procedure (var Image : PImage);
    TCloneImage     = function (Image : PImage) : PImage;
    TNewMask        = function (Width, Height : word) : PMask;
    TFreeMask       = procedure (var Mask : PMask);
    TCloneMask      = function (Mask : PMask) : PMask;
    TImageSizeOf    = function (Image : PImage) : word;
    TMaskSize       = TImageSize;
    TMaskSizeOf     = function (Mask : PMask) : word;
    TFadePalettes   = procedure (var Palettes : TRGBPalettes; Percent : word);
    TFadeOut        = TSetPalettes;
    TFadeIn         = TSetPalettes;
    TImageRemap     = procedure (var Image : PImage; Pal : TRGBPalettes; var ImagePal : TRGBPalettes; Mode : word);
    TNewFont        = function (Width, Height : word) : PFont;
    TFreeFont       = procedure(var Font : PFont);
    TGetFont        = function : PFont;
    TSetFont        = procedure (Font : PFont);
    TGetMonospace   = function : boolean;
    TSetMonospace   = procedure (Monospace : boolean);
    TGetFontDirection = function : TDirection;
    TSetFontDirection = procedure (Direction : TDirection);
    TPutChar        = procedure (X, Y : integer; C : Char; Color : TColor);
    TPutText        = procedure (X, Y : integer; Str : String; Color : TColor);
    TImagePutChar   = procedure (var Image : PImage; X, Y : integer; C : Char; Color : TColor);
    TImagePutText   = procedure (var Image : PImage; X, Y : integer; Str : String; Color : TColor);
    TTextWidth      = function (Str : String) : integer;
    TTextHeight     = TTextWidth;

    TNewSprite      = function (Width, Height, Count : word; Populate : boolean) : PSprite;
    TFreeSprite     = procedure (var Sprite : PSprite);
    TCloneSprite    = function (Sprite : PSprite) : PSprite;

    TSpriteSizeOf    = function (Sprite : PSprite) : LongInt;
    TSpriteSort     = TProcedure;
    TSpriteRemove   = procedure (var Sprite : PSprite);
    TSpriteAdd      = procedure (var Sprite : PSprite);

    TSpriteSetVisible=procedure (var Sprite : PSprite; Visible : boolean);
    TSpriteUndraw   = procedure (var Sprite : PSprite);
    TSpriteUndrawArea   = procedure (Area : TArea);
    TSpriteUndrawAll    = TProcedure;
    TSpriteShow     = procedure (var Sprite : PSprite);
    TSpriteHide     = procedure (var Sprite : PSprite);
    TSpriteChange   = procedure (var Sprite : PSprite; Index : word);
    TSpriteNext     = procedure (var Sprite : PSprite);
    TSpriteNextAll  = procedure (Hidden : boolean);
    TSpriteCovers   = function (var Sprite : PSprite; x, y : integer) : boolean;
    TSpriteMove     = procedure (var Sprite : PSprite; x, y : integer);
    TSpriteWhere    = procedure (var Sprite : PSprite; var Where : TPoint);
    TSpriteCollide  = function (var Sprite : PSprite; x, y : integer) : PSprite;
    TUpdateSprites  = TProcedure;
    TSpriteGetSeq   = function (var Sprite : PSprite) : word;
    TSpriteSetSeq   = function (var Sprite : PSprite; Seq : word) : word;

    TFrame          = procedure (Thickness : Integer; Color1, Color2 : TColor);
    TFrameRegion    = procedure (x1, y1, x2, y2 : integer; Thickness : Integer;
        Color1, Color2 : TColor);
    TImageFrame     = procedure (Image : PImage; Thickness : Integer; Color1, Color2 : TColor);
    TFloodFill      = procedure (X, Y : integer; Color : TColor);
    TImageFloodFill = procedure (Image : PImage; X, Y : integer; Color : TColor);

    TImageImplode   = function (var Image : PImage) : boolean;
    TImageExplode   = function (var Image : PImage) : boolean;
    TMaskImplode    = function (var Mask : PMask) : boolean;
    TMaskExplode    = function (var Mask : PMask) : boolean;

    { Optional Types }
    TGetViewPort    = procedure (var Area : TArea); { not implemented }
    TSetViewPort    = procedure (Area : TArea); { not implemented }
    TGetExtendedData= function : pointer;

    PDriver = ^TDriver;
    TDriver = record
        Platform        : String[9];    { fiInferno }
        Class           : String[9];    { included in dcAllTypes }
        Name            : String[31];   { name of driver }
        Version         : word;         { 0x00.0x00 version number }
        VersionCompat   : word;         { Inferno version compatibility }
        CPU             : word;         { 0=8086, 1=186, 2=286, etc }
        Flags           : word;
        MinimumMemory   : LongInt;  { Minimum amount of memory to initialize }
        { end 64 byte header }
        Reserved        : array[0..31] of word;
        { end 64 byte shared data }
        GetCopyright    : TGetAsciiZ;
        GetLicense      : TGetAsciiZ;
    end;

    PNullDriver = ^TNullDriver;
    TNullDriver = record
        Header : TDriver;
        EndOfProcs      : DWord;
    end;

    PVideoDriver = ^TVideoDriver;
    TVideoDriver = record
        { Header }
        Platform        : String[9];
        Class           : String[9];
        Name            : String[31];
        Version         : word;
        VersionCompat   : word;     { Inferno version compatibility, 0 - devel }
        CPU             : word;
        Flags           : word;
        MinimumMemory   : LongInt;
        { end 64 byte header }
        { Driver Specific Data }
        { These are MAX values. Unless in graphics mode, then are for mode }
        Width           : word; { Screen Width when graphics open }
        Height          : word; { Screen Height when graphics open }
        ColorDepth      : word; { ColorDepth when graphics open }
        Colors          : word; { Colors when ColorDepth 16 or less}
        ColorProfiles   : word; { Number of color palette profiles }
        FontSettings    : TFontSettings;
        Reserved        : array[0..22] of word;
        { end 64 byte shared data }
        { Manditory }
        GetCopyright    : TGetAsciiZ;
        GetLicense      : TGetAsciiZ;
        GetModes        : TGetModes;
        Open            : TOpenVideo;
        Close           : TCloseVideo;
        SetSync         : TSetSync;
        SetBuffered     : TSetBuffered;
        UpdateVideo     : TUpdateVideo;
        UpdateForce     : TUpdateForce;
        GetPalettes     : TGetPalettes;
        SetPalettes     : TSetPalettes;
        GetColorProfile : TGetColorProfile;
        GetPixel        : TGetPixel;
        PutPixel        : TPutPixel;
        ImageSize       : TImageSize;
        ImageGetPixel   : TImageGetPixel;
        ImagePutPixel   : TImagePutPixel;
        { Performance }
        Fill            : TFill;
        Region          : TRegion;
        ImageFill       : TImageFill;
        ImageRegion     : TImageRegion;
        GetImage        : TGetImage;
        PutImage        : TPutImage;
        PutImageMode    : TPutImageMode;
        PutMask         : TPutMask;
        PutMaskMode     : TPutMaskMode;
        PutBits         : TPutBits;
        PutImageBits    : TPutImageBits;
        ImageToMask     : TImageToMask;
        MaskToImage     : TMaskToImage;
        MaskInvert      : TMaskInvert;
        Shift           : TShift;
        ShiftRegion     : TShiftRegion;
        ShiftImage      : TShiftImage;
        ShiftImageRegion: TShiftImageRegion;
        ImageFlip       : TImageFlip;
        ImageMirror     : TImageMirror;
        Frame           : TFrame;
        FrameRegion     : TFrameRegion;
        ImageFrame      : TImageFrame;
        FloodFill       : TFloodFill;
        ImageFloodFill  : TImageFloodFill;
        ImageImplode    : TImageImplode;
        ImageExplode    : TImageExplode;
        MaskImplode     : TMaskImplode;
        MaskExplode     : TMaskExplode;
       { High Level }
        MemAlloc        : TMemAlloc;
        MemRelease      : TMemRelease;
        Prepare         : TUpdatePrepare;
        Update          : TUpdate;
        NewImage        : TNewImage;
        FreeImage       : TFreeImage;
        CloneImage      : TCloneImage;
        NewMask         : TNewMask;
        FreeMask        : TFreeMask;
        CloneMask       : TCloneMask;
        ImageSizeOf     : TImageSizeOf;
        ImageSizeData   : TImageSizeOf;
        MaskSize        : TMaskSize;
        MaskSizeOf      : TMaskSizeOf;
        MaskSizeData    : TMaskSizeOf;
        FadePalettes    : TFadePalettes;
        FadeOut         : TFadeOut;
        FadeIn          : TFadeIn;
        ImageRemap      : TImageRemap;
        NewFont         : TNewFont;
        FreeFont        : TFreeFont;
        GetFont         : TGetFont;
        SetFont         : TSetFont;
        GetMonospace    : TGetMonospace;
        SetMonospace    : TSetMonospace;
        GetFontDirection:TGetFontDirection;
        SetFontDirection:TSetFontDirection;
        PutChar         : TPutChar;
        PutText         : TPutText;
        ImagePutChar    : TImagePutChar;
        ImagePutText    : TImagePutText;
        TextWidth       : TTextWidth;
        TextHeight      : TTextHeight;
        NewSprite       : TNewSprite;
        FreeSprite      : TFreeSprite;
        CloneSprite     : TCloneSprite;
        SpriteSizeOf    : TSpriteSizeOf; { This is the Sprite Only! It does not
                                           include a stored background image.
                                           To include that just add ImageSizeOf(
                                           TheSprite^.Behind)  }
        SpriteSort      : TSpriteSort;
        SpriteRemove    : TSpriteRemove;
        SpriteAdd       : TSpriteAdd;
        SpriteSetVisible: TSpriteSetVisible;
        SpriteUndraw    : TSpriteUndraw;
        SpriteUndrawArea: TSpriteUndrawArea;
        SpriteUndrawAll : TSpriteUndrawAll;
        SpriteShow      : TSpriteShow;
        SpriteHide      : TSpriteHide;
        SpriteChange    : TSpriteChange;        { Change Sprite image }
        SpriteNext      : TSpriteNext;          { Next Sprite Image in Group }
        SpriteNextAll   : TSpriteNextAll;
        SpriteCovers    : TSpriteCovers;
        SpriteMove      : TSpriteMove;          { adjusts for hotspot }
        SpriteWhere     : TSpriteWhere;         { adjusts for hotspot }
        SpriteCollide   : TSpriteCollide;       { adjusts for hotspot }
        SpriteGetSeq    : TSpriteGetSeq;
        SpriteSetSeq    : TSpriteSetSeq;
        UpdateSprites   : TUpdateSprites;       { Redraws any needed sprites }

        { Optional }
        ExtendedData    : TGetExtendedData;     { returns pointer or nil }
        GetViewPort     : TGetViewPort; { not implemented }
        SetViewPort     : TSetViewPort; { not implemented }
        { Really only for BuiltIn Driver Functions }
        EndOfProcs      : DWord;
    end;

    PDriverConfig = ^TDriverConfig;
    TDriverConfig = record
        Data : array[0..127] of byte;
        Procs : array[0..16350] of record
            Offset, Segment : word;
        end
    end;

{ Avoid using these functions! Just register their directory with
  AssetIndexSys and use AssetLoad. It will load the driver and configure it. }
function ConfigureDriver(var Driver : PDriver) : boolean;
function LoadDriver(Filename : String; var Driver : PDriver) : boolean;

{$ENDIF}

{$IFDEF SECTIMP}
var
    BuiltInDrivers : array[0..5] of PDriver;

function ConfigureDriver(var Driver : PDriver) : boolean;
var
    I : word;
    EOP : boolean;
    BID : PDriverConfig;
begin
    ClearError;
    ConfigureDriver := False;
    if Driver^.Platform <> fiInferno then
        SetError(erInvalid_Driver_Error);
    if Pos(',' + Driver^.Class + ',', ',' + dcAllTypes + ',') = 0 then
        SetError(erUnsupported_Driver_Error);
    if Ofs(Driver^) <> 0 then
        SetError(erMaligned_Driver_Error);
    if NoError then begin
        { Should check to make sure we don't exceed size of driver }
        if Driver^.Class = dcVideo then
            BID := PDriverConfig(BuiltInDrivers[1])
        else
            BID := PDriverConfig(BuiltInDrivers[0]); { Null Driver }
        I := 0;
        EOP := false;
        { basically... Adjusts Segment of function calls to point to Segment
         where driver is loaded until all driver functions are adjusted. If the
         function is not assigned (nil offset), then it is pointed to the
         BuiltIn driver function if one is available. A side effect is that
         calling becomes bidirectional.  }
        while PDriverConfig(Driver)^.Procs[I].Segment = 0 do begin
            EOP := EOP or (BID^.Procs[I].Segment = $ffff);
            if PDriverConfig(Driver)^.Procs[I].Offset <> 0 then
                PDriverConfig(Driver)^.Procs[I].Segment := Seg(Driver^)
            else if not EOP then begin
                PDriverConfig(Driver)^.Procs[I].Segment := BID^.Procs[I].Segment;
                PDriverConfig(Driver)^.Procs[I].Offset := BID^.Procs[I].Offset;
            { else
                Generate critical error and terminate if unassigned and called.
                Pascal program automatically die with error 200, division by
                zero.
            }
            end;
            Inc(I);
        end;
        if PDriverConfig(Driver)^.Procs[I].Segment <> $ffff then
            SetError(erDriver_Verification_Error);
    end;
    ConfigureDriver := NoError;
end;

function LoadDriver(Filename : String; var Driver : PDriver) : boolean;
var
    Size : word;
begin
    if FileLoad(FileName, Pointer(Driver), Size) then begin
        if not ConfigureDriver(Driver) then begin
            FreeMem(Driver, Size);
            Driver := nil;
        end;
    end;
    LoadDriver := Assigned(Driver);
end;


{$ENDIF}