; BSD 3-Clause License
; Copyright (c) 2021, Jerome Shidel
; All rights reserved.

; NASM 2.14rc0 for DOS

%define ImageHeadSize 10

struc TImage
    Width           resw 1
    Height          resw 1
    LineWidth       resw 1
    Compression     resb 1
    Reserved        resb 1
    DataSize        resw 1
    Data            resb 0
endstruc

struc THeader ; 128 bytes
    .Platform:      resb 10
    .Class:         resb 10
    .Name:          resb 32
    .Version        resw 1
    .VersionCompat: resw 1
    .CPU:           resw 1
    .Flags:         resw 1      ; supported VMs etc
    .MinimumMemory: resd 1      ; Minimum amount of memory to initialize driver
    ; end 64 byte header
    ; Graphics Driver Specific
    .Width:         resw 1      ; Best Mode Width
    .Height:        resw 1      ; Best Mode Height
    .ColorDepth:    resw 1      ; Best Mode Colors bits, 8 = 256 colors
    .Colors         resw 1      ; if ColorDepth is 16 or less then total colors
    .ColorProfiles  resw 1      ; Number of color palette profiles
    ; active font settings - same structure as TFontTSettings
    .Font           resd 1
    .Monospace      resb 1
    .FontReserved   resb 1
    .Direction      resw 1
    ; misc reserved
    .Reserved:      resw 23
    ; end 64 byte shared data
endstruc

struc TCore ; Absolutely required functions must be present
    ; May be called without driver being initialized and in Graphics Mode
    .GetCopyright   resd 1
    .GetLicense     resd 1
    .GetModes       resd 1
    .OpenVideo      resd 1
    .CloseVideo     resd 1
    .SetSync        resd 1
    .SetBuffered    resd 1
    ; Do not call any of these without being in Graphics Mode
    .UpdateVideo    resd 1
    .UpdateForce    resd 1
    .GetPalettes    resd 1
    .SetPalettes    resd 1
    .GetProfile     resd 1
    .GetPixel       resd 1
    .PutPixel       resd 1
    .ImageSize      resd 1
    .ImageGetPixel  resd 1
    .ImagePutPixel  resd 1
endstruc

struc TPerformance  ; Individually optional, but really should implement to
                    ; improve overall graphics performance. Otherwise, the
                    ; graphics sub-system will provide rudimentary versions
                    ; through extensive use of Get/Put Pixel and ImagePixel.
                    ; Having a major performance impact on games and programs.
    .Fill           resd 1  ; if not provided, will use Region (entire screen)
    .Region         resd 1
    .ImageFill      resd 1  ; if not provided, will use ImageRegion
    .ImageRegion    resd 1
    .GetImage       resd 1
    .PutImage       resd 1
    .PutImageMode   resd 1
    .PutMask        resd 1
    .PutMaskMode    resd 1
    .PutBits        resd 1
    .PutImageBits   resd 1
    .ImageToMask    resd 1
    .MaskToImage    resd 1
    .MaskInvert     resd 1
    .Shift          resd 1  ; if not provided, will use ShiftRegion
    .ShiftRegion    resd 1
    .ShiftImage     resd 1  ; if not provided, will use ShiftImageRegion
    .ShiftImageRegion resd 1
    .ImageFlip      resd 1
    .ImageMirror    resd 1
    .Frame          resd 1
    .FrameRegion    resd 1
    .ImageFrame     resd 1
    .FloodFill      resd 1
    .ImageFloodFill resd 1
    .ImageImplode   resd 1
    .ImageExplode   resd 1
    .MaskImplode    resd 1
    .MaskExplode    resd 1
endstruc

struc THighLevel    ; These are provided by the graphics sub-system and
                    ; probably never need implemented in the driver. However,
                    ; they are used by programs and can be used or even
                    ; possibly be re-implemented or used by the driver
    .MemAlloc           resd 1
    .MemRelease         resd 1
    .Prepare            resd 1
    .Update             resd 1
    .NewImage           resd 1  ; function (Width, Height : word) : PImage;
    .FreeImage          resd 1  ; procedure (var Image : PImage);
    .CloneImage         resd 1
    .NewMask            resd 1  ; function (Width, Height : word) : PMask;
    .FreeMask           resd 1  ; procedure (var Image : PMask);
    .CloneMask          resd 1
    .ImageSizeOf        resd 1  ; function(Image : PImage) : word;
    .ImageSizeData      resd 1  ; function(Image : PImage) : word;
    .MaskSize           resd 1
    .MaskSizeOf         resd 1  ; function(Mask : PMask) : word;
    .MaskSizeData       resd 1  ; function(Mask : PMask) : word;
    .FadePalettes       resd 1
    .FadeOut            resd 1
    .FadeIn             resd 1
    .ImageRemap         resd 1
    .NewFont            resd 1
    .FreeFont           resd 1
    .GetFont            resd 1
    .SetFont            resd 1
    .GetMonospace       resd 1
    .SetMonospace       resd 1
    .GetFontDirection   resd 1
    .SetFontDirection   resd 1
    .PutChar            resd 1
    .PutText            resd 1
    .ImagePutChar       resd 1
    .ImagePutText       resd 1
    .TextWidth          resd 1
    .TextHeight         resd 1
    .NewSprite          resd 1
    .FreeSprite         resd 1
    .CloneSprite        resd 1
    .SpriteSizeOf       resd 1
    .SpriteSort         resd 1
    .SpriteRemove       resd 1
    .SpriteAdd          resd 1
    .SpriteSetVisible   resd 1
    .SpriteUndraw       resd 1
    .SpriteUndrawArea   resd 1
    .SpriteUndrawAll    resd 1
    .SpriteShow         resd 1
    .SpriteHide         resd 1
    .SpriteChange       resd 1
    .SpriteNext         resd 1
    .SpriteNextAll      resd 1
    .SpriteCovers       resd 1
    .SpriteMove         resd 1
    .SpriteWhere        resd 1
    .SpriteCollide      resd 1
    .SpriteGetSeq       resd 1
    .SpriteSetSeq       resd 1
    .SpriteUpdate       resd 1

endstruc

struc TOptional
    .ExtendedData   resd 1      ; Individually optional but can add
                                ; functionality and/or improve performance
    .GetViewPort    resd 1      ; probably not needed for games
    .SetViewPort    resd 1      ; dido

endstruc

; Direction modifiers

