{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

procedure PutEvent(var Event : TEvent);
function  GetEvent(var Event:TEvent) : boolean;
procedure PurgeEvents;

{$ENDIF}

{$IFDEF SECTIMP}
var
    Events : PList;

procedure PutEvent(var Event : TEvent);
var
    P : PEvent;
begin
    asm
        pushf
        cli
    end;
    New(P);
    if Assigned(P) then begin
        P^ := Event;
        AddList(Events, P);
    end;
    asm popf end;
end;

function GetEvent(var Event:TEvent) : boolean;
var
    P : PEvent;
begin
    asm
        pushf
        cli
    end;
    if MoveEvent.Kind <> evNull then begin
        PutEvent(MoveEvent);
        MouseLag := 0;
        MoveEvent.Kind := evNull;
    end;
    P := PullList(Events);
    if Assigned(P) then begin
        Event := P^;
        Dispose(P);
        GetEvent := true;
    end else begin
        Event.Kind := evNull;
        GetEvent := False;
    end;

    asm
        popf
    end;
end;

procedure PurgeEvents;
var
    Event : TEvent;
begin
    While GetEvent(Event) do;
end;

{$ENDIF}