{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
unit FFmtIDK; { File Format Template  }

interface

uses Inferno;

var
    IDK_Handler : PFormatHandler;


implementation

{$I-}
function IDK_Check(FileName : String) : boolean; far;
var
    F : boolean;
begin
    F := False;
    ClearError;
    { Test File }
    IDK_Check := NoError and F;
    ClearError;
end;

function IDK_Process(var P : Pointer; var Size : word) : integer; far;
begin
    ClearError;
    SetError(erOperation_Not_Supported);
    { Perform data conversion, free old pointer memory, return new pointer
      and it's size. Caller will not free old pointer memory for you! }
    if Assigned(P) then begin
        FreeMem(P, Size);
        P := nil;
    end;
    IDK_Process := GetError;
end;

function IDK_Save(FileName : String; P : Pointer; Size : LongInt) : integer; far;
begin
    ClearError;
    SetError(erOperation_Not_Supported);
    IDK_Save := GetError;
end;

function IDK_Load(FileName : String; var P : Pointer; var Size : LongInt) : integer; far;
begin
    ClearError;
    SetError(erOperation_Not_Supported);
    IDK_Load := GetError;
end;

begin
    IDK_Handler := New(PFormatHandler);
    with IDK_Handler^ do begin
        Kind   := ffImage;
        UID    := 'BINIDK'; { unique ID }
        Compat := 0;
        Exts   := 'IDK;'; { file extensions }
        Check  := IDK_Check;
        Process:= nil;
        Save   := nil; { IDK_Save; }
        Load   := nil; { IDK_Load; }
    end;
    RegisterFileFormat(IDK_Handler);
end.