{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
unit FFmtPAS; { Graphic Image Assembly Include File Format  }

interface

uses Inferno;

var
    PAS_Handler : PFormatHandler;

implementation

{$I-}
function PAS_Check(FileName : String) : boolean; far;
var
    F : boolean;
begin
    ClearError;
    F := False;
    PAS_Check := NoError and F;
end;

function PAS_Save(FileName : String; P : Pointer; Size : LongInt) : integer; far;
var
    T : Text;
    Base : String;
    S : String;
    X, Y : integer;
    Pal : TRGBPalettes;
    Image : PImage;
begin
    Image := P;
    Base := UCase(FileBase(FileName));
    if UCase(FileExt(FileName)) <> 'PAS' then
        FileName := Base + 'PAS';
    While Pos(PathDelim, Base) > 0 do Delete(Base, 1,  Pos(PathDelim, Base));
    Base := Copy(Base, 1, Pos('.', Base) -1);
    Video^.GetPalettes(Pal);
    ClearError;
    Assign(T, FileName);
    Rewrite(T);
    if NoError then begin
        WriteLn(T, '{ Pascal Source Unit Graphics Image }');
        WriteLn(T, '{ auto-created by Inferno Game Engine }');
        WriteLn(T, '');
        WriteLn(T, 'unit ' + Base + ';');
        WriteLn(T, '');
        WriteLn(T, 'interface');
        WriteLn(T, '');
        WriteLn(T, 'const');
        WriteLn(T, #9,'IMAGE_', Base, '_PIXELS = $',
            WordHex(Video^.ImageSize(Image^.Width, Image^.Height) - 4), ';',
             #9#9,
            '{ ', Video^.ImageSize(Image^.Width, Image^.Height) - 4,
            ' bytes }');
        WriteLn(T, #9,'IMAGE_', Base, ' : record');
        WriteLn(T, #9#9,'Width  : word;');
        WriteLn(T, #9#9,'Height : word;');
        WriteLn(T, #9#9,'Bitmap : array[0..IMAGE_', Base, '_PIXELS-1] of byte;');
        WriteLn(T, #9,'end = (');
        WriteLn(T, #9#9,'Width  :$',
            WordHex(Image^.Width), ';', #9#9, '{ ',
            Image^.Width, ' pixels }');
        WriteLn(T, #9#9,'Height :$',
            WordHex(Image^.Height), ';', #9#9,'{ ',
            Image^.Height, ' pixels }');
        WriteLn(T, #9#9,'Bitmap  : (');
        WriteLn(T);
        for Y := 0 to Image^.Height - 1 do begin
            S := '';
            for X := 0 to Image^.Width - 1 do begin
                S := S + '$' + ByteHex(Video^.ImageGetPixel(Image, X, Y));
                if (Y <> Image^.Height - 1) or (X <> Image^.Width - 1) then
                    S := S + ',';
                if (Length(S) > 60) and (X <> Image^.Width - 1) then begin
                    WriteLn(T, #9#9, S);
                    S := '';
                end;
            end;
            if S <> '' then begin
                While Length(S) < 65 do S := S + ' ';
                WriteLn(T, #9#9, '', S, ' {', Y, '}');
            end;
        end;
        WriteLn(T);
        WriteLn(T, #9#9,')');
        WriteLn(T, #9,'); { IMAGE_' + Base + '_DATA }');
        WriteLn(T, '');
        WriteLn(T, #9,'IMAGE_' + Base + '_RGB : array [0..255] of record ');
        WriteLn(T, #9#9,'Red   : byte;');
        WriteLn(T, #9#9,'Green : byte;');
        WriteLn(T, #9#9,'Blue  : byte;');
        WriteLn(T, #9,'end = (');
        WriteLn(T, #9,'{ RGB Palette Values 0-255. Most VGA takes 0-63. So, divide them by 4. Or,');
        WriteLn(T, #9,'  simply shift them right by 2. }');
        for Y := 0 to 127 do begin
            S := '';
            for X := 0 to 1 do begin
                S := S + '{' + LPad(IntStr(Y * 2 + X), 3) + '} ';
                S := S + '(Red:$' + ByteHex(Pal[Y * 2 + X].Red);
                S := S + '; Green:$' + ByteHex(Pal[Y * 2 + X].Green);
                S := S + '; Blue:$' + ByteHex(Pal[Y * 2 + X].Blue);
                S := S + ')';
                if (X <> 1) or (Y <> 127) then
                    S := S + ',';
                if X <> 1 then
                    S := S + ' ';
            end;
            WriteLn(T, #9, S);
        end;
        WriteLn(T, #9,'); { IMAGE_' + Base + '_RGB }');
        WriteLn(T, '');
        WriteLn(T, 'implementation');
        WriteLn(T, '');
        WriteLn(T, 'end.');
    end;
    Close(T);
    PAS_Save := GetError;
end;

begin
    PAS_Handler := New(PFormatHandler);
    with PAS_Handler^ do begin
        Kind   := ffImage;
        UID    := 'IMGPAS';
        Compat := 0;
        Exts   := 'PAS';
        Check  := PAS_Check;
        Save   := PAS_Save;
        Process:= nil;
        Load   := nil;
    end;
    RegisterFileFormat(PAS_Handler);
end.