; BSD 3-Clause License
; Copyright (c) 2021, Jerome Shidel
; All rights reserved.

; NASM 2.14rc0 for DOS
; BSD 3-Clause License
; Copyright (c) 2021, Jerome Shidel
; All rights reserved.

; NASM 2.14rc0 for DOS

use16

cpu 386

%include "TPASCAL.INC"

section PASCAL_DATA

ErrorCode:
    dw      0

DefaultLanguage:
    dw      0,0
UserLanguage:
    dw      0,0
TextMode:
    dw      0

TestValue:
    dw      0xfdfd

section PASCAL_SHARED

    extern IsDOSBox         ; boolean
    extern IsVirtual        ; boolean;
    extern MachineType      ; byte
    extern NLSResult        ; byte

section PASCAL_CODE

VRTInterval:
    dw      0
VRTSlowCount:
    dw      0
VRTElapsed:
    dw      0
VRTInterrupt:
    dw      0, 0

VRTHandler:
    pushf
    push    ax
    inc     word [cs:VRTElapsed]
    mov     ax, [cs:VRTSlowCount]
    test    ax, ax
    jz     .OldHandler
    dec     ax
    mov     [cs:VRTSlowCount], ax
    mov     al, 0x20
    out     0x20, al
    pop     ax
    popf
    iret
.OldHandler:
    mov     ax, [cs:VRTInterval]
    mov     [cs:VRTSlowCount], ax
    pop     ax
    popf
    jmp     far [cs:VRTInterrupt]

%idefine TimerINT 8

%imacro ReleaseInterrupts 0
    cli
    xor     ax, ax
    cmp     [cs:VRTInterval], ax
    je      .DontNeedReset
    ; reset to standard timer int 8 interval
    mov     al, 0x36
    out     0x43, al
    xor     al, al
    out     0x40, al
    out     0x40, al
.DontNeedReset:
    cmp     [cs:VRTInterrupt], ax
    jne     %%RestoreVRT
    cmp     [cs:VRTInterrupt+2], ax
    jne     %%RestoreVRT
    jmp     %%Done
    ;set new int 70
%%RestoreVRT:
    push    ds
    lds     dx, [cs:VRTInterrupt]
    mov     ax, 0x2500 + TimerINT
    int     0x21
    pop     ds
%%Done:
    sti
%endmacro

%imacro TrapInterrupts 0
    ; save old int 70
    cli
    mov     ax, 0x3500 + TimerINT
    int     0x21
    mov     dx, es
    mov     [cs:VRTInterrupt], bx
    mov     [cs:VRTInterrupt + 2], dx
    ; save old int 70
    push    ds
    push    cs
    pop     ds
    mov     dx, VRTHandler
    mov     ax, 0x2500 + TimerINT
    int     0x21
    pop     ds
    sti
%endmacro

; Internal functions and macros
InternalDataReset:
    xor     eax, eax
    mov     [DefaultLanguage], eax
    mov     [UserLanguage], eax
    mov     [ErrorCode], ax
    ret

SearchRAMFunc: ; ES:SI = Pascal String, AX = Segment, CX = Count, returns AL =T/F
    push    ds
    push    ax
    pop     ds
    xor     di, di
.CheckNext:
    cmp     cx, 0
    je      .NotFound
    xor     bx, bx
.CheckScan:
    mov     al, [es:si+bx]
    cmp     al, 0
    je      .Matched
    mov     ah, [di+bx]
    cmp     ah, $61
    jb      .NotLower
    cmp     ah, $7a
    ja      .NotLower
    sub     ah, $20
.NotLower:
    cmp     ah, al
    jne     .MissMatch
    inc     bx
    jmp     .CheckScan
.MissMatch:
    dec     cx
    inc     di
    jmp     .CheckNext
.Matched:
    mov     al, True
    jmp     .Done
.NotFound:
    mov     al, FALSE
.Done:
    pop     ds
ret

%imacro SearchRAM 3
    jmp     %%SkipOver
%%Data:
    db %3,0
%%SkipOver:
    mov     ax, %1
    mov     cx, %2
    mov     si, %%Data
    push    cs
    pop     es
    call    SearchRAMFunc
%endmacro

%imacro TestVirtualMachines 0
    SearchRAM   0xfe00, 0x0100, 'THE DOSBOX TEAM'
    mov         [IsDOSBox], al
    mov         [IsVirtual], al
    mov         ah, 101
    cmp         al, True
    je          %%DoneVMTesting
    SearchRAM   0xf000, 0xf000, 'QEMU'
    mov         ah, 102
    mov         [IsVirtual], al
    cmp         al, True
    je          %%DoneVMTesting
    SearchRAM   0xffe0, 0x2000, 'ORACLE VM VIRTUALBOX'
    mov         ah, 103
    mov         [IsVirtual], al
    cmp         al, True
    je          %%DoneVMTesting
    SearchRAM   0xf000, 0x2000, 'VMWARE VIRTUAL PLATFORM'
    mov         ah, 104
    mov         [IsVirtual], al
    cmp         al, True
    je          %%DoneVMTesting
    mov         ah, 0
%%DoneVMTesting:
    mov         [MachineType], ah
%endmacro

; Shared functions and procedures
ppascal DoneInferno
    ReleaseInterrupts
    ; Check Video Mode
    mov     ah, 0x0f
    int     0x10
    xor     ah, ah
    mov     bx, [TextMode]
    cmp     ax, bx
    je      .OkVideoMode
    ; Reset To Text Mode
    mov     ax, [TextMode]
    xor     ah, ah
    int     0x10
.OkVideoMode:
    call    InternalDataReset
endpascal

fpascal InitInferno, boolean
    mov     ax, [TestValue]
    cmp     ax, 0xfdfd
    jne     .Failed
    call    InternalDataReset

    ; Save Inintial Video Mode
    mov     ah, 0x0f
    int     0x10
    xor     ah, ah
    mov     [TextMode], ax

    TestVirtualMachines

    TrapInterrupts

    mov     RESULT, True
    jmp     .Done
.Failed:
    mov     RESULT, False
.Done:
endpascal

fpascal Ext_GetError, word
    mov    RESULT, [ErrorCode]
endpascal

ppascal Ext_SetError, word
    mov     ax, PARAM_1
    mov     [ErrorCode], ax
endpascal

ppascal SetDefaultLanguage, pointer
; procedure (P : Pointer);
    les     di, PARAM_1
    mov     [DefaultLanguage], di
    mov     [DefaultLanguage + 2], es
endpascal

ppascal SetUserLanguage, pointer
; procedure (P : Pointer);
    les     di, PARAM_1
    mov     [UserLanguage], di
    mov     [UserLanguage + 2], es
endpascal

fpascal GetDefaultLanguage, pointer
; function : Pointer;
    les     ax, [DefaultLanguage]
    push    es
    pop     dx
endpascal

fpascal GetUserLanguage, pointer
; function : Pointer;
    les     ax, [UserLanguage]
    push    es
    pop     dx
endpascal

fpascal RawNLS, string, string
; function (const ID : String) : string; { always sets error code }
    push    ds
    push    ds
    pop     dx
    xor     bx, bx

    les     di, PARAM_1
    xor     ch, ch
    mov     cl, [es:di]
    inc     di
    cmp     cl, bl
    je      .NotFound
    cld

.TestUser:
    mov     [NLSResult], byte 1
    lds     si, [UserLanguage]
    push    ds
    pop     ax
    cmp     ax, bx
    jne     .SearchUser
    cmp     si, bx
    jne     .SearchUser
    jmp     .TestBuiltIn

.SearchUser:
    call    .Search
    jnc     .Found

.TestBuiltIn:
    push    dx
    pop     ds
    mov     [NLSResult], byte 2
    lds     si, [DefaultLanguage]
    push    ds
    pop     ax
    cmp     ax, bx
    jne     .SearchBuiltIn
    cmp     si, bx
    jne     .SearchBuiltIn

.SearchBuiltIn:
    call    .Search
    jnc     .Found
    push    dx
    pop     ds
    mov     [NLSResult], byte 0
    jmp     .NotFound

.Search:
    push    di
    push    cx

.Compare:
    lodsb
    cmp     al, bl
    je      .SearchNotFound
    cmp     al, 0x0a
    je      .NotMatch
    cmp     al, 0x0d
    je      .NotMatch
    cmp     al, '='
    je      .NotMatch
    mov     ah, [es:di]
    inc     di
    cmp     al, ah
    jne     .NotMatch
    loop    .Compare
    lodsb
    cmp     al, '='
    jne     .NotMatch
    clc
    jmp     .Matched

.NotMatch:
    pop     cx
    pop     di
.SearchEOL:
    lodsb
    cmp     al, bl
    je      .Search
    cmp     al, 0x0a
    je      .SearchEOL
    cmp     al, 0x0d
    je      .SearchEOL
    dec     si
    jmp     .Search

.SearchNotFound:
    stc
.Matched:
    pop     cx
    pop     di
    ret

.Found:
    les     di, RESULT
    xor     cx, cx
    push    di
    inc     di
.CopyLoop:
    cmp     cx, 255
    je      .Copied
    lodsb
    cmp     al, bl
    je      .Copied
    cmp     al, 0x0a
    je      .Copied
    cmp     al, 0x0d
    je      .Copied
    inc     cx
    stosb
    jmp     .CopyLoop

.Copied:
    xor     ch, ch
    jmp     .CopyDone

.NotFound:
    mov     ch, 1
    les     di, RESULT
    xor     cl, cl
    push    di
.CopyDone:
    pop     di
    mov     al, cl
    stosb
    pop     ds
endpascal

fpascal ByteHEX, byte, string
; function ( B : byte ) : String;
    les   di, RESULT
    mov   al, $02
    mov   [es:di], al
    mov   al, PARAM_1
    mov   bx, 0x3007
    mov   ah, al
    and   ah, 0x0f
    and   al, 0xf0
    mov   cl, 0x04
    shr   al, cl
    cmp   al, 0x09
    jna   .SetLower
    add   al, bl
.SetLower:
    add   al, bh
    cmp   ah, 0x09
    jna   .SetUpper
    add   ah, bl
.SetUpper:
    add   ah, bh
    mov   [es:di + 1], ax
endpascal

ppascal Delay, LongInt
    pushf
    sti
    les     di, PARAM_1
    mov     dx, es
    mov     ax, di
    mov     cx, 55
    div     cx
    mov     cx, ax
    cmp     cx, 0
    je      .Done
    mov     di, 0x0040
    push    di
    pop     es
    mov     di, 0x006c
    mov     dx, [es:di]
.Waiting:
    hlt
    mov     ax, [es:di]
    cmp     ax, dx
    je      .Waiting
    mov     dx, ax
    loop    .Waiting
.Done:
    popf
endpascal

fpascal SetVRTInterval, word, word
; function SetVRTInterval(Interval : word) : word;
    mov     ax, [cs:VRTInterval]
    push    ax
    mov     cx, PARAM_1
    dec     cx
    xor     bx, bx
    test    cx, cx
    jz      .RangeOK
    mov     bx, 0x8000
    dec     cx
    jz      .RangeOK
    mov     bx, 0x5555
    dec     cx
    jz      .RangeOK
    mov     bx, 0x4000
    dec     cx
    jz      .RangeOK
    jmp     .RangeBad
.RangeOK:
    mov     cx, PARAM_1
    dec     cx
    mov     [cs:VRTInterval], cx
    mov     al, 0x36
    out     0x43, al
    mov     ax, bx
    out     0x40, al
    xchg    al, ah
    out     0x40, al
.RangeBad:
    pop     ax
endpascal

fpascal GetVRTInterval, pointer
; function TestVRTimer : pointer;
    mov     ax, [cs:VRTInterval]
    inc     ax
endpascal

fpascal GetVRTimer, pointer
; function TestVRTimer : pointer;
    mov     ax, VRTElapsed
    push    cs
    pop     dx
endpascal
