{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}


{$ENDIF}

{$IFDEF SECTIMP}
var
    SpriteFlag : boolean;
    SpriteFirst,
    SpriteLast : PSprite;

procedure DisposeSprite(var Sprite : PSprite);
var
    I : word;
begin
    if Assigned(Sprite^.Sprites) then begin
        for I := 0 to Sprite^.Count - 1 do begin
            Video^.FreeImage(Sprite^.Sprites^[I].Image);
            Video^.FreeImage(Sprite^.Sprites^[I].IMask);
            Video^.FreeMask(Sprite^.Sprites^[I].BMask);
        end;
        FreeMem(Sprite^.Sprites, Sprite^.Count * Sizeof(TMaskedImage));
    end;
    Video^.FreeImage(Sprite^.Behind);
    Dispose(Sprite);
    {$IFDEF LOGS} Log('Sprite Disposed'); {$ENDIF}
    Sprite := nil;
end;

function BuiltIn_NewSprite (Width, Height, Count : word; Populate : boolean) : PSprite; far;
var
    Sprite : PSprite;
    I  : word;
begin
    if Count = 0 then
        Sprite := nil
    else
        Sprite := New(PSprite);
    {$IFDEF LOGS} Log('New Sprite: ' + IntStr(Width) + 'x' + IntStr(Height) + 'x' +
        IntStr(Count) ); {$ENDIF}
    if Assigned(Sprite) then begin
        FillChar(Sprite^, Sizeof(TSprite), 0);
        Sprite^.Behind := Video^.NewImage(Width, Height);
        if Assigned(Sprite^.Behind) then
            GetMem(Sprite^.Sprites, Count * Sizeof(TMaskedImage));
        if Assigned(Sprite^.Sprites) then begin
            FillChar(Sprite^.Sprites^, Count * Sizeof(TMaskedImage), 0);
            Sprite^.Count := Count;
            if Populate then begin
                for I := 0 to Count - 1 do begin
                    Sprite^.Sprites^[I].Image := Video^.NewImage(Width, Height);
                    Sprite^.Sprites^[I].IMask := nil;
                    Sprite^.Sprites^[I].BMask := nil;
                    Sprite^.Sprites^[I].Sequence := 0;
                    if not Assigned(Sprite^.Sprites^[I].Image) then Break;
                    Sprite^.Sprites^[I].BMask := Video^.NewMask(Width, Height);
                    if not Assigned(Sprite^.Sprites^[I].BMask) then Break;
                    { if ImageCompress then begin
                        Video^.ImageImplode(Sprite^.Sprites^[I].Image);
                        Video^.ImageImplode(Sprite^.Sprites^[I].IMask);
                    end; }
                end;
            end;
        end;
    end;
    if NoError and Assigned(Sprite) then begin
        Sprite^.Kind := skDefault;
        Sprite^.Level := slDefault;
        SetArea(0,0, Width - 1, Height - 1, Sprite^.Area);
        Video^.SpriteAdd(Sprite);
    end else
        DisposeSprite(Sprite);
    BuiltIn_NewSprite := Sprite;
end;

procedure BuiltIn_FreeSprite(var Sprite : PSprite); far;
begin
    if not assigned(Sprite) then exit;
    Video^.SpriteRemove(Sprite);
    {$IFDEF LOGS} Log('Free Sprite '); {$ENDIF}
    DisposeSprite(Sprite);
    Sprite := nil;
end;

function BuiltIn_CloneSprite(Sprite : PSprite) : PSprite; far;
begin
end;

function BuiltIn_SpriteSizeOf(Sprite : PSprite) : LongInt; far;
var
    Size : LongInt;
    I : Word;
begin
    Size := 0;
    if Assigned(Sprite) then begin
        Size := Sizeof(TSprite) + Sprite^.Count * Sizeof(TMaskedImage);
        for I := 0 to Sprite^.Count - 1 do begin
            Inc(Size, Video^.ImageSizeOf(Sprite^.Sprites^[I].Image));
            Inc(Size, Video^.MaskSizeOf(Sprite^.Sprites^[I].BMask));
            Inc(Size, Video^.ImageSizeOf(Sprite^.Sprites^[I].IMask));
        end;
    end;
    BuiltIn_SpriteSizeOf := Size;
end;

procedure BuiltIn_SpriteRemove(var Sprite : PSprite); far;
begin
    if not (Assigned(Sprite^.Prev) or Assigned(Sprite^.Next) or (Sprite = SpriteFirst)) then exit;
    Video^.SpriteUndraw(Sprite);
    if Assigned(Sprite^.Prev) then
        Sprite^.Prev^.Next := Sprite^.Next
    else
        SpriteFirst := Sprite^.Next;
    if Assigned(Sprite^.Next) then
        Sprite^.Next^.Prev := Sprite^.Prev
    else
        SpriteLast := Sprite^.Prev;
    Sprite^.Prev := nil;
    Sprite^.Next := nil;
end;

procedure SpriteTopMost(var Sprite : PSprite); far;
begin
    Video^.SpriteRemove(Sprite);
    if Assigned(SpriteFirst) then begin
        Sprite^.Next := SpriteFirst;
        SpriteFirst^.Prev := Sprite;
    end else begin
        SpriteLast := Sprite;
    end;
    SpriteFirst := Sprite;
end;

procedure SpriteBottomMost(var Sprite : PSprite); far;
begin
    Video^.SpriteRemove(Sprite);
    if Assigned(SpriteLast) then begin
        Sprite^.Prev := SpriteLast;
        SpriteLast^.Next := Sprite;
    end else begin
        SpriteFirst := Sprite;
    end;
    SpriteLast := Sprite;
end;

procedure BuiltIn_SpriteSort; far;
var
    L, P : PSprite;
begin
    P := SpriteLast;
    if not Assigned(P) then exit;
    repeat
        L := P^.Prev;
        if Not Assigned(L) then break;
        if L^.Level < P^.Level then
            SpriteTopMost(P);
        P := L;
    until false
end;

procedure BuiltIn_SpriteAdd(var Sprite : PSprite); far;
begin
    SpriteTopMost(Sprite);
end;

procedure BuiltIn_SpriteSetVisible(var Sprite : PSprite; Visible : boolean); far;
begin
    if Visible then
        Video^.SpriteShow(Sprite)
    else
        Video^.SpriteHide(Sprite);
end;

procedure BuiltIn_SpriteUndraw (var Sprite : PSprite); far;
var
    UA : TArea;
    P : PSprite;
begin
    P := Sprite;
    if P^.Visible and (not P^.NeedsDrawn) then P^.NeedsUndrawn := True;
    UA := P^.Area;
    P := P^.Prev;
    while Assigned(P) do begin
        if (P^.Visible) and (not P^.NeedsDrawn) then begin
            if AreaOverLap(UA, P^.Area) then begin
                P^.NeedsUndrawn := True;
                if P^.Area.Left < UA.Left then UA.Left := P^.Area.Left;
                if P^.Area.Top < UA.Top then UA.Top := P^.Area.Top;
                if P^.Area.Right > UA.Right then UA.Right := P^.Area.Right;
                if P^.Area.Bottom > UA.Bottom then UA.Bottom := P^.Area.Bottom;
            end;
        end;
        P := P^.Prev;
    end;
    P := SpriteFirst;
    while Assigned(P) do begin
        if P^.NeedsUndrawn then begin
            P^.NeedsDrawn := True;
            P^.NeedsUndrawn := False;
            Video^.PutImage(P^.Behind, P^.Area.Left, P^.Area.Top);
            SpriteFlag := True;
        end;
        if P = Sprite then Break;
        P := P^.Next;
    end;
end;

procedure BuiltIn_SpriteUndrawArea (Area : TArea); far;
var
    P : PSprite;
begin
    P := SpriteLast;
    while Assigned(P) do begin
        if (P^.Visible) and (not P^.NeedsDrawn) then begin
            if AreaOverLap(Area, P^.Area) then begin
                P^.NeedsUndrawn := True;
                if P^.Area.Left < Area.Left then Area.Left := P^.Area.Left;
                if P^.Area.Top < Area.Top then Area.Top := P^.Area.Top;
                if P^.Area.Right > Area.Right then Area.Right := P^.Area.Right;
                if P^.Area.Bottom > Area.Bottom then Area.Bottom := P^.Area.Bottom;
            end;
        end;
        P := P^.Prev;
    end;
    P := SpriteFirst;
    while Assigned(P) do begin
        if P^.NeedsUndrawn then begin
            P^.NeedsDrawn := True;
            P^.NeedsUndrawn := False;
            Video^.PutImage(P^.Behind, P^.Area.Left, P^.Area.Top);
            SpriteFlag := True;
        end;
        P := P^.Next;
    end;
end;

procedure BuiltIn_SpriteUndrawAll; far;
var
    P : PSprite;
begin
    P := SpriteFirst;
    while Assigned(P) do begin
        if (P^.Visible) and (not P^.NeedsDrawn) then begin
            P^.NeedsDrawn := True;
            P^.NeedsUndrawn := False;
            Video^.PutImage(P^.Behind, P^.Area.Left, P^.Area.Top);
            SpriteFlag := True;
        end;
        P := P^.Next;
    end;
end;

procedure BuiltIn_SpriteShow (var Sprite : PSprite); far;
begin
    if Sprite^.Visible then exit;
    if not Assigned(Sprite^.Sprites^[Sprite^.Index].Image) then exit;
    Video^.SpriteUndraw(Sprite);
    Sprite^.Visible := True;
    Sprite^.NeedsDrawn := True;
    SpriteFlag := True;
end;

procedure BuiltIn_SpriteHide (var Sprite : PSprite); far;
begin
    if Not Sprite^.Visible then exit;
    Video^.SpriteUndraw(Sprite);
    Sprite^.Visible := False;
    Sprite^.NeedsDrawn := False;
    SpriteFlag := True;
end;

procedure BuiltIn_SpriteChange (var Sprite : PSprite; Index : word); far;
begin
    if Index > Sprite^.Count - 1 then Index := 0;
    if Sprite^.Index = Index then exit;
    if Sprite^.Visible then
        Video^.SpriteUndraw(Sprite);
    Sprite^.Index := Index;
end;

procedure BuiltIn_SpriteNext (var Sprite : PSprite); far;
var
   TI, I, Seq : word;
begin
    if (Sprite^.Count < 2) or (Sprite^.Animate = 0) then exit;
    if not Assigned(Sprite^.Sprites^[Sprite^.Index].Image) then exit;
    Seq := Sprite^.Sprites^[Sprite^.Index].Sequence;
    I := Sprite^.Index;
    TI := I;
    repeat
        Inc(I);
        if I > Sprite^.Count - 1 then
            begin
                I := 0;
                if (Sprite^.Animate > 0) then begin
                    Dec(Sprite^.Animate);
                    if (Sprite^.Animate = 0) then begin
                        I := TI;
                        Break;
                    end;
                end;
            end;
        if Assigned(Sprite^.Sprites^[I].Image) and (Seq = Sprite^.Sprites^[I].Sequence) then Break;
    until I = Sprite^.Index;
    Video^.SpriteChange(Sprite, I);
end;

procedure BuiltIn_SpriteNextAll(Hidden : boolean); far;
var
    X : PSprite;
begin
    X := SpriteLast;
    while Assigned(X) do begin
        if X^.Visible or Hidden then
            Video^.SpriteNext(X);
        X := X^.Prev;
    end;
end;

function BuiltIn_SpriteCovers (var Sprite : PSprite; x, y : integer) : boolean; far;
begin
    BuiltIn_SpriteCovers := Assigned(Sprite^.Sprites^[Sprite^.Index].Image) and
        (Sprite^.Area.Left <= X) and (Sprite^.Area.Right >= X) and
        (Sprite^.Area.Top <= Y) and (Sprite^.Area.Bottom >= Y);
end;

procedure BuiltIn_SpriteMove (var Sprite : PSprite; x, y : integer); far;
var
    CX, CY : integer;
begin
    X := X - Sprite^.HotSpot.X;
    Y := Y - Sprite^.HotSpot.Y;
    if (X = Sprite^.Area.Left) and (Y = Sprite^.Area.Top) then exit;
    if Sprite^.Visible then
        Video^.SpriteUndraw(Sprite);
    CX := X - Sprite^.Area.Left;
    CY := Y - Sprite^.Area.Top;
    Inc(Sprite^.Area.Left, CX);
    Inc(Sprite^.Area.Right, CX);
    Inc(Sprite^.Area.Top, CY);
    Inc(Sprite^.Area.Bottom, CY);
    if Sprite^.Visible then
        Video^.SpriteUndraw(Sprite);
end;

procedure BuiltIn_SpriteWhere (var Sprite : PSprite; var Where : TPoint); far;
begin
    Where.X := Sprite^.Area.Left + Sprite^.HotSpot.X;
    Where.Y := Sprite^.Area.Top + Sprite^.HotSpot.Y;
end;

function BuiltIn_SpriteCollide (var Sprite : PSprite; x, y : integer) : PSprite; far;
begin
    BuiltIn_SpriteCollide := nil;
end;

function BuiltIn_SpriteGetSeq(var Sprite : PSprite) : word; far;
begin
    if Assigned(Sprite) and Assigned(Sprite^.Sprites) then
        BuiltIn_SpriteGetSeq := Sprite^.Sprites^[Sprite^.Index].Sequence
    else
        BuiltIn_SpriteGetSeq := 0;
end;

function BuiltIn_SpriteSetSeq(var Sprite : PSprite; Seq : word) : word; far;
var
    I, Prev : word;
begin
    if Assigned(Sprite) and Assigned(Sprite^.Sprites) then begin
        if  Sprite^.Sprites^[Sprite^.Index].Sequence <> Seq then begin
            for I := 0 to Sprite^.Count - 1 do
                if Sprite^.Sprites^[I].Sequence = Seq then begin
                    Video^.SpriteCHange(Sprite, I);
                    Break;
                end;
        end;
        BuiltIn_SpriteSetSeq := Sprite^.Sprites^[Sprite^.Index].Sequence
    end else
        BuiltIn_SpriteSetSeq := 0;
end;

procedure BuiltIn_UpdateSprites; far;
var
    P : PSprite;
begin
    if not SpriteFlag then Exit;
    SpriteFlag := False;
    P := SpriteLast;
    while Assigned(P) do begin
        if (P^.Visible) and P^.NeedsDrawn then begin
            P^.NeedsDrawn := False;
            With P^ do begin
                Video^.GetImage(Behind, Area.Left, Area.Top);
                if Assigned(Sprites^[Index].BMask) then begin
                    Video^.PutMaskMode(Sprites^[Index].BMask,
                        Area.Left, Area.Top, imAND);
                    Video^.PutImageMode(Sprites^[Index].Image,
                        Area.Left, Area.Top, imXOR);
                end else
                if Assigned(Sprites^[Index].iMask) then begin
                    Video^.PutImageMode(Sprites^[Index].IMask,
                        Area.Left, Area.Top, imAND);
                    Video^.PutImageMode(Sprites^[Index].Image,
                        Area.Left, Area.Top, imXOR);
                end else
                    Video^.PutImage(Sprites^[Index].Image,
                        Area.Left, Area.Top);
            end;
        end;
        P := P^.Prev;
    end;
end;

{$ENDIF}