{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
program Inferno_Test_Application;

uses Inferno;

procedure Initialize;
begin
    { If assets are attached to the executable, or compiled with D+, or
      drivers and fonts are (by default) available in the EXE's directory,
      then there is no need to add these system paths to the Asset Index }
    AssetIndexSys('DRIVERS\', '');
    AssetIndexSys('FONTS\', '');
end;

procedure Prepare;
begin
end;

procedure Run;
const
    TBW = 2;
var
   E : TEvent;
   FT, LT : LongInt;
   TC, VC : integer;
   H, M, S, HS, LS, CS, NS : Word;
   TT : String;
begin
    LT := TimerTick;
    FT := VRTimer^;
    CS := GetVRTInterval;
    VC := 0;
    TC := 0;
    LS := $ff;
    TT := ' ';
    { Video^.SetSync(true); }
    { Video^.SetBuffered(false); }
    repeat
        Idle;
        GetEvent(E);
        if (E.Kind = evKeyPress) and (E.KeyCode = kbSpace) then begin
            Inc(CS);
            SetVRTInterval(CS);
            NS := GetVRTInterval;
            if NS <> CS then begin
                CS := 1;
                SetVRTInterval(CS);
            end;
        end;
        if LT <> TimerTick then begin
            Video^.Region(TC,0,TC + TBW,9,0);
            Inc(TC);
            if TC + 10 >= GetMaxX then TC := 0;
            Video^.Region(TC,0,TC + TBW,9,2);
            LT := TimerTick;
        end;
        if FT <> VRTimer^ then begin
            Video^.Region(VC,10,VC + TBW,19,0);
            Inc(VC);
            if VC + 10 >= GetMaxX then VC := 0;
            Video^.Region(VC,10,VC + TBW,19,4);
            FT := VRTimer^;
        end;
        SysGetTime(H, M, S, HS);
        if LS <> S then begin
            Video^.Region(0, 20, Video^.TextWidth(TT) + 1, Video^.TextHeight('') + 20, 0);
            TT := ZPad(H, 2) + ':' + ZPad(M, 2) + ':' + ZPad(S, 2) + ' - VRT ' + IntStr(CS) + ':1';
            Video^.PutText(0, 20, TT, 7);
            LS := S;
        end;
        Video^.Update;
    until (E.Kind = evKeypress) and (E.KeyCode = kbEscape);
end;

begin
    Initialize; { settings/changes needed before Inferno Game Engine is started }
    Ignite;     { start game engine }
    Prepare;    { Prepare for app/game run }
    Run;        { run game/program }
    Extinguish; { normal shutdown of Inferno }
end.