{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}
type
    Str6        = String[6];
    Str8        = String[8];
    Str12       = String[12];
    Str20       = String[20];

    DWord = record
        L, H : Word;
    end;
    QWord = record
        L, H : DWord;
    end;
    OWord = record
        L, H : QWord;
    end;
    DQWord = OWord;

    PByte       = ^Byte;
    PWord       = ^Word;
    PLongInt    = ^LongInt;
    PDWord      = ^DWord;
    PQWord      = ^QWord;
    POWord      = ^OWord;
	PString     = ^String;

    Chars = array[0..65534] of char;
    Bytes = array[0..65534] of byte;
    Words = array[0..32766] of word;
    Pointers = array[0..16382] of Pointer;

    PChars = ^Chars;
    PBytes = ^Bytes;
    PWords = ^Words;

	PAsciiZ = PChars;

    PSysFindRec = ^TSysFindRec;
    TSysFindRec = record
        Reserved : array[0..20] of byte;
        Attr : byte;
        Time : LongInt;
        Size : LongInt;
        Name : Str12;
    end;

    TAssetState = (rsNone, rsLoaded, rsNeeded);

    PColor = ^TColor;
    TColor = word;

    PColors = ^TColors;
    TColors = record
        Foreground, Background : TColor;
    end;

    TFillColor = longint; { Basically, TColor... but -1 means do not fill }

    PRGBPalette = ^TRGBPalette;
    TRGBPalette = record
        Red, Green, Blue : byte;
    end;
    PRGBPalettes = ^TRGBPalettes;
    TRGBPalettes = array[0..255] of TRGBPalette;

    TDirection = word;

    PPoint = ^TPoint;
    TPoint = record
        x, y : integer;
    end;

    PArea = ^TArea;
    TArea = record
        Left, Top, Right, Bottom : integer;
    end;

    PListItem = ^TListItem;
    TListItem = record
        Next, Prev  : PListItem;
        Data        : Pointer;
    end;

    PList = ^TList;
    TList = record
        First, Last : PListItem;
        Count       : LongInt;
    end;

    PAssetFile = ^TAssetFile;
    TAssetFile = record
        Name    : PString;
        Open    : boolean;
        F       : File;
    end;
    PAsset = ^TAsset;
    TAsset = record
        Resource   : PAssetFile;
        StandAlone : boolean;
        Kind       : word;
        State      : TAssetState;
        Name       : PString;
        Location   : LongInt;
        DiskSize   : word;
        MemSize    : word;
        Data       : Pointer;
    end;

    PFontOffsets = ^TFontOffsets;
    TFontOffsets = array [0..255] of record
        Offset, Maximum : byte;
    end;

    PFont = ^TFont;
    TFont = record
        ByteWidth, Width, Height, MonoWidth, Vertical, Spacing : word;
        Offsets : TFontOffsets;
        Bitmap : PBytes;
    end;

    TImageDataBytes = array [0..$FF00] of byte;

    PImage = ^TImage;
    TImage = record
        Width, Height   : word;
        ByteWidth       : word;
        Compression     : byte;
        Reserved        : byte;
        DataSize        : word;
        ImageData       : TImageDataBytes;
    end;

    PMask = ^ TMask; { !! Warning, If TMask is different than TImage it will }
    TMask = TImage;  { break some stuff. At present, MaskImplode/Explode     }
                     { Assumes the TMask structure is identical to a TImage. }
                     { Actual Mask data is very different. But, for the      }
                     { purpose of compresion, that doesn't matter.           }

    PDIBitMap = ^TDIBitMap; { At present, this uses different functions to   }
    TDIBitMap = TImage;     { (un)compress data from that of TImage/TMask.   }

    PMaskedImage = ^TMaskedImage;
    TMaskedImage = record
        Image    : PImage;
        BMask    : PMask;
        IMask    : PImage; { Not sure If I want or need IMask. Don't rely on }
                           { it. I'll probably remove it completely.         }
        Sequence : Word;
        Reserved : Word;
    end;
    PMaskedImages = ^TMaskedImages;
    TMaskedImages = array[0..$0ffe] of TMaskedImage;

    TSpriteKind = byte;

    PSprite = ^TSprite;
    TSprite = record
        Prev, Next   : PSprite;
        Kind         : TSpriteKind;
        Level        : byte;
        Visible      : boolean;
        NeedsDrawn   : boolean;
        NeedsUndrawn : boolean;
        Animate      : integer;
        Area         : TArea;
        HotSpot      : TPoint;
        Index        : integer;
        Count        : integer;
        Sprites      : PMaskedImages;
        Behind       : PImage;
    end;

    PEvent = ^TEvent;
    TEvent = record
        Kind : word;
        case word of
            evNull : ();
            evKeyPress,
            evKeyRelease : (
                ScanCode   : word;
                KeyCode    : word;
                ShiftCode  : word;
                StatusCode : word;
            );
            evMouse : (
                Flags   : word;
                Buttons : word;
                Modifiers : dword;
                Position : TPoint;
                Movement : TPoint;
            );
            evCommand : (
                Command : word;
                Trigger : word; { 0 keyboard, $ffff program, other mouse buttons }
                Sender  : pointer; { should always set, or nil }
                case word of
                   0: ( Message : dword; );
                   1: ( Data : Pointer; );
            )
    end;

    TFontSettings = record
        Font : PFont;               { pointer }
        Monospace : boolean;
        Reserved  : byte;
        Direction : TDirection;     { word }
    end;

    PUISettings = ^TUISettings;
    TUISettings = record
        Padding     : TPoint;
        Font        : String;
        Spacing     : integer;
        Menu        : array [0..9] of TColors;
        Button      : array [0..11] of TColors; { >9 is for ON sticky buttons }
    end;

    PMenuItem = ^TMenuItem;
    TMenuItem = record
        Parent, Prev, Next, Child : PMenuItem;
        AutoHide : boolean;
        State : byte;
        Caption : String;
        Separator : boolean;
        Command : word;
        KeyCode : word;
        Sprite : PSprite;
    end;

    TButtonKind = (bkText, bkImage, bkSprite);

    PButtonItem = ^TButtonItem;
    TButtonItem = record
        Prev, Next : PButtonItem;
        Kind    : TButtonKind;
        Invisible, Sticky, Active : boolean;
        Dimension  : TPoint;
        Area : TArea;
        State : byte;
        Caption : String;
        Command : word;
        KeyCode : word;
        Image : PImage;
        Sprite : PSprite;
    end;

    TAssetPath = string[64];
    TAssetPaths = record
        Drivers,
        Fonts   : TAssetPath;
    end;
    TDrivers = record
        Video : String[12];
        Audio : String[12];
    end;

    TAppInfo = record
        Title,
        Version,
        Year,
        Author      : String;
        FontName    : Str12;
        Font        : PFont;
        Delay       : record
            Startup  : LongInt; { delay for when startup text is shown }
            Init     : LongInt; { minimum delay at startup = 0 }
            Shutdown : LongInt; { minimum delay at shutdown = 0 }
            Message  : LongInt; { only used if goodbye text is shown at exit }
        end;
        Driver      : TDrivers;
        VideoMode   : word;
        Subdir      : TAssetPaths;
    end;

    { See also DRIVERS.INC }

{$ENDIF}

{$IFDEF SECTIMP}

{ Internal Only Types }
type
    TNLSData = record
        TRUEStr,
        FALSEStr : Str20;
        Month : record
            Long, Short : array[0..12] of Str20;
        end;
        Day : record
            Long, Short : array[0..7] of Str20;
        end;
        AM, PM : Str20;
        SYS, LOG : record
            DATE : Str20;
            TIME : Str20;
            DATETIME : Str20;
        end;
        Error: record
            DriverInit,
            DriverFind,
            DriverMode,
            FontInit,
            FontFind  : String[80];
        end;
    end;

{
    TMemoryCrisisFunc = function (Size : Word) : integer;

    PMemoryCrisisHandlers = ^TMemoryCrisisHandlers;
    TMemoryCrisisHandlers = record
        Next : PMemoryCrisisHandlers;
        Class : byte;
        Handler : TMemoryCrisisFunc;
    end;
}
{$ENDIF}