{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

var
    UISettings : TUISettings;

function UIEvents(var Event : TEvent) : boolean;
procedure UIRefresh;

procedure AboutBox;

{$ENDIF}

{$IFDEF SECTIMP}

const
    UIDefaults  : TUISettings = (
        Padding     : (X:3; Y:1);
        Font        : '1012N-EN.FNT';
        Spacing     : 10;
        Menu        :
            (
                (Foreground:0;   Background:0),
                (Foreground:8;   Background:15), { Disabled }
                (Foreground:0;   Background:15), { Normal }
                (Foreground:4;   Background:7),  { Hover }
                (Foreground:15;  Background:2),  { Click }
                { Hot Key Colors, Foreground is used for Menus HotKey }
                (Foreground:0;   Background:0),
                (Foreground:8;   Background:0),
                (Foreground:2;   Background:0),
                (Foreground:15;  Background:0),
                (Foreground:8;   Background:0)
            );
        Button      :
            (
                (Foreground:7;   Background:255),
                (Foreground:8;   Background:15),
                (Foreground:0;   Background:15),
                (Foreground:4;   Background:7),
                (Foreground:15;  Background:2),
                (Foreground:3;   Background:2), { active / sticky button }
                { Hot Key Colors, Foreground is used for Button HotKey }
                { Background is used for Frame colors }
                (Foreground:0;   Background:255),
                (Foreground:8;   Background:15),
                (Foreground:2;   Background:15),
                (Foreground:15;  Background:4),
                (Foreground:8;   Background:2),
                (Foreground:7;   Background:2)  { active / sticky button }
            )
    );

function UIEvents(var Event : TEvent) : boolean;
var
    Handled : boolean;
begin
    { Event to close/clear menus, popups and buttons}
    Handled := False;

    if Assigned(MainButtons) then begin
        if (Event.Kind and evKeypress <> 0) and (Event.Keycode <> kbNone) and
        (Event.ShiftCode and $0008 = $0008) then { Either ALT Key }
            Handled := BtnKeyEvent(MainButtons, Event);
    end;

    if Assigned(MainButtons) then begin
        if Handled then begin
            BtnMouseEvent(MainButtons, ClearUIEvent);
        end else
        if (Event.Kind and evMouse <> 0) then
            Handled := BtnMouseEvent(MainButtons, Event);
    end;

    if Assigned(MainMenu) then begin
        if (Event.Kind and evKeypress <> 0) and (Event.Keycode <> kbNone) and
        (Event.ShiftCode and $0008 = $0008) then { Either ALT Key }
            Handled := MenuKeyEvent(MainMenu, Event);
    end;

    if Assigned(MainMenu) then begin
        if Handled then begin
            MenuMouseEvent(MainMenu, ClearUIEvent);
        end else
        if (Event.Kind and evMouse <> 0) then
            Handled := MenuMouseEvent(MainMenu, Event);
    end;
    UIEvents := Handled;
end;

procedure UIRefresh;
var
    Btn : PButtonItem;

begin
    { MenuLast := nil;
    MenuOver := nil;
    BtnOver  := nil; }
    Btn := MainButtons;
    while Assigned(Btn) do begin
        if Assigned(Btn^.Sprite) then
            Video^.SpriteUndraw(Btn^.Sprite);
        Btn := Btn^.Next;
    end;
    LastMouseBtns := 0;
end;

procedure AboutBox;
var
    P : Pointer;
    C : word;
    V, W, H : integer;
    XO, YO : integer;
    I : integer;
    E : TEvent;
begin
    P := nil;
    GetVersionInfo(P, C, 38);
    if Assigned(P) then begin
        H := C * FontHeight + 16;
        W := 0;
        for I := 0 to C - 1 do begin
            V := Video^.TextWidth(PtrStr(Pointers(P^)[I]));
            if V > W then W := V;
        end;
        Inc(W, 16);
        XO := GetMaxX div 2 - W div 2;
        YO := GetMaxY div 2 - H div 2;
        Video^.Region(XO, YO, XO + W, YO + H, 7);
        I := 1;
        Video^.Region(XO, YO, XO + W, YO + I, 0);
        Video^.Region(XO, YO + H - I, XO + W, YO + H, 0);
        Video^.Region(XO, YO, XO + I, YO + H, 0);
        Video^.Region(XO + W - I, YO, XO + W, YO + H, 0);
        Inc(XO, 8);
        Inc(YO, 8);
        for I := 0 to C - 1 do begin
            Video^.PutText(XO, YO, PtrStr(Pointers(P^)[I]), 0);
            FreeStr(PString(Pointers(P^)[I]));
            Inc(YO, FontHeight);
        end;
        FreeMem(P, C * Sizeof(Pointer));
    end;
    Wait(0,false);
end;


procedure InitUIVariables;
begin
    UISettings   := UIDefaults;
    MainMenu := nil;
    Render.Height := 0;
    Render.Font.Font := nil;
    Render.Font.Monospace := False;
    Render.Font.Direction := dmRight;
    Render.Level := 0;
    MenuLast := nil;
    MenuOver := nil;
    MainButtons := nil;
    BtnOver  := nil;
    LastMouseBtns := 0;
    With ClearUIEvent do begin
        Kind := evMouseMove;
        Position.X := -1;
        Position.Y := -1;
        Movement.X := 0;
        Movement.Y := 0;
        Flags := $ffff;
        Buttons := 0;
    end;
end;

{$ENDIF}