{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}


var
    MainButtons : PButtonItem;

{ Button Functions, very similar to MenuItems  }
function NewButtonItem(
    Width, Height : integer;
    Caption : String;
    Command : word; KeyCode : word) : PButtonItem;
{ 0 for Widrth/Height is AutoSize on Render }

procedure ButtonRender(Button : PButtonItem);
procedure ButtonRenderAll;
procedure ButtonMove(Btn : PButtonItem; X, Y : integer);
procedure ButtonShow(Btn : PButtonItem);
procedure ButtonHide(Btn : PButtonItem);
procedure ButtonDisable(Btn : PButtonItem);
procedure ButtonEnable(Btn : PButtonItem);
procedure ButtonSetEnabled(Btn : PButtonItem; Enabled : boolean);
procedure ButtonSetVisible(Btn : PButtonItem; Visible : boolean);
procedure ButtonSetActive(Button : PButtonItem; Active : boolean);

function ButtonFromImage(Image : PImage; Caption : String; Command : word; KeyCode : word) : PButtonItem;
function ButtonFromAsset(Name : String; Command : word; KeyCode : word) : PButtonItem;

{$ENDIF}

{$IFDEF SECTIMP}

var
    BtnOver     : PButtonItem;

{ Button Handler }
function NewButtonItem(
    Width, Height : integer;
    Caption : String;
    Command : word; KeyCode : word) : PButtonItem;
var
    B : PButtonItem;
    I : Integer;
begin
    NewButtonItem := nil;
    New(B);
    if not Assigned(B) then exit;
    FillChar(B^, Sizeof(TButtonItem), 0);
    B^.Caption      := Caption;
    B^.Command      := Command;
    B^.KeyCode      := KeyCode;
    B^.Kind         := bkText;
    B^.Dimension.X  := Width - 1;
    B^.Dimension.Y  := Height - 1;
    B^.Image        := nil;
    NewButtonItem := B;
    B^.Next := MainButtons;
    if Assigned(MainButtons) then
        MainButtons^.Prev := B;
    MainButtons := B;
end;

procedure SetButtonState(Button : PButtonItem; State : word);
begin
    if Assigned(Button^.Sprite) and (Button^.Sprite^.Count > 4) and
    Button^.Sticky and Button^.Active and (State = msNormal) then
        State := msActive;
    if Button^.State = State then exit;
    Button^.State := State;
    if Assigned(Button^.Sprite) then begin
        Video^.SpriteChange(Button^.Sprite, State);
    end;
end;

procedure ButtonRender(Button : PButtonItem);
var
    I : byte;
    P, W, H, OX, OY : Integer;
    C : TColor;
    Mask : PImage;
begin
    {$IFDEF LOGS}
    Log('Render Button Item ' + PtrHex(Button));
    {$ENDIF}
    if not Assigned(Button) then Exit;
    if Assigned(Button^.Sprite) then exit;
    Mask := nil;
    with Button^ do begin
        Video^.FreeSprite(Sprite);
        if not Assigned(Image) then begin
            W := Video^.TextWidth(Caption) + UISettings.Padding.X * 2;
            H := Video^.TextHeight(Caption) + UISettings.Padding.Y * 2;
            if Dimension.X < 1 then
                OX :=  UISettings.Padding.X
            else begin
                OX := Dimension.X div 2 - W div 2;
                W := Dimension.X;
            end;
            if Dimension.Y < 1 then
                OY :=  UISettings.Padding.Y
            else begin
                OY := Dimension.Y div 2 - H div 2;
                H := Dimension.Y;
            end;
            SetArea(Area.Left, Area.Top, Area.Right + W - 1, Area.Bottom + H -1, Area);
        end else begin
            W := Image^.Width;
            H := Image^.Height;
            SetArea(Area.Left, Area.Top, Area.Right + W - 1, Area.Bottom + H -1, Area);
        end;
        if (not Invisible) or (Caption <> '') or Assigned(Image) then begin
            if Sticky then
                Sprite := Video^.NewSprite(W, H, 6, true)
            else
                Sprite := Video^.NewSprite(W, H, 5, true);
            if Assigned(Sprite) then
                for I := 0  to Sprite^.Count - 1 do begin
                    Video^.FreeMask(Sprite^.Sprites^[I].BMask); { make um later }
                    Sprite^.Sprites^[I].Sequence := I;
                    if not Assigned(Image) then begin
                        if (I <> msNone) and Invisible then
                            Video^.ImageFill(Sprite^.Sprites^[I].Image, 0)
                        else
                            Video^.ImageFill(Sprite^.Sprites^[I].Image,
                                UISettings.Button[I].Background);
                        if Invisible and (I = msNormal) then
                            C := 0
                        else
                            C := I;
                        Video^.ImagePutText(Sprite^.Sprites^[I].Image,
                            OX, OY, Caption, UISettings.Button[C].Foreground);
                        if Keycode <> kbNone then begin
                            P := Pos(UCase(Chr(Lo(KeyCode))), UCase(Caption));
                            if P > 0 then begin
                                Dec(P);
                                Video^.ImagePutText(Sprite^.Sprites^[I].Image,
                                    OX + Video^.TextWidth(copy(Caption, 1, P)),
                                    OY, Caption[P + 1],
                                    UISettings.Button[C + 6].Foreground);
                            end;
                        end;
                    end else begin
                        Video^.FreeImage(Sprite^.Sprites^[I].Image);
                        Sprite^.Sprites^[I].Image := Video^.CloneImage(Image);
                        Video^.ImageExplode(Sprite^.Sprites^[I].Image);
                    end;
                    if (not Invisible) or (I <> msNormal) then begin
                        {if Assigned(Image) then
                            C := UISettings.Button[I + 6].Foreground
                        else}
                            C := UISettings.Button[I + 6].Background;
                        Video^.ImageFrame(Sprite^.Sprites^[I].Image, 1,
                            C,C);
                    end else if Assigned(Image) then begin
                    end else if (I <> msNone) and Invisible then
                        Sprite^.Sprites^[I].BMask := Video^.ImageToMask(
                            Sprite^.Sprites^[I].Image, 0)
                    else
                        Sprite^.Sprites^[I].BMask := Video^.ImageToMask(
                            Sprite^.Sprites^[I].Image, UISettings.Button[I].Background);
                    { if ImageCompress then Video^.ImageImplode(Sprite^.Sprites^[I].Image); }
                end;
        end;
        if Assigned(Sprite) then begin
            Sprite^.Kind := skButtonItem;
            Sprite^.Level := slButtonItem;
            Video^.SpriteShow(Sprite);
        end;
        if State = msNone then SetButtonState(Button, msNormal);
    end;
end;

procedure ButtonRenderAll;
var
    Button : PButtonItem;
begin
    Button := MainButtons;
    While Assigned(Button) do begin
        ButtonRender(Button);
        Button := Button^.Next;
    end;
end;

procedure ButtonMove(Btn : PButtonItem; X, Y : integer);
begin
    if not assigned(Btn) then exit;
    MoveArea(X, Y, Btn^.Area);
    if Assigned(Btn^.Sprite) then
        Video^.SpriteMove(Btn^.Sprite, Btn^.Area.Left, Btn^.Area.Top);
end;

procedure ButtonShow(Btn : PButtonItem);
begin
    if not (assigned(Btn) and Assigned(Btn^.Sprite)) then exit;
    Video^.SpriteShow(Btn^.Sprite);
end;

procedure ButtonHide(Btn : PButtonItem);
begin
    if not (assigned(Btn) and Assigned(Btn^.Sprite)) then exit;
    Video^.SpriteHide(Btn^.Sprite);
end;

procedure ButtonDisable(Btn : PButtonItem);
begin
    if Btn^.State <> msDisabled then begin
        SetButtonState(Btn, msDisabled);
        if Assigned(Btn^.Sprite) then begin
            Video^.SpriteHide(Btn^.Sprite);
        end;
    end;
end;

procedure ButtonEnable(Btn : PButtonItem);
begin
    if Btn^.State = msDisabled then begin
        SetButtonState(Btn,msNormal);
        if Assigned(Btn^.Sprite) then begin
            Video^.SpriteChange(Btn^.Sprite,Btn^.State );
        end;
    end;
end;

procedure ButtonSetEnabled(Btn : PButtonItem; Enabled : boolean);
begin
    if Enabled then
        ButtonEnable(Btn)
    else
        ButtonDisable(Btn);
end;

procedure ButtonSetVisible(Btn : PButtonItem; Visible : boolean);
begin
    if Visible then
        ButtonShow(Btn)
    else
        ButtonHide(Btn);
end;

procedure ButtonSetActive(Button : PButtonItem; Active : boolean);
var
    S : word;
begin
    S := Button^.State;
    if not Button^.Sticky then begin
        Button^.Active := false;
        if S = msActive then
            S := msNormal;
    end else begin
        Button^.Active := Active;
        if Active and (S = msNormal) then
            S := msActive
        else if (not Active) and (S = msActive) then
            S := msNormal;
    end;
    SetButtonState(Button, S);
end;

function BtnMouseEvent(Btn : PButtonItem; var Event : TEvent) : boolean;
var
    LastOver, P : PButtonItem;
    E : TEvent;
begin
    if not assigned(Btn) then exit;

    LastOver := BtnOver;
    BtnOver := nil;
    P := Btn;
    While Assigned(P) do begin
        if (P^.State <> msDisabled) and
        PixelInArea(Event.Position.X, Event.Position.Y, P^.Area) then begin
            BtnOver:=P;
            Break;
        end;
        P := P^.Next;
    end;
    if LastOver <> BtnOver then begin
        if Assigned(LastOver) then begin
            if LastOver^.State <>  msDisabled then begin
                SetButtonState(LastOver,msNormal);
            end;
        end;
    end;
    if (LastOver <> BtnOver) or (LastMouseBtns <> Event.Buttons) then begin
        if Assigned(BtnOver) then begin
            if BtnOver^.State <>  msDisabled then begin
                if Event.Buttons <> 0 then
                    SetButtonState(BtnOver,msClick)
                else
                    SetButtonState(BtnOver,msHover);
                if (Event.Kind and evMouseRelease = evMouseRelease) and
                (BtnOver^.Command <> cmNone) then begin
                    E.Kind := evCommand;
                    E.Command := BtnOver^.Command;
                    E.Trigger := LastMouseBtns;
                    E.Message := Event.Modifiers;
                    E.Sender := P;
                    PutEvent(E);
                end;
                LastMouseBtns := Event.Buttons;
            end;
        end;
    end;
    BtnMouseEvent := Assigned(BtnOver);
end;

function BtnKeyEvent(Btn : PButtonItem; var Event : TEvent) : boolean;
var
    Handled : boolean;
begin
    Handled := False;
    while Assigned(Btn) and (not Handled) do begin
        if Btn^.State <> msDisabled then begin
            if (Event.Keycode = Btn^.KeyCode) then begin
                Event.Kind := evCommand;
                Event.Command := Btn^.Command;
                Event.Message.L := Event.Shiftcode;
                Event.Message.H := Event.Statuscode;
                Event.Trigger := 0;
                Event.Sender  := Btn;
                PutEvent(Event);
                Event.Kind := evNull;
                Handled := True;
            end;
        end;
        Btn := Btn^.Next;
    end;
    BtnKeyEvent := Handled;
end;

function ButtonFromImage(Image : PImage; Caption : String; Command : word; KeyCode : word) : PButtonItem;
var
    B : PButtonItem;
begin
    B := nil;
    if Assigned(Image) then
        B :=  NewButtonItem(Image^.Width, Image^.Height, Caption, Command, KeyCode);
    if Assigned(B) then
        B^.Image := Image;
    ButtonFromImage := B;
end;

function ButtonFromAsset(Name : String; Command : word; KeyCode : word) : PButtonItem;
var
    P : PAsset;
    B : PButtonItem;
begin
    B := nil;
    if AssetLoad(Name, asDefault, P) then begin
        if not P^.Kind = ffImage then
            FatalError(erData_Verification_Error, 'button ' + PtrStr(P^.Name));
        B := ButtonFromImage(PImage(P^.Data), FileRoot(Name), Command, KeyCode);
        if not assigned(B) then
            AssetUnlock(P);
    end;
    ButtonFromAsset := B;
end;

{$ENDIF}