{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

    {
        nothing to see here, move along :-)
    }

procedure SetPoint(X, Y : integer; var Point : TPoint);
function  PixelInArea(X, Y : integer; var A : TArea) : boolean;
function  AreaOverLap(var A, B : TArea) : boolean;
procedure SetArea(X1, Y1, X2, Y2 : integer; var Area : TArea);
procedure MoveArea(X, Y : integer; var Area : TArea);

procedure GetFontSettings(var Settings : TFontSettings);
procedure SetFontSettings(Settings : TFontSettings);

procedure FontBestMatch(var Name : String; var Font : PFont);

function FontWidth : integer;
function FontHeight : integer;
function GetMaxX : integer;
function GetMaxY : integer;

function  FontBitmapSize(Font : PFont) : word;
procedure FontOffsetReset(var Font : PFont);

{$ENDIF}

{$IFDEF SECTIMP}
procedure SetPoint(X, Y : integer; var Point : TPoint);
begin
    Point.X := X;
    Point.Y := Y;
end;

function PixelInArea(X, Y : integer; var A : TArea) : boolean;
begin
    With A do
        PixelInArea := (X>= Left) and (X<=Right) and (Y>=Top) and (Y<=Bottom);
end;

function AreaOverLap(var A, B : TArea) : boolean;
begin
    AreaOverLap := True;
    if (A.Left >= B.Left) and (A.Left <= B.Right) then
        if ((A.Bottom >= B.Top) and (A.Top <= B.Bottom)) or
             ((A.Top <= B.Bottom) and (A.Bottom >= B.Top)) then exit;

    if (A.Right >= B.Left) and (A.Right <= B.Right) then
        if ((A.Bottom >= B.Top) and (A.Top <= B.Bottom)) or
             ((A.Top <= B.Bottom) and (A.Bottom >= B.Top)) then exit;

    if (A.Top >= B.Top) and (A.Top <= B.Bottom) then
        if ((A.Right >= B.Left) and (A.Right <= B.Right)) or
             ((A.Left <= B.Right) and (A.Right >= B.Left)) then exit;

    if (A.Bottom >= B.Top) and (A.Bottom <= B.Bottom) then
        if ((A.Right >= B.Left) and (A.Right <= B.Right)) or
             ((A.Left <= B.Right) and (A.Right >= B.Left)) then exit;

    AreaOverLap := False;
end;

procedure SetArea(X1, Y1, X2, Y2 : integer; var Area : TArea);
begin
    Area.Left   := X1;
    Area.Top    := Y1;
    Area.Right  := X2;
    Area.Bottom := Y2;
end;

procedure MoveArea(X, Y : integer; var Area : TArea);
var
    OX, OY : integer;
begin
    OX := X - Area.Left;
    OY := Y - Area.Top;
    Inc(Area.Left,   OX);
    Inc(Area.Top,    OY);
    Inc(Area.Right,  OX);
    Inc(Area.Bottom, OY);
end;

procedure GetFontSettings(var Settings : TFontSettings);
begin
    Settings.Font := Video^.GetFont;
    Settings.Monospace := Video^.GetMonospace;
    Settings.Direction := Video^.GetFontDirection;
end;

procedure SetFontSettings(Settings : TFontSettings);
begin
    Video^.SetFont(Settings.Font);
    Video^.SetMonospace(Settings.Monospace);
    Video^.SetFontDirection(Settings.Direction);
end;

procedure FontBestMatchTry(var Name : String; var P : PAsset);
var
    W, H : integer;
    OName : String;
begin
    if AssetLoad(AsPath(AppInfo.SubDir.Fonts) + Name, asDefault, P) then exit;
    { Any font in a storm }
    OName := Name;
    for W := StrInt(Copy(OName, 1,2)) downto 8 do
        for H := StrInt(Copy(OName, 3,2)) downto 8 do begin
            Name := ZPad(W, 2) + ZPad(H, 2) + Copy(OName, 5,12);
            if AssetLoad(AsPath(AppInfo.SubDir.Fonts) + Name, asDefault, P) then exit;
        end;
end;

procedure FontBestMatch(var Name : String; var Font : PFont);
var
    P : PAsset;
    Base, S : String;
begin
    Font := nil;
    Base := Copy(FileRoot(Name),1,6);
    S := Base + Language + '.FNT';
    FontBestMatchTry(S, P);
    if not Assigned(P) then begin
        S := Base + 'EN.FNT';
        FontBestMatchTry(S, P);
    end;
    if Assigned(P) then begin
        Name := S;
        Font := PFont(P^.Data);
    end;
end;

function FontWidth : integer;
var
    F : PFont;
begin
    F := Video^.GetFont;
    if Assigned(F) then
        FontWidth := F^.MonoWidth
    else
        FontWidth := 0;
end;

function FontHeight : integer;
var
    F : PFont;
begin
    F := Video^.GetFont;
    if Assigned(F) then
        FontHeight := F^.Height
    else
        FontHeight := 0;
end;

function GetMaxX : integer;
begin
    GetMaxX := Video^.Width - 1;
end;

function GetMaxY : integer;
begin
    GetMaxY := Video^.Height - 1;
end;

function FontBitmapSize(Font : PFont) : word;
var
    B, W, H : word;
begin
    if not assigned(Font) then begin
        FontBitmapSize := 0;
        exit;
    end;
    W := Font^.Width;
    H := Font^.Height;
    B := W div 8;
    if W mod 8 <> 0 then Inc(B);
    FontBitmapSize := B * H * 256;
end;

procedure FontOffsetReset(var Font : PFont);
var
    I, C, Y, X, BW : word;
    B, O, M : byte;
begin
    if not Assigned(Font) then Exit;
    with Font^ do begin
        MonoWidth := 0;
        for I := 0 to 255 do begin
            BW := Width div 8;
            if Width mod 8 <> 0 then Inc(BW);
            C := BW * Height * Ord(I);
            O := Width;
            M := 1;
            for Y := 0 to Height - 1 do
                for B := 0 to BW - 1 do
                    for X := 0 to 7 do
                       if (Bitmap^[C + Y * BW + B] shl X) and $80 = $80 then begin
                            if O > B * 8 + X then O := B * 8 + X;
                            if M < B * 8 + X then M := B * 8 + X;
                       end;
            Offsets[I].Offset := O;
            Offsets[I].Maximum := M;
            if M > MonoWidth then MonoWidth := M;
        end;
        Inc(MonoWidth);
        if MonoWidth > Width then MonoWidth := Width;
        Offsets[32].Offset := 0;
        Offsets[32].Maximum := MonoWidth div 2;
        Spacing := 1;
    end;
end;

{$ENDIF}