Unit MMenus;
Interface
uses Crt, Yd, Mouse, Windows;
TYPE
  Item = RECORD
    Name        : String;
    Hot_Key     : Char;
    Saman, X, Y : integer;
    Num_HKey    : integer;
    Code        : Integer;
    Sade        : Boolean;
    Max         : Integer;
    Default     : String;
End;

 SType = (BlackScreen1, BlackScreen2);


Type
  HelpStyle = (Hebrew, English);
  RL = (Right, Left, Enter);
var
  HLineStr : String;
  HLineStyle : HelpStyle;

Type

Menu = Object {12.3.97}
  Items           : ARRAY[1..20] OF Item;
  Count_Items     : Integer;
  Result          : Item;
  Color, BColor   : Byte;
  SColor, S2Color : Byte;
  Procedure Init;
  Procedure Add_Item(Name : String; Hot_Key : Char;
                       X, Y, Num_HKey : integer);
  Procedure Set_Items_Colors(Col, Bak, SCol, S2Col : Byte);
  Procedure Display_Items(NI : Integer);
  Procedure Play(Quit_Esc:Boolean);
  Procedure Erase;
End;

Menu2 = object
   Items : Array[1..20] of String[80];
   Hlps  : Array[1..20] of String[80];
   Count : Byte;
   Saman : Byte;
   X ,Y  : Byte;
   Color, BkColor, SColor : Byte;
   ResultStr : String[80];
   ResultInt : Byte;
   Procedure Init(PX, PY, PColor, PBkColor, PSColor : Byte);
   Procedure Add_Item(Name, Hlpln : String);
   Procedure Display_Items;
   Procedure Get_Choice;
End;
SubMenu = Object (Menu2)
             W : Win;
             Function Get_Choice : RL;
             Procedure InitWindow;
             Procedure ShowWindow;
             Procedure EraseWindow;
          End;

Menu3 = Object (Menu)
  R : Integer;
  Procedure Add_Item(Name : String; Hot_Key : Char;
                       X, Y, Code : integer);
  Procedure Set_Items_Colors(Col, Bak, SCol, S2Col : Byte);
  Procedure Display_Items(NI : Integer);
  Procedure Play(Quit_Esc:Boolean);
End;

YDialog = Object (Menu3)
              Name      : String;
              W         : Win;
              Procedure Init;
              Procedure InitWindow(PName : String);
              Procedure Display_Items(NI : Integer);
              Procedure Add_Sade(PName : String; Hot_Key : Char;
                         X, Y: integer; Default:String; Max : Integer);
              Procedure Play;
          End;


Function GetMX : Word;

Function GetMY : Word;

Procedure InitHelpLine(S:String; Sty:HelpStyle);

Procedure DispHelpLine;

Procedure DispLine(S:String; Sty:HelpStyle);

Function ChoiceMenu(Items : String; X, Y: Byte; Style : SType) : Byte;

Function ChoiceMenu2(Items : String; X, Y, Pos: Byte; Style : SType) : Byte;


Implementation
Procedure Menu.Init;
Begin
   Count_Items := 0;
End;

Procedure Menu.Add_Item(Name : String; Hot_Key : Char;
                          X, Y, Num_HKey : integer);
var
 C : integer;
Begin
   Inc(Count_Items);
   C := Count_Items;
   Items[C].Name := Name;
   Items[C].Hot_Key := UpCase(Hot_Key);
   Items[C].X := X;
   Items[C].Y := Y;
   Items[C].Num_HKey := Num_HKey;
End;

Procedure Menu.Set_Items_Colors(Col, Bak, SCol, S2Col : Byte);
Begin
   Color := Col;
   BColor := Bak;
   SColor := SCol;
   S2Color := S2Col;
End;

Procedure Menu.Display_Items(NI : Integer);
var
 I, J : Integer;
 IT   : ITem;
Begin
   TextColor(Color);
   TextBackground(BColor);
   FOR I := 1 to Count_ITems DO
   Begin
      IF I = NI THEN TextBackground(S2Color);
      IT := Items[I];
      GoToXY(IT.X,IT.Y);
      FOR J := 1 TO Length(IT.Name) DO
      Begin
         IF J = IT.Num_HKey then TextColor(SColor);
         Write(IT.Name[J]);
         TextColor(Color);
      End;
      TextBackground(BColor);
   End;
End;

Procedure Menu.Play(Quit_Esc:Boolean);
var
 I,J,N : integer;
 Key   : Char;
 Done  : Boolean;
Begin
   Done := False;
   Display_Items(1);
   N := 1;
   repeat
      Key := ReadKey;
      Key := UpCase(Key);
      J := 0;
      IF Key = #0 THEN
      Begin
         Key := ReadKey;
         Key := ' ';
      End;
      FOR I := 1 to Count_Items DO
      Begin
        IF Items[I].Hot_Key = Key THEN
        Begin
           J := I;
           Break;
        End;
      End;
      IF (Key = #9) and (N <= Count_Items) THEN
      Begin
         N := N + 1;
         Display_Items(N);
      End;
      IF (Key = #9) and (N > Count_Items) THEN
      Begin
         N := 1;
         Display_Items(N);
      End;
      IF (Key = Enter_Key) THEN
      Begin
         Result := Items[N];
         Done := True;
      End;
      IF J <> 0 Then
      Begin
         Display_Items(J);
         Delay(1000);
         Result := Items[J];
         Done := True;
      End
      else
      IF Quit_Esc then IF Key = Esc_Key THEN Done := True;
   until Done;
   Display_Items(0);
End;

Procedure Menu.Erase;
var
 SaveCol, SaveBCol, SaveSCol, SaveS2Col : Byte;
Begin
   SaveCol := Color;
   SaveBCol := BColor;
   SaveSCol := SColor;
   SaveS2Col := S2Color;
   Set_Items_Colors(0,0,0,0);
   Display_Items(0);
   Set_Items_Colors(SaveCol, SaveBCol, SaveSCol, SaveS2Col);
   TextColor(SaveCol);
   TextBackground(SaveBCol);
End;

Procedure Menu2.Init(PX, PY, PColor, PBkColor, PSColor : Byte);
Begin
   Count := 0;
   X := PX;
   Y := PY;
   Color := PColor;
   BkColor := PBkColor;
   SColor := PSColor;
End;

Procedure Menu2.Add_Item(Name, Hlpln : String);
Begin
   if Count < 20 then
   Begin
      Inc(Count);
      Items[Count] := Name;
      Hlps[Count] := Hlpln;
   End;
End;

Procedure Menu2.Display_Items;
var
 I : Byte;
Begin
   TextColor(Color);
   TextBackground(BkColor);
   for I := 1 to Count do
   Begin
      GoToXY(X, (Y-1)+I);
      if I = Saman then
      Begin
         DispLine(Hlps[I],HLineStyle);
         TextBackground(SColor);
      End;
      Write(Items[I]);
      TextBackground(BkColor);
   End;
End;

Procedure Menu2.Get_Choice;
var
 Ch : Char;
Begin
   ResultStr := '';
   Saman := 1;
   ResultInt := Saman;
   Repeat
      Display_Items;
      Ch := ReadKey;
      if Ch = #0 then Ch := ReadKey;
      if (Ch = Up_Key) then
      Begin
         if (Saman > 1) then Saman := Saman - 1
         else if Saman = 1 then Saman := Count;
      End;
      if (Ch = Down_Key) then
      Begin
         if (Saman < Count) then Saman := Saman + 1
         else if Saman = Count then Saman := 1;
      End;
      if Ch = Enter_Key then
      Begin
         ResultStr := Items[Saman];
         ResultInt := Saman;
      End;
   until Ch = Enter_Key;
   Saman := 0;
   Display_Items;
End;

Function SubMenu.Get_Choice : RL;
var
 Ch : Char;
Begin
   ResultStr := '';
   Saman := 1;
   ResultInt := Saman;
   InitWindow;
   Repeat
      ShowWindow;
      Display_Items;
      Ch := ReadKey;
      if Ch = #0 then Ch := ReadKey;
      if (Ch = Up_Key) then
      Begin
         if (Saman > 1) then Saman := Saman - 1
         else if Saman = 1 then Saman := Count;
      End;
      if (Ch = Down_Key) then
      Begin
         if (Saman < Count) then Saman := Saman + 1
         else if Saman = Count then Saman := 1;
      End;
      if Ch = Enter_Key then
      Begin
         ResultStr := Items[Saman];
         ResultInt := Saman;
      End;
   until (Ch = Enter_Key) or (Ch = Right_Key) or (Ch = Left_Key);
  { Saman := 0;
   Display_Items;    }
   if Ch = Right_Key then Get_Choice := Right;
   if Ch = Left_Key then Get_Choice := Left;
   if Ch = Enter_Key then Get_Choice := Enter;
   EraseWindow;
End;

Procedure SubMenu.InitWindow;
var
 MaxLength, I : Integer;
Begin
   MaxLength := 0;
   for I := 1 to Count do
   Begin
      if Length(Items[I]) > MaxLength then MaxLength := Length(Items[I]);
   End;
   W.Init(X-1,Y-1,X+MaxLength,Y+Count,15,Blue,'',Single);
End;

Procedure SubMenu.ShowWindow;
Begin
   Window(1,1,80,25);
   W.Draw;
   Window(1,1,80,25);
End;

Procedure SubMenu.EraseWindow;
Begin
   W.Erase;
End;


Procedure Menu3.Set_Items_Colors(Col, Bak, SCol, S2Col : Byte);
Begin
   BColor := Bak;
   SetSColor(Col, SCol);
   S2Color := S2Col;
End;

Procedure Menu3.Display_Items(NI : Integer);
var
 I    : Integer;
Begin
   TextColor(Color);
   TextBackground(BColor);
   FOR I := 1 to Count_ITems DO
   Begin
      IF I = NI THEN TextBackground(S2Color);
      GoToXY(ITems[I].X,ITems[I].Y);
      DispStr(Items[I].Name);
      TextBackground(BColor);
   End;
End;
Procedure Menu3.Add_Item(Name : String; Hot_Key : Char;
                       X, Y, Code : integer);
var
 C : integer;
Begin
   Inc(Count_Items);
   C := Count_Items;
   Items[C].Name := Name;
   Items[C].Hot_Key := UpCase(Hot_Key);
   Items[C].X := X;
   Items[C].Y := Y;
   Items[C].Code := Code;
   Items[C].Sade := False;
   Items[C].Default := '';
End;

Procedure Menu3.Play(Quit_Esc:Boolean);
var
 I,J,N : integer;
 Key   : Char;
 Done  : Boolean;
Begin
   Done := False;
   Display_Items(1);
   N := 1;
   repeat
      if KeyPressed then
      Begin
         Key := ReadKey;
         Key := UpCase(Key);
         J := 0;
         IF Key = #0 THEN
         Begin
            Key := ReadKey;
            Key := ' ';
         End;
         FOR I := 1 to Count_Items DO
         Begin
           IF Items[I].Hot_Key = Key THEN
           Begin
              J := I;
              Break;
           End;
         End;
         IF (Key = #9) and (N <= Count_Items) THEN
         Begin
            N := N + 1;
            Display_Items(N);
         End;
         IF (Key = #9) and (N > Count_Items) THEN
         Begin
            N := 1;
            Display_Items(N);
         End;
         IF (Key = Enter_Key) THEN
         Begin
            Result := Items[N];
            R := Items[N].Code;
            Done := True;
         End;
         IF J <> 0 Then
         Begin
            Display_Items(J);
            Delay(1000);
            Result := Items[J];
            R := Items[J].Code;
            Done := True;
         End
         else
         IF Quit_Esc then IF Key = Esc_Key THEN Done := True;
      End;
      if ButtonDown then
      Begin
         for I := 1 to Count_Items do
         if ((GetMX>Items[I].X-2) and (GetMX<Items[I].X+Length(Items[I].Name)-3))
         and(GetMY = Items[I].Y-1)
         then
         Begin
            Display_Items(I);
            Delay(1000);
            Result := Items[I];
            R := Items[I].Code;
            Done := True;
            Break;
         End;
      End;
   until Done;
   Display_Items(0);
End;

Function GetMX : Word;
Begin
   GetMX := GetMouseX div 4;
End;

Function GetMY : Word;
Begin
   GetMY := GetMouseY div 8;
End;

Procedure InitHelpLine(S:String; Sty:HelpStyle);
Begin
   HLineStr := S;
   HLineStyle := Sty;
End;

Procedure DispHelpLine;
var
 Svx, Svy : Byte;
Begin
   if HLineStyle = English then
   Begin
      Svx := WhereX;
      Svy := WhereY;
      GoToXY(1,25);
      ClrEol;
      Write(HLineStr);
      GoToXY(Svx, Svy);
   End;
   if HLineStyle = Hebrew then
   Begin
      Svx := WhereX;
      Svy := WhereY;
      GoToXY(1,25);
      ClrEol;
      GoToXY(79-Length(HLineStr),25);
      ClrEol;
      Write(HLineStr);
      GoToXY(Svx, Svy);
   End;
End;

Procedure YDialog.Init;
Begin
   Menu3.Init;
End;

Procedure YDialog.InitWindow(PName : String);
var
 X, Y, X1, Y1 : Byte;
 I            : Integer;
 Max, Min     : Byte;
Begin
   Name := PName;
   Max := 100;
   Min := 0;
   for I := 1 to Count_Items do
    if Items[I].X < Max then Max := Items[I].X;
   X := Max-1;
   Max := 100;
   Min := 0;
   for I := 1 to Count_Items do
    if Items[I].X+Length(Items[I].Name)+Items[I].Max  > Min then
      Min := Items[I].X+Length(Items[I].Name)+Items[I].Max;
   X1 := Min+1;
   Max := 100;
   Min := 0;

   for I := 1 to Count_Items do
    if Items[I].Y < Max then Max := Items[I].Y;

   Y := Max;
   Max := 100;
   Min := 0;

   for I := 1 to Count_Items do
    if Items[I].Y > Min then Min := Items[I].Y;

   Y1 := Min+1;
   W.Init(X-2, Y-2, X1+1, Y1, Color, BColor, Name, Double);
   W.Draw;
   Window(1,1,80,25);
End;

Procedure YDialog.Display_Items(NI : Integer);
var
 I, j : Integer;
Begin
   W.Draw;
   Window(1,1,80,25);
   TextColor(Color);
   TextBackground(BColor);
   FOR I := 1 to Count_ITems DO
   Begin
      IF I = NI THEN TextBackground(S2Color);
      GoToXY(ITems[I].X,ITems[I].Y);
      DispStr(Items[I].Name);
      if Items[I].Sade then
      Begin
         TextBackground(BColor);
         Write(' ');
         TextBackground(0);
         Write(Items[I].Default);
         for J := 1 to Items[I].max-Length(Items[I].Default) do Write(' ');
      End;
      TextBackground(BColor);
   End;
End;

Procedure YDialog.Add_Sade(PName : String; Hot_Key : Char;
                       X, Y: integer; Default:String; Max : Integer);
Begin
   Menu3.Add_Item(PName, Hot_Key, X, Y, 0);
   Items[Count_Items].Default := Default;
   Items[Count_Items].Max := Max;
   Items[Count_Items].Sade := True;
End;


Procedure YDialog.Play;
var
 I,J,N : integer;
 Key   : Char;
 Done  : Boolean;

Procedure Set_Result(Num : Byte);
Begin
   Result := Items[Num];
   R := Items[Num].Code;
   Done := True;
End;

Procedure ReadSade(Num : Byte);
Begin
   GoToXY(Items[Num].X+Length(Items[Num].Name)-1,Items[Num].Y);
   TextBackground(0);
   YRead(Items[Num].Default,Items[Num].Max,False);
   GoToXY(Items[Num].X,Items[Num].Y);
End;

Begin
   Done := False;
   Display_Items(1);
   N := 1;
   repeat
      if KeyPressed then
      Begin
         Key := ReadKey;
         Key := UpCase(Key);
         J := 0;
         IF Key = #0 THEN
         Begin
            Key := ReadKey;
            Key := ' ';
         End;
         FOR I := 1 to Count_Items DO
         Begin
           IF Items[I].Hot_Key = Key THEN
           Begin
              J := I;
              Break;
           End;
         End;
         IF (Key = #9) and (N <= Count_Items) THEN
         Begin
            N := N + 1;
            Display_Items(N);
         End;
         IF (Key = #9) and (N > Count_Items) THEN
         Begin
            N := 1;
            Display_Items(N);
         End;
         IF (Key = Enter_Key) THEN
         Begin
            if Items[N].Sade = False then
               Set_Result(N)
            else
               ReadSade(N);
         End;
         IF J <> 0 Then
         Begin
            Display_Items(J);
            Delay(1000);
            if Items[J].Sade = False then
               Set_Result(J)
            else
               ReadSade(J);
         End;
      End;
      if ButtonDown then
      Begin
         for I := 1 to Count_Items do
         if ((GetMX>Items[I].X-2) and (GetMX<Items[I].X+Length(Items[I].Name)-3))
         and(GetMY = Items[I].Y-1)
         then
         Begin
            Display_Items(I);
            Delay(1000);
            if Items[I].Sade = False then
               Set_Result(I)
            else
               ReadSade(I);
            Break;
         End;
      End;
   until Done;
   Display_Items(0);
End;


Procedure DispLine(S:String; Sty:HelpStyle);
Begin
   HLineStr := S;
   HLineStyle := Sty;
   DispHelpLine;
End;

Function StrSpace(Len : Byte) : String;
var
 I : Byte;
 S : String;
Begin
   S := '';
   for I := 1 to Len do
    S := S + ' ';
   StrSpace := S;
End;


Function ChoiceMenu(Items : String; X, Y: Byte; Style : SType) : Byte;
var
 A     : Array[1..30] of String;
 Count : Byte;
 I     : Byte;
 Saman : Byte;
 Done  : Boolean;
 Ch    : Char;
 MLen  : Byte;
 Col,
 BCol,
 SCol,
 MCol  : Byte;

Procedure DispScr;
var
 II : Byte;
Begin
   GoToXY(8,25);
   TextColor(Yellow);
   TextBackground(0);
   Write('Choose with arrow: ',#24,#25,'      Highlighted: [',Saman,']        Select with <Enter>');
   TextColor(Col);
   for II := 1 to Count do
   Begin
      GoToXY(X,Y+II-1);
      if II = Saman then
      Begin
         TextBackground(SCol);
         TextColor(MCol);
      End
     else
      Begin
         TextBackground(BCol);
         TextColor(Col);
      End;
      Write('  ',A[II],StrSpace(MLen-Length(A[II])), '  ');
   End;
   Beep(200,50,0);
End;

Begin
   if Style = BlackScreen1 then
   Begin
      Col := 15;
      BCol := 0;
      SCol := 15;
      MCol := 0;
   End;
   if Style = BlackScreen2 then
   Begin
      Col := 15;
      BCol := 0;
      SCol := Blue;
      MCol := Yellow;
   End;
   for i := 1 to 30 do
    A[I] := '';
   Count := 1;
   For I := 1 to Length(Items) do
   Begin
      if Items[i] <> ',' then
       A[Count] := A[Count] + Items[I]
      else
       Count := Count + 1;
   End;
   MLen := 0;
   for I := 1 to count do
   Begin
      if Length(A[I]) > MLen then MLen := Length(A[I]);
   End;
   Saman := 1;
   Done := False;
   DispScr;
   Repeat
      Ch := ReadKey;
      if Ch = #0 then
      Begin
         Ch := ReadKey;
         if Ch = Up_Key then
         Begin
            if Saman > 1 then Saman := Saman - 1
           else
            if Saman = 1 then Saman := Count;
           DispScr;
         End;
         if Ch = Down_Key then
         Begin
            if Saman < Count then Saman := Saman + 1
           else
            if Saman = Count then Saman := 1;
           DispScr;
         End;
      End;
      if Ch = Enter_Key then Done := True;
   Until Done;
   ChoiceMenu := Saman;
   Beep(800,100,100);
   Beep(800,100,100);
   Beep(800,100,100);
   Beep(800,100,100);
End;

Function ChoiceMenu2(Items : String; X, Y, Pos: Byte; Style : SType) : Byte;
var
 A     : Array[1..30] of String;
 Count : Byte;
 I     : Byte;
 Saman : Byte;
 Done  : Boolean;
 Ch    : Char;
 MLen  : Byte;
 Col,
 BCol,
 SCol,
 MCol  : Byte;

Procedure DispScr;
var
 II : Byte;
Begin
   GoToXY(8,25);
   TextColor(Yellow);
   TextBackground(0);
   Write('Choose with arrow: ',#24,#25,'      Highlighted: [',Saman,']        Select with <Enter>');
   TextColor(Col);
   for II := 1 to Count do
   Begin
      GoToXY(X,Y+II-1);
      if II = Saman then
      Begin
         TextBackground(SCol);
         TextColor(MCol);
      End
     else
      Begin
         TextBackground(BCol);
         TextColor(Col);
      End;
      Write('  ',A[II],StrSpace(MLen-Length(A[II])), '  ');
   End;
   Beep(200,50,0);
End;

Begin
   if Style = BlackScreen1 then
   Begin
      Col := 15;
      BCol := 0;
      SCol := 15;
      MCol := 0;
   End;
   if Style = BlackScreen2 then
   Begin
      Col := 15;
      BCol := 0;
      SCol := Blue;
      MCol := Yellow;
   End;
   for i := 1 to 30 do
    A[I] := '';
   Count := 1;
   For I := 1 to Length(Items) do
   Begin
      if Items[i] <> ',' then
       A[Count] := A[Count] + Items[I]
      else
       Count := Count + 1;
   End;
   MLen := 0;
   for I := 1 to count do
   Begin
      if Length(A[I]) > MLen then MLen := Length(A[I]);
   End;
   Saman := Pos;
   Done := False;
   DispScr;
   Repeat
      Ch := ReadKey;
      if Ch = #0 then
      Begin
         Ch := ReadKey;
         if Ch = Up_Key then
         Begin
            if Saman > 1 then Saman := Saman - 1
           else
            if Saman = 1 then Saman := Count;
           DispScr;
         End;
         if Ch = Down_Key then
         Begin
            if Saman < Count then Saman := Saman + 1
           else
            if Saman = Count then Saman := 1;
           DispScr;
         End;
      End;
      if Ch = Enter_Key then Done := True;
   Until Done;
   ChoiceMenu2 := Saman;
End;


End.