Program PowerPaint(c);

uses
  graph, VGA2, Crt, dos, Mouse, Yd,
  Tools1, Paint2u, vga, circle, mark;

var
  Gd, Gm : integer;
  DisplayMode : byte;

function DetectVGA256 : Integer; FAR;
begin
  DetectVGA256 := 0
end;

Procedure InitSVGA256;
begin
   gd := installuserdriver('svga256',@detectvga256);
   gm := displaymode;
   initgraph(gd,gm,'');
   setgraphmode(2);
   setgraphmode(0);
end;


Type
  ToolsType = (Pen, Brush, Sqware, LLine, TCircle, Fill);
  PicsType  = (Ymg, Ypc, Pic);

YPCHeader = Record
                    Buff : Array[1..90,1..90] of Byte;
                 End;


  PPic = record
           Asc: Array[1..50,1..80] of Char;
           Color, BkColor: Array [1..50,1..80] of integer;
           Password:String;
           P: integer
       End;


Button = record
           x,y,x1,y1 : Integer;
           PicFName  : Pointer;
         end;

Type
  YMGHeader = Record
                 Px, Py    : Integer;
                 S         : String[3];
              End;

function DetectMouse : Boolean;
var
  reg : registers;
Begin
  Reg.AX := $0000;
  Intr ($33,REG);
  If Reg.AX = $0000 then DetectMouse:=False else DetectMouse:=True;
End;

var
 xf              : Integer;
 I               : Integer;
 YY              : Integer;
 X,Y             : Integer;
 F               : File;
 P               : Pointer;
 Count           : Integer;
 Color           : Integer;
 Lx, Ly          : Integer;
 MouseDown       : Boolean;
 Px, Py          : Integer;
 PicMem          : Array[0..1600] of byte;
 ptype           : picstype;

 ToolMX, ToolMY  : Integer;
 CurTool         : ToolsType;
 Pe, B, S        : Button;
 Zm              : Button;
 Lo              : Button;
 Sv              : Button;
 Ne              : Button;
 Ex              : Button;
 Fl              : Button;

 pLx, pLy        : Integer;

 Pressed         : Boolean;
 Ss              : String;
 FName           : String;
 Done            : Boolean;
 Ch              : Char;
 r               : integer;
 SvType          : PicsType;
 Mask            : String;
 spx, spy        : integer;
 plt             : paltype;
 RGB             : BMP_Pal;

PROCEDURE BarLine(x,y,x2,y2,c : INTEGER; where : WORD);
  { draws a line }
VAR adx,ady : INTEGER;
    px,py : INTEGER;
    sign : SHORTINT;
    n : WORD;
BEGIN
     adx:=x2-x;
     ady:=y2-y;
     IF (adx<>0) or (ady<>0) THEN
     BEGIN
          sign:=1;
          IF abs(adx)>abs(ady) THEN
          BEGIN
               IF adx<0 THEN sign:=-1;
               adx:=abs(adx);
               FOR n:=0 TO adx DO
               BEGIN
                    py:=y+(ady*n+adx shr 1) div adx;
                    px:=x+n*sign;
                    Bar(px,py,px+4,py+4,c,where);
               END;
          END else
          BEGIN
               IF ady<0 THEN sign:=-1;
               ady:=abs(ady);
               FOR n:=0 TO ady DO
               BEGIN
                    px:=x+(adx*n+ady shr 1) div ady;
                    py:=y+n*sign;
                    Bar(px,py,px+4,py+4,c,where);
               END;
          END;
     END else Bar(x,y,x+4,y+4,c,where);
END;

Procedure DLine(x,y : integer);
var
 svline : array[1..1000] of byte;

PROCEDURE GetLine(x,y,x2,y2 : INTEGER);
  { draws a line }
VAR adx,ady : INTEGER;
    px,py : INTEGER;
    sign : SHORTINT;
    n : WORD;
    Count : integer;
BEGIN
     count := 0;
     adx:=x2-x;
     ady:=y2-y;
     IF (adx<>0) or (ady<>0) THEN
     BEGIN
          sign:=1;
          IF abs(adx)>abs(ady) THEN
          BEGIN
               IF adx<0 THEN sign:=-1;
               adx:=abs(adx);
               FOR n:=0 TO adx DO
               BEGIN
                    py:=y+(ady*n+adx shr 1) div adx;
                    px:=x+n*sign;
                    inc(count);
                    svline[count] := GetPixel(px,py,vvga);
               END;
          END else
          BEGIN
               IF ady<0 THEN sign:=-1;
               ady:=abs(ady);
               FOR n:=0 TO ady DO
               BEGIN
                    px:=x+(adx*n+ady shr 1) div ady;
                    py:=y+n*sign;
                    inc(count);
                    svline[count] := GetPixel(px,py,vvga);
               END;
          END;
     END else
          Begin
            svline[count] := GetPixel(x,y,vvga);
          end;
END;

PROCEDURE DrawLine(x,y,x2,y2 : INTEGER);
  { draws a line }
VAR adx,ady : INTEGER;
    px,py : INTEGER;
    sign : SHORTINT;
    n : WORD;
    Count : integer;
BEGIN
     count := 0;
     adx:=x2-x;
     ady:=y2-y;
     IF (adx<>0) or (ady<>0) THEN
     BEGIN
          sign:=1;
          IF abs(adx)>abs(ady) THEN
          BEGIN
               IF adx<0 THEN sign:=-1;
               adx:=abs(adx);
               FOR n:=0 TO adx DO
               BEGIN
                    py:=y+(ady*n+adx shr 1) div adx;
                    px:=x+n*sign;
                    inc(count);
                    PutPixel(px,py,svline[count],vvga);
               END;
          END else
          BEGIN
               IF ady<0 THEN sign:=-1;
               ady:=abs(ady);
               FOR n:=0 TO ady DO
               BEGIN
                    px:=x+(adx*n+ady shr 1) div ady;
                    py:=y+n*sign;
                    inc(count);
                    PutPixel(px,py,svline[count],vvga);
               END;
          END;
     END else
          Begin
             PutPixel(x,y,svline[count],vvga);
          end;
END;

var
 Lx, Ly : integer;
 i : integer;
Begin
{main}
   for i := 1 to 1000 do
     svline[i] := 0;
   Repeat until buttonup;
   lx := getmousex+1;
   ly := getmousey+1;
   if lx >= px then lx := px-1;
   if ly >= py then ly := py-1;
   if lx < 2   then lx := 2;
   if ly < 18  then ly := 18;
   if x >= px then x := px-1;
   if y >= py then y := py-1;
   if x < 2   then x := 2;
   if y < 18  then y := 18;
   getline(x,y,lx,ly);
   line(x,y,lx,ly,15,vvga);

   Repeat
      if (lx <> getmousex+1) or (ly <> getmousey+1) then
      begin
         hidemouse;
         drawline(x,y,lx,ly);
         lx := getmousex+1;
         ly := getmousey+1;
         if lx >= px then lx := px-1;
         if ly >= py then ly := py-1;
         if lx < 2   then lx := 2;
         if ly < 18  then ly := 18;
         getline(x,y,lx,ly);
         line(x,y,lx,ly,15,vvga);
         showmouse;
      end;
   Until ButtonDown;
   line(x,y,lx,ly,color,vvga);
End;

Procedure DLineAct;
Begin
   repeat until buttonup;
   dline(getmousex,getmousey);
   repeat until buttonup;
End;

Procedure Square(x,y : Integer);
var
 X1, Y1 : Integer;
 I      : Integer;
 SqSave : Array[1..1040] of Byte;

Procedure SaveSq;
var
 I, J : Integer;
Begin
   J := 1;
   for I := 1 to (x1-x) do
   Begin
      SqSave[J] := GetPixel(x+I,y,vvga);
      Inc(J);
   End;
   Line(x,y,x1,y,15,vvga);

   for I := 1 to (x1-x) do
   Begin
      SqSave[J] := GetPixel(x+I,y1,vvga);
      Inc(J);
   End;
   Line(x+1,y1,x1,y1,15,vvga);

   for I := 2 to (y1-y-1) do
   Begin
      SqSave[J] := GetPixel(x,y+I,vvga);
      Inc(J);
   End;
   Line(x,y+2,x,y1-1,15,vvga);

   for I := 2 to (y1-y-1) do
   Begin
      SqSave[J] := GetPixel(x1,y+I,vvga);
      Inc(J);
   End;
   Line(x1,y+2,x1,y1-2,15,vvga);
End;

Procedure DrawSq;
var
 I, J : Integer;
Begin
   J := 1;
   for I := 1 to (x1-x) do
   Begin
      PutPixel(x+I,y,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 1 to (x1-x) do
   Begin
      PutPixel(x+I,y1,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 2 to (y1-y-1) do
   Begin
      PutPixel(x,y+I,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 2 to (y1-y-1) do
   Begin
      PutPixel(x1,y+I,SqSave[J],vvga);
      Inc(J);
   End;
End;

var
 Sx, Sy : Integer;
Begin
   X1 := GetMouseX;
   Y1 := GetMouseY;
  { SaveSq;}
   for I := 1 to 1040 do SqSave[I] := 0;
   HideMouse;
   Repeat
      if (GetMouseX+1 <> Sx) or (GetMouseY+1 <> Sy) then
      Begin

         DrawSq;
         x1 := GetMouseX+1;
         y1 := GetMouseY+1;
         if x1 >= Px-1 then
           x1 := px-1;
         if y1 >= Py-1 then
           y1 := Py-1;

         if x1 <= x+4 then
          x1 := x+4;
         if y1 <= y+4 then
          y1 := y+4;

         sx := x1;
         sy := y1;
         SaveSq;

      End;
   Until ButtonDown;
   Box(x,y,x1,y1,Color,vvga);
   ShowMouse;
   Repeat Until ButtonUp;
End;

Procedure ZoomSq(var x,y : Integer);
var
 X1, Y1 : Integer;
 I      : Integer;
 SqSave : Array[1..1040] of Byte;

Procedure SaveSq;
var
 I, J : Integer;
Begin
   J := 1;
   for I := 2 to (x1-x) do
   Begin
      SqSave[J] := GetPixel(x+I,y,vvga);
      Inc(J);
   End;
   Line(x+2,y,x1,y,15,vvga);

   for I := 1 to (x1-x) do
   Begin
      SqSave[J] := GetPixel(x+I,y1,vvga);
      Inc(J);
   End;
   Line(x+1,y1,x1,y1,15,vvga);

   for I := 2 to (y1-y-1) do
   Begin
      SqSave[J] := GetPixel(x,y+I,vvga);
      Inc(J);
   End;
   Line(x,y+2,x,y1-1,15,vvga);

   for I := 2 to (y1-y-1) do
   Begin
      SqSave[J] := GetPixel(x1,y+I,vvga);
      Inc(J);
   End;
   Line(x1,y+2,x1,y1-2,15,vvga);
End;

Procedure DrawSq;
var
 I, J : Integer;
Begin
   J := 1;
   for I := 2 to (x1-x) do
   Begin
      PutPixel(x+I,y,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 1 to (x1-x) do
   Begin
      PutPixel(x+I,y1,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 2 to (y1-y-1) do
   Begin
      PutPixel(x,y+I,SqSave[J],vvga);
      Inc(J);
   End;

   for I := 2 to (y1-y-1) do
   Begin
      PutPixel(x1,y+I,SqSave[J],vvga);
      Inc(J);
   End;
End;

var
 Sx, Sy : Integer;
 HefX, HefY : Integer;
Begin
   X1 := GetMouseX;
   Y1 := GetMouseY;
   HefX := 40;
   HefY := 40;
   for I := 1 to 1040 do SqSave[I] := 0;
   HideMouse;
   Repeat
      if (GetMouseX <> Sx) or (GetMouseY <> Sy) then
      Begin

         DrawSq;
         x := GetMouseX;
         y := GetMouseY;

         if x+hefX > Px then
           x := px-HefX;
         if y+HefY >= Py then
           y := Py-HefY-1;

         if X < 1 then
          X := 1;
         if Y < 18 then
          Y := 18;

         X1 := X+HefX;
         Y1 := Y+HefY;

         sx := x;
         sy := y;
         SaveSq;

      End;
   Until ButtonDown;
   DrawSq;
   ShowMouse;
   Repeat Until ButtonUp;
End;


Procedure SetRange;
Begin
   rx := 2;
   ry := 18;
   rx1 := px;
   ry1 := py;
End;

{-----------------------------------  Tools  ----------------------------- }
Procedure InitPencel;
Begin
   delpointer;
   CurTool := Pen;
   drawpointer(pe.x-9,pe.y);
End;

procedure InitLine;
begin
   delpointer;
   CurTool := LLine;
   drawpointer(ne.x-9,ne.y);
end;

procedure InitFill;
begin
   delpointer;
   CurTool := Fill;
   drawpointer(fl.x-9,fl.y);
end;

procedure FillAct;
var
 X, Y : integer;
begin
   X := GetMouseX;
   Y := GetMouseY;
   if (X > 2) and (X < Px) and
       (Y > 22) and (Y < Py) then
       begin
          SetFillStyle(1,Color);
          FloodFill(X, Y, 15);
       end;
end;

Procedure InitCircle;
begin
   delpointer;
   CurTool := TCircle;
   drawpointer(sv.x-9,sv.y);
end;

Procedure PencelAct;
Begin
   if X > px-2 then x:=px-1;
   if Y > py-2 then y:=py-1;
   if X < 2 then X := 2;
   if Y < 19 then Y := 18;

   if MouseDown then
      Line(Lx,Ly,X,Y,Color,vvga)
    else
      PutPixel(X, Y, Color, vvga);
End;

Procedure InitBrush;
Begin
   delpointer;
   CurTool := Brush;
   drawpointer(b.x-9,b.y);
End;

Procedure BrushAct;
Begin
   if X > px-7 then x:=px-5;
   if Y > py-7 then y:=py-5;
   if X < 2 then X := 2;
   if Y < 19 then Y := 18;

   if MouseDown then
     BarLine(Lx,Ly,X,Y,Color,VVga)
   else;
     Bar(X,Y,X+4,Y+4,color,vvga);
End;

Procedure InitSqware;
Begin
   delpointer;
   CurTool := Sqware;
   drawpointer(s.x-9,s.y);
End;

Procedure SqwareAct;
var
 x, y : Integer;
Begin
   Repeat Until ButtonUp;
   x := GetMouseX;
   y := GetMouseY;
   if X > px-7 then x:=px-5;
   if Y > py-7 then y:=py-5;
   if X < 2 then X := 2;
   if Y < 19 then Y := 18;


   Square(X,Y);
End;

Procedure BBox(B : Button);
Begin
   Draw_IMGM(B.PicFNAME,B.X+2,B.Y+1);
   Box(B.X,B.Y,B.X1,B.Y1,color,vvga);
End;

{-------------------------------- Tools (End) ------------------------- }
Procedure BPutPixel(x,y,col : integer; Addr : Word);
Begin
     Bar(x*6,y*4,(x*6)+6,(y*4)+4,col,Addr);
End;

Function BGetPixel(x,y : Integer) : Byte;
Begin
   BGetPixel := GetPixel((x*6)+2,(y*4)+2,vvga);
End;


Procedure BPutPixel2(x,y,col : integer);
Begin
   if (plx <> x) or (ply <> y) then
   Begin
      HideMouse;
      Bar(x*6,y*4,(x*6)+5,(y*4)+3,col,vvga);
      ShowMouse;
      plx := x;
      ply := y;
   End;
End;

procedure SFlip(source,dest:Word);
  { This copies the entire screen at "source" to destination }
begin
  asm
    push    ds
    mov     ax, [Dest]
    mov     es, ax
    mov     ax, [Source]
    mov     ds, ax
    xor     si, si
    xor     di, di
    mov     cx, 32000
    rep     movsw
    pop     ds
  end;
end;



Procedure Zoom;
var
 I : Integer;
 sx, sy : Integer;
 P      : Pointer;
 xx, yy : Integer;
 Svx, Svy : Integer;
 f      : file;
 Done   : Boolean;
 SavBak : Pointer;
 VisScr : Pointer;

Procedure Save(Px, Py : Integer; ifSq : Boolean);
var
 I : Integer;
Begin
   HideMouse;
 {  Assign(F,'pictemp.tmp');
   Rewrite(F,1);
   BlockWrite(F,mem[$A000:0],64000);
   Close(F);                        }

   X := PX;
   Y := PY;
   if ifSq then
   Begin
      ShowMouse;
      ZoomSq(X, Y);
      HideMouse;
   End;
   Svx := x;
   Svy := y;
   sx := x+2;
   sy := y;
   for I := 1 to 1558 do
   Begin
      PicMem[I] := GetPixel(sx,sy,Seg(SavBak^));
      if sx = x+39 then
      Begin
        Inc(sy);
        sx := x+1;
      End;
      Inc(sx);
   End;

   FillChar(mem[Seg(VisScr^):4600],59400,0);
   x := 5;
   y := 5;
   Sx := X+2;
   Sy := Y;
   for I := 1 to 1558 do
   Begin
     BPutPixel(Sx,Sy,PicMem[I],Seg(VisScr^));
     if Sx = X+39 then
     Begin
        Sx := X+1;
        Inc(Sy);
     End;
     Inc(Sx);
   End;
   box(x+34,y+13,((x+40)*6)+2,(y+42)*4,15,Seg(VisScr^));
   SFlip(Seg(VisScr^),vvga);

   ShowMouse;
   ShowMouse;
End;

Procedure Back;
var
 I : Integer;
Begin
   HideMouse;
   x := 5;
   y := 5;
   Sx := X+2;
   Sy := Y;
   for I := 1 to 1558 do
   Begin
     PicMem[I] := BGetPixel(Sx,Sy);
     if Sx = X+39 then
     Begin
        Sx := X+1;
        Inc(Sy);
     End;
     Inc(Sx);
   End;

{   FillChar(mem[$a000:4600],59400,0);}
 {  Assign(F,'pictemp.tmp');
   Reset(F,1);
   BlockRead(F,mem[$A000:0],64000);
   Close(F);}
{   Move(SavBak^,mem[$A000:0],64000);}

   x := Svx;
   y := Svy;
   sx := x+2;
   sy := y;

   for I := 1 to 1558 do
   Begin
      PutPixel(sx,sy,Picmem[I],Seg(savbak^));
      if sx = x+39 then
      Begin
        Inc(sy);
        sx := x+1;
      End;
      Inc(sx);
   End;
   ShowMouse;
End;

var
 Ch : Char;
Begin
   Done := False;
   GetMem(SavBak,64000);
   move(mem[$A000:0], SavBak^, 64000);

   GetMem(VisScr,64000);
   move(mem[$A000:0], VisScr^, 64000);

   Save(GetMouseX,GetMouseY,True);
   Repeat
      if KeyPressed then
      Begin
        Ch := ReadKey;
        if Ch = #0 then
        Begin
           Ch := ReadKey;
           if (Ch = Right_Key) and ((SvX+40) < Px) then
           Begin
              Back;
              Save(X+1,Y,False);
           End;

           if (Ch = Left_Key) and (SvX > 0) then
           Begin
              Back;
              Save(X-1,Y,False);
           End;

           if (Ch = Up_Key) and (SvY > 18) then
           Begin
              Back;
              Save(X,Y-1,False);
           End;

           if (Ch = Down_Key) and ((SvY+41) < Py) then
           Begin
              Back;
              Save(X,Y+1,False);
           End;
        End;
        if Ch = Esc_Key then Done := True;
      End;

      if (ButtonDown)  then
      Begin
        if (GetMouseY < 15) then
        Begin
            HideMouse;
            Color := GetPixel(GetMouseX, GetMouseY, vvga);
            ShowMouse;
            Bar(1,1,7,15,color,vvga)
        End
       else
        Begin
           xx := ((GetMouseX) div 6);
           yy := ((GetMouseY) div 4);

           if (xx >= x+2) and (xx <= x+39)and
              (yy >= y)   and (yy <= y+40) then
           Begin
             { HideMouse;}
              BPutPixel2(xx,yy,color);
             { ShowMouse;}
           End;
        End;
      End;
   Until Done;
   Back;
   move(SavBak^,mem[$A000:0], 64000);
   FreeMem(SavBak,64000);
   FreeMem(VisScr,64000);
End;

Function InB(X,Y : Integer; B: Button) : Boolean;
Begin
   if (X >= B.X) and (X <= B.X1) and
      (Y >= B.Y) and (Y <= B.Y1) then
        InB := True
       else
        InB := False;
End;

Procedure SavePic(FileName : String);
var
 IMG : YMGHeader;
 P   : Pointer;
 F   : File;
 PC  : PPic;
 i,j : integer;
 YP  : YPCHeader;

Begin
   HideMouse;

   if PType = PIC then
   begin
      for j := 1 to 50 do
       for i := 1 to 80 do
       begin
          PC.BkColor[j,i] := getpixel(i+1,j+16,vvga);
          PC.Asc    [j,i] := ' ';
          PC.Color  [j,i] := 15;
       end;
       Assign(f,FileName);
       Rewrite(F,1);
       BlockWrite(F,PC,SizeOf(PC));
       Close(F);
   end;

   if PType = YPC then
   begin
      for j := 1 to 90 do
       for i := 1 to 90 do
       begin
          YP.Buff[j,i] := getpixel(i+1,j+17,vvga);
       end;
       Assign(f,FileName);
       Rewrite(F,1);
       BlockWrite(F,YP,SizeOf(YP));
       Close(F);
   end;

   if PType = YMG then
   begin
      GetMem(P,(Px-2)*(Py-18));
      GetSprite(P,2,18,(Px-2),(Py-18),vvga);
      IMG.Px := Px;
      IMG.Py := Py;
      IMG.s := 'ymg';
      Assign(F,FileName);
      Rewrite(F,1);
      BlockWrite(F,IMG,SizeOf(IMG));
      BlockWrite(F,P^,(Px-1)*(Py-17));
      Close(F);
      FreeMem(P,(Px-2)*(Py-18));
   end;



   ShowMouse;
End;

Procedure InitColors;
Begin
   YY := 0;
   XX := 0;
   Count := 0;
   for I := 0 to 256 do
   Begin
      Inc(XX);
      Inc(Count);
      Bar(XX*5,YY,(XX*5)+5,3+YY,I-1,vvga);
      if Count > 60 then
      Begin
         Count := 0;
         Inc(YY,3);
         XX := 1;
      End;
   End;

End;

Procedure DrawButtons;
Begin
   Color := 15;
   BBox(Pe);
   BBox(B);
   BBox(S);
   BBox(Zm);
   BBox(Ne);
   BBox(Sv);
   BBox(Fl);
   BBox(Lo);
   drawlastpointer;
End;

Procedure LoadPic(FileName : String);
var
 IMG : YMGHeader;
 P   : Pointer;
 F   : File;
 PC  : PPic;
 YP  : YPCHeader;
 i,j : integer;
 size: longint;
 f2  : file of byte;
Begin
   HideMouse;
   if PType = PIC then
   begin
      Assign(f,FileName);
      Reset(F,1);
      BlockRead(F,PC,SizeOf(PC));
      Close(F);
      Cls(0,vvga);
      DrawButtons;
      InitColors;
      for j := 1 to 50 do
       for i := 1 to 80 do
       begin
          putpixel(i+1,j+16,PC.BkColor[j,i],vvga);
       end;
       Box(1,17,PX, PY, 15, vvga);
   end;

   if PType = YPC then
   begin
      Assign(f,FileName);
      Reset(F,1);
      BlockRead(F,YP,SizeOf(YP));
      Close(F);
      Cls(0,vvga);
      DrawButtons;
      InitColors;
      for j := 1 to 90 do
       for i := 1 to 90 do
       begin
          putpixel(i+1,j+17,YP.Buff[j,i],vvga);
       end;
      Box(1,17,PX, PY, 15, vvga);
   end;

   if PType = YMG then
   Begin
      Assign(F,FileName);
      Reset(F,1);
      BlockRead(F,IMG,SizeOf(IMG));
      Px := IMG.Px;
      Py := IMG.Py;
      if IMG.s = 'ymg' then
      begin
         GetMem(P,(Px-2)*(Py-18));
         BlockRead(F,P^,(Px-1)*(Py-17));
         Cls(0,vvga);
         DrawButtons;
         InitColors;
         PutSprite(P,2,18,Px-2,Py-18,vvga);
         Box(1,17,PX, PY, 15, vvga);
         Close(F);
         FreeMem(P,(Px-2)*(Py-18));
      end
     else
      loadpic('tmp.tmp');
   End;
{   assign(f,'bbb.pal');
   reset(f,1);
   blockread(f,rgb,sizeof(rgb));
   set_bmp_pal(rgb);}
   ShowMouse;
End;


Procedure SetSize;
Begin
   Repeat
       if (Px <> GetMouseX) or (Py <> GetMouseY) then
       Begin
          HideMouse;
          Box(1,17,Px, Py, 0, vvga);
          Px := GetMouseX;
          Py := GetMouseY;
          if Py < 62 then Py := 62;
          if Px < 42 then Px := 42;
          if Px > 290 then Px := 290;
          Box(1,17,PX, PY, 15, vvga);
          ShowMouse;
       End;
   Until ButtonDown;
   Repeat Until ButtonUp;
   setrange;
End;

Procedure LoadAs;
Begin
   Repeat until ButtonUp;
   showmouse;
   r := gmenu(lo.x-94,lo.y-10,0,blue,15,'Ymg file|Ypc file|Pic file');
   hidemouse;
   spx := px;
   spy := py;
   SvType := PType;
   SavePic('TMP.TMP');
   case r of
       1:begin
           Ptype := YMG;
           Mask  := '*.YMG';
         end;
       2:begin
           Ptype := YPC;
           Mask  := '*.YPC';
           px := 90+2;
           py := 90+18;
         end;
       3:begin
           Ptype := PIC;
           Mask  := '*.PIC';
           px := 80+2;
           py := 50+16;
         end;
   end;
   if r <> 0 then
   begin
      SetText;
      showmouse;
      Ss := OpenDialog(Mask);
      hidemouse;
   {   SetMCGA;}
      initSVGA256;
   end;
   if (Ss = '') or (r=0) then
   begin
      px := spx;
      py := spy;
      ptype := svtype;
      LoadPic('TMP.TMP');
   end
  else
   LoadPic(Ss);
   repeat Until ButtonUp;
   Pressed := True;
End;

Procedure SaveAs;
Begin
   r := 1;
   SvType := PType;
   Repeat until buttonup;
   showmouse;
   if ptype = ypc then
   begin
      r := gmenu(lo.x-94,lo.y-10,0,blue,15,'Ymg file|Ypc file');
      if r = 1 then
      begin
         ptype := ymg;
         mask := '*.ymg';
      end
     else
      mask := '*.ypc';
     end;
     if ptype = pic then
     begin
        r := gmenu(lo.x-94,lo.y-10,0,blue,15,'Ymg file|Pic file');
       if r = 1 then
       begin
          ptype := ymg;
          mask := '*.ymg';
       end
      else
       mask := '*.pic';
     end;
     hidemouse;
     if r <> 0 then
     begin
        SavePic('tmp.tmp');
        SetText;
        Window(1,1,80,25);
        FName := '';
        showmouse;
        Ss := SaveDialog(Mask,FName);
        hidemouse;
        if KeyPressed then
          ReadKey;
        {SetMCGA;}initSVGA256;
        LoadPic('tmp.tmp');
        if Ss <> '' then
        Begin
           FName := Ss;
           SavePic(FName);
        End
       else
        PType := SvType;
     end;
     Repeat Until ButtonUp;
     Pressed := True;
End;

Procedure NewF;
Begin
                 Repeat Until ButtonUp;
                 showmouse;
                 r := gmenu(lo.x-94,lo.y-20,0,blue,15,'Ymg file|Ypc file|Pic file');
                 hidemouse;
                 Repeat Until ButtonUp;
                 case r of
                    1:begin
                         PType := YMG;
                         Cls(0,vvga);
                         DrawButtons;
                         InitColors;
                         SetSize;
                         Pressed := True;
                         Mask := '*.YMG';
                      end;

                    2:begin
                         PType := YPC;
                         Cls(0,vvga);
                         DrawButtons;
                         InitColors;
                         px := 90+2;
                         py := 90+18;
                         Box(1,17,PX, PY, 15, vvga);
                         Pressed := True;
                         Mask := '*.YPC';
                      end;
                    3:begin
                         PType := PIC;
                         Cls(0,vvga);
                         DrawButtons;
                         InitColors;
                         px := 80+2;
                         py := 50+16;
                         Box(1,17,PX, PY, 15, vvga);
                         Pressed := True;
                         Mask := '*.PIC';
                      end;
                     0:Pressed := true;
                 end;
End;

Procedure CircleAct;
Begin
   ry := ry+1;
   ry1 := ry1-1;
   rx := rx+1;
   rx1 := rx1-1;
   ddcircle(getmousex,getmousey,color);
   ry := ry-1;
   ry1 := ry1+1;
   rx := rx-1;
   rx1 := rx1+1;

End;

procedure about;
var
 i : integer;
begin
   textcolor(15);
   textbackground(0);
   clrscr;
   writeln('Y.M.S. PowerPaint (c)');
   writeln('Copyright(c) 1998 by Yotam Madem!');
   writeln('Y.M.S - Yotam. Madem. Software.');
   for i := 1 to 50 do
     waitretrace;

end;

procedure detecttmouse;
var
 i : integer;
begin
   writeln;
   write('Detecting mouse...');
   if not detectmouse then
   begin
      writeln;
      writeln;
      writeln('Y.M.S. PowerPaint initalization faild!');
      writeln('Error #1 : Cannot detect mouse.');
      writeln('Make shour that your mouse driver was successfuly loaded!');
      halt;
   end;
   writeln('success!');
   for i := 1 to 20 do
     waitretrace;
end;

Begin
   About;
   DetecttMouse;
   {Buttons}
   Pe.X := 300; Pe.X1 := 319; Pe.Y := 15; Pe.Y1 := 35;
   b .X := 300; b .X1 := 319; b .Y := 37; b .Y1 := 57;
   s .X := 300; s .X1 := 319; s .Y := 59; s .Y1 := 79;
   Zm.X := 300; Zm.X1 := 319; Zm.Y := 81; Zm.Y1 := 101;
   Ne.X := 300; Ne.X1 := 319; Ne.Y := 103;Ne.Y1 := 123;
   sv.X := 300; sv.X1 := 319; sv.Y := 125;sv.Y1 := 145;
   Lo.X := 300; Lo.X1 := 319; Lo.Y := 169;Lo.Y1 := 189;
   Fl.X := 300; Fl.X1 := 319; Fl.Y := 147;Fl.Y1 := 167;

   Ne.PicFName := @PLINE;
   Lo.PicFName := @FILED;
   Pe.PicFName := @paint2u.PEN;
   B .PicFName := @BRSH;
   s .PicFName := @RECT;
   Zm.PicFName := @paint2u.ZOOM;
   sv.PicFName := @PCIRCLE;
   fl.PicFName := @FillDat;

   {SetMCGA;}
   initSVGA256;

   GetAllPal(plt);
   FadeOutFast;
   Randomize;
   Color := 15;
   Mask := '*.YMG';
   DrawButtons;

   Px := 30;
   Py := 30;

   InitColors;
   InitMouse;
   ShowMouse;
   MouseDown := False;
   InitPencel;
   FadeTo(0,plt);
   SetSize;
   Done := False;

   Repeat
      if KeyPressed then
      Begin
         Ch := ReadKey;
         if Ch = Esc_Key then Done := True;
      End;
      if ButtonUp then MouseDown := False;
      if (ButtonDown)  then
      Begin
        if (GetMouseY < 15) then
        Begin
            HideMouse;
            Color := GetPixel(GetMouseX, GetMouseY, vvga);
            ShowMouse;
            Bar(1,1,7,15,color,vvga)
        End
       else
        Begin
           if (Lx <> GetMouseX) or (Ly <> GetMouseY) or (not MouseDown) then
           Begin
              HideMouse;
              x := GetMouseX;
              y := GetMouseY;
              Pressed := false;

              if InB(X,Y,Pe) then
              Begin
                InitPencel;
                Repeat Until ButtonUp;
                Pressed := True;
              End;

              if InB(X,Y,B) then
              Begin
                InitBrush;
                Repeat Until ButtonUp;
                Pressed := True;
              End;

              if InB(X,Y,S) then
              Begin
                InitSqware;
                Repeat Until ButtonUp;
                Pressed := True;
              End;

              if InB(X,Y,Sv) then
              Begin
                Repeat Until ButtonUp;
                initcircle;
                Pressed := True;
              End;

              if InB(X,Y,Ne) then
              begin
                 Repeat Until ButtonUp;
                 initline;
                 Pressed := true;
              end;

              if InB(X,Y,Fl) then
              begin
                 Repeat Until ButtonUp;
                 initFill;
                 Pressed := true;
              end;

              if InB(X,Y,Zm) then
              Begin
                 Repeat Until ButtonUp;
                 Zoom;
                 Repeat Until ButtonUp;
                 Pressed := True;
              End;

              if InB(X,Y,Lo) then
              Begin
                 Repeat until Buttonup;
                 showmouse;
                 r := gmenu(lo.x-72,lo.y-20,0,blue,15,'# New|" Load|" Save|$ Exit');
                 hidemouse;
                 case r of

                   1 : newf;
                   2 : loadas;
                   3 : saveas;
                   4 : done := true;

                 end;
                 Pressed := true;
              End;


              if Not Pressed then
              Case CurTool of

                  Pen     : PencelAct;
                  Brush   : BrushAct;
                  Sqware  : SqwareAct;
                  LLine   : DLineAct;
                  TCircle : CircleAct;
                  Fill    : FillAct;

              End;

              lx := X;
              ly := Y;
              MouseDown := True;
              ShowMouse;
           End;
        End;
      End;
   Until Done;
   FadeOut;
   SavePic('TMPF.TMP');
   SetTEXT;
End.