{ Copyright 2015 Jerome Shidel }

(* 
		
	This project and related files are subject to either the terms
	specified in the included LICENSE.TXT file or the GNU GPLv2.0.
	
*)

{$M 20480,0,0}
program Release_License_Detector_Calculator;

procedure SetLicense(License : integer);
var
	F : Text;
begin
	Assign(F, 'LICENSE.INC');
	Rewrite(F);
	WriteLn(F, '{ This file is automatically generated by make install. DO NOT EDIT IT! }');
	WriteLn(F, '');
	WriteLn(F, 'const');
	WriteLn(F, #9'SoftwareLicense : String =');
	case License of 
		1 : begin
			WriteLn('GPLv2.0 License');
			WriteLn(F, #9#9#$27 + 'This project and related files are subject to the terms of the' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'GNU General Public License, version 2.0. If a copy of the GPL' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'was not distributed with this file, You can obtain one at:' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'http://www.gnu.org/licenses/gpl-2.0.txt.' + #$27 + ';');	
		end;
		2 : begin
			WriteLn('Commercial License');
			WriteLn(F, #9#9#$27 + 'This project and related files are subject to the terms ' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'specified in the included LICENSE.TXT file. If a copy of that' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'was not distributed with this file, You can obtain one by ' + #$27 + '#13 +');
			WriteLn(F, #9#9#$27 + 'contacting the distributor of this program' + #$27 + ';');	
		end;
	else
		WriteLn('Unlicensed');
		WriteLn(F, #9#9#$27 + 'This project and related files are subject to either the terms' + #$27 + '#13 +');
		WriteLn(F, #9#9#$27 + 'specified in the included LICENSE.TXT file or the GNU GPLv2.0.'  + #$27 + '#13 +');
		WriteLn(F, #9#9#$27 + 'Neither file was present during the creation of this program,' + #$27 + '#13 +');
		WriteLn(F, #9#9#$27 + 'making it an invalid and possibly illegal copy.' + #$27 + ';');	
	end;
	Close(F);
	
	halt(0);
end;

procedure Detect(Filename: String; License : integer);
var
	F : File;
	E : integer;
begin
	{$I-}
	Assign(F, Filename);
	Reset(F);
	E := IOResult;
	if E = 0 then Close(F);
	{$I+}
	if E = 0 then SetLicense(License);
end;
	

begin
	{ Calculate EXE Size }
	Detect('..\gpl-2.0.txt', 1); { GPL License }
	Detect('..\gpl-20.txt', 1);  { GPL License }
	Detect('..\gpl20.txt', 1); 	 { GPL License }
	Detect('..\license.txt', 2); { Commercial Release }
	SetLicense(0); 			  	 { Unlicensed }
	
end.
