@ECHO OFF
REM
REM  cabextract/dos/test.in/search.bat: Unit tests for DOS.
REM

IF "%CABDIR%"==""   GOTO ERROR_CABDIR
IF "%CABEXT%"==""   GOTO ERROR_CABEXT
IF "%TEST_IN%"==""  GOTO ERROR_TEST_IN
IF "%TEST_OUT%"=="" GOTO ERROR_TEST_OUT

SET TEST_CAB=search.cab
SET RESULT=%TEST_OUT%\search.result
IF EXIST %RESULT% DEL %RESULT%

PUSHD %CABDIR%

:TEST40
SET TEST=test40-search
ECHO [33m%TEST%[0m
%CABEXT% --list %TEST_CAB% >%TEST_OUT%\%TEST%.out
SET TEST_RESULT=PASS
FC /L %TEST_IN%\%TEST%.in %TEST_OUT%\%TEST%.out
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST41
SET TEST=test41-search
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB% >%TEST_OUT%\%TEST%.out
SET TEST_RESULT=PASS
FC /L %TEST_IN%\%TEST%.in %TEST_OUT%\%TEST%.out
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

POPD
GOTO END

:ERROR_CABDIR
ECHO ERROR: %%CABDIR%% is not set.

:ERROR_CABEXT
ECHO ERROR: %%CABEXT%% is not set.
GOTO END

:ERROR_TEST_IN
ECHO ERROR: %%TEST_IN%% is not set.
GOTO END

:ERROR_TEST_OUT
ECHO ERROR: %%TEST_OUT%% is not set.
GOTO END

:END
SET TEST=
SET TEST_CAB=
SET TEST_RESULT=
SET RESULT=
