; macro BINBCHECK ARG does (all registers preserved):
; ARG [ds:si+6],bit 1 shl (al and BINBITS)
; where ARG can for example be OR or TEST

findbin:	; find bin matching location EAX DL,
	push ds	; return carry or bin in AX (and update LRU)
	  push cs
	  pop ds
	push si
%ifdef DBGbinsel
		push word fndbin1msg
		call meep
%endif
	  push ax
	and al,BINMASK		; <- ADJUST
	call hashme		; EAX.DL -> SI (main entry)
	cmp eax,[ds:si]		; sector number HI the same?
	  pop ax
	jnz short fbmiss
	cmp dl,[ds:si+4]	; drive the same?
	jnz short fbmiss

fb_inbin:		; it is the right bin, but is it filled?
	BINBCHECK test	; <- a macro... return NZ if bin is filled
	jz short fbmiss

	cmp byte [ds:si+5],0xfe	; check LRU / importance and
	jae fbmax		; increase it (with saturation at -2)
	inc byte [ds:si+5]
fbmax:	sub si,table
	shr si,3	; each table entry is 8 (EIGHT) byte, 64 bit
	shl si,BINSHR	; main entries -> sub entries (shl is correct)
	and ax,BINBITS	; bin LSB are taken from sector number
	add ax,si	; now we have the correct SUB ENTRY / BIN
	clc		; indicate success
	jmp short fbout	; return the bin found (in AX)
fbmiss:
	mov ax,-1	; (should not be used anyway)
	stc		; indicate failure
fbout:
	pop si
	pop ds
%ifdef DBGbinsel
		push word fndbinmsg	; DBG *offset*
		call meep		; DBG
%endif
	ret

; -------------

newbin:		; find a new free bin or reuse a bin
		; for location EAX DL. update LRU, return bin in AX
	push ds
	  push cs
	  pop ds
	push si
%ifdef DBGbinsel
		push word newbin1msg
		call meep
%endif
	  push ax
	and al,BINMASK		; <- ADJUST
	call hashme		; EAX.DL -> SI - dumb but fast:
				; ALWAYS throw away existing sectors
	cmp [ds:si],eax		; right sector range?
	  pop ax
	jnz nbreallynew		; else overwrite entry completely
	cmp byte [ds:si+4],dl	; right drive?
	jnz nbreallynew		; else overwrite entry completely

nbonlybitset:			; <- the bin is there but not filled
%ifdef DBGbinsel
		push word bitsetmsg
		call meep
%endif
nbsetthatbit:
	cmp byte [ds:si+5],0xfe	; so we inc the LRU / importance
	jae short nbsat		; with saturation at -2
	inc byte [ds:si+5]
nbsat:	BINBCHECK or		; <- SET the bit in the fill-list
	jmp short nbdone

nbreallynew:			; use a completely fresh entry
	mov [ds:si],eax		; store sector number in table
	and byte [ds:si],BINMASK	; <- ADJUST
	mov [ds:si+4],dl	; store drive number in table
	mov byte [ds:si+5],1	; initialize LRU / importance with 1
	mov word [ds:si+6],0	; initialize reserved word with 0
	jmp short nbsetthatbit	; do not forget to fill THIS sector
				; into the newly created bin!

nbdone:
	sub si,table
	shr si,3	; each table entry is 8 (EIGHT) byte, 64 bit !
	shl si,BINSHR	; main entries -> sub entries (shl is correct)
	and ax,BINBITS	; bin LSB are taken from sector number
	add ax,si	; now we have the correct SUB ENTRY / BIN
%ifdef DBGbinsel
		push word newbinmsg	; DBG *offset*
		call meep		; DBG
%endif
	pop si
	pop ds
	ret
