/* keydefhe - hebrew */

/*
 * history
 * 29 aug 02: created by Diego Lastrubini, modified by tom
 * 22 May 2003: use fastswitch, Anton Zinoviev <anton@lml.bas.bg>
 */


#define NAME(x) x##_HE

#include <dos.h>
#include "mkeyb.h"


/* keyboard image (contributed by Diego Iastrubni <dgi_il@hotmail.com>)

Standard layout characters+scancodes:
ͻ
~29!02@03#04$05%06^07&08*09(0A)0B-0C=0DBacksp 0E
Ķ
Tab 0Fq10w11e12r13t14y15u16i17o18p19[1A]1B      
 < 
 Caps 3Aa1Es1Fd20f21g22h23j24k25l26;27'28Enter 1C
Ķ
 Shift 2A z2Cx2Dc2Ev2Fb30n31m32,33.34/35 Shift 36 
Ķ
 Ctrl 1D Alt 38\56    Spacebar 39    \2BAlt E38Ctrl E1D
ͼ

normal:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =   Backsp 
Ķ
 Tab   /  '                  [  ]       
 < 
  Caps                       ,   Enter 
Ķ
  Shift                      .    Shift  
Ķ
 Ctrl  Alt               Spacebar          \  Alt  Ctrl 
ͼ

Shift:
ͻ
 ~  !  @  #  $  %  %  ^  &  (  )  _  +   Backsp 
Ķ
 Tab   Q  W  E  R  T  Y  U  I  O  P  [  ]       
 < 
  Caps   A  S  D  F  G  H  J  K  L  :  "   Enter 
Ķ
  Shift    Z  X  C  V  B  N  M  <  >  ?    Shift  
Ķ
 Ctrl  Alt               Spacebar          |  Alt  Ctrl 
ͼ

Caps Lock:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =   Backsp 
Ķ
 Tab   Q  W  E  R  T  Y  U  I  O  P  [  ]       
 < 
  Caps   A  S  D  F  G  H  J  K  L  ;  '   Enter 
Ķ
  Shift    Z  X  C  V  B  N  M  ,  .  /    Shift  
Ķ
 Ctrl  Alt  \           Spacebar          \  Alt  Ctrl 
ͼ

Caps Lock+Shift:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =   Backsp 
Ķ
 Tab   Q  W  E  R  T  Y  U  I  O  P  [  ]       
 < 
  Caps   A  S  D  F  G  H  J  K  L  ;  '   Enter 
Ķ
  Shift    Z  X  C  V  B  N  M  ,  .  /    Shift  
Ķ
 Ctrl  Alt  \           Spacebar          \  Alt  Ctrl 
ͼ
*/

uchar NAME(scancodetable)[] = {

//* 1 */ PUNCT(0x02, '1', '!')
 /* 2 */ PUNCT(0x03, '2', '@')
 /* 3 */ PUNCT(0x04, '3', '#')
 /* 4 */ PUNCT(0x05, '4', '$')
 /* 5 */ PUNCT(0x06, '5', '%')
 /* 6 */ PUNCT(0x07, '6', '^')
 /* 7 */ PUNCT(0x08, '7', '&')
//* 8 */ PUNCT(0x09, '8', '*')
//* 9 */ PUNCT(0x0A, '9', '(')
//* 0 */ PUNCT(0x0B, '0', ')')
//* - */ PUNCT(0x0C, '-', '_')
//* = */ PUNCT(0x0D, '=', '+')

 /* q */ ALPHA(0x10, '/', 'Q')
 /* w */ ALPHA(0x11, '\'', 'W')
 /* e */ ALPHA(0x12, '', 'E')
 /* r */ ALPHA(0x13, '', 'R')
 /* t */ ALPHA(0x14, '', 'T')
 /* y */ ALPHA(0x15, '', 'Y')
 /* u */ ALPHA(0x16, '', 'U')
 /* i */ ALPHA(0x17, '', 'I')
 /* o */ ALPHA(0x18, '', 'O')
 /* p */ ALPHA(0x19, '', 'P')

 /* a */ ALPHA(0x1E, '', 'A')
 /* s */ ALPHA(0x1F, '', 'S')
 /* d */ ALPHA(0x20, '', 'D')
 /* f */ ALPHA(0x21, '', 'F')
 /* g */ ALPHA(0x22, '', 'G')
 /* h */ ALPHA(0x23, '', 'H')
 /* j */ ALPHA(0x24, '', 'J')
 /* k */ ALPHA(0x25, '', 'K')
 /* l */ ALPHA(0x26, '', 'L')
 /* ; */ ALPHA(0x27, 147, ':')
 /* ' */ ALPHA(0x28, ',', '"')

 /* z */ ALPHA(0x2C, '', 'Z')
 /* x */ ALPHA(0x2D, '', 'X')
 /* c */ ALPHA(0x2E, '', 'C')
 /* v */ ALPHA(0x2F, '', 'V')
 /* b */ ALPHA(0x30, '', 'B')
 /* n */ ALPHA(0x31, '', 'N')
 /* m */ ALPHA(0x32, '', 'M')
 /* , */ ALPHA(0x33, '', ',')
 /* . */ ALPHA(0x34, '', '.')
 /* / */ ALPHA(0x35, '.', '?')
	 0
};


struct KeyboardDefinition NAME(Keyboard) = {
	"HE",                             //char LanguageShort[4];			// "GR",                    
	"HEBREW - hebrew keyboard, right Ctrl to switch (by diego)", 			  //char *Description;		// created by, "with combis"
	DRIVER_FUNCTION_FASTSWITCH,          //char DriverFunctionRequired;                                  
	NAME(scancodetable),              //char *ScancodeTable;                                          
#ifdef COMBI
	{	NAME(combi1table),NAME(combi2table),NAME(combi3table),
		NAME(combi4table),NAME(combi5table),NAME(combi6table) },
#else
	{ 0 },
#endif			
	0,                                //char DezimalDingsbums;
	
	1,                                //char DefaultLayoutUS; 
					  				  // TRUE for russian and hebrew
	} ;                               
                                      
                                      
                                      
