#! /bin/sh
# compile-and-install skript for the plus package on Mac OS X 10.4 or later
# execute this batch file in the .../agena/src folder by typing:
# sh makeplusmacosx.sh
# linking and stripping do not work here

export OPTIONS1="-O2 -g -DNOINLINE -fno-common -c -force_cpusubtype_ALL -mmacosx-version-min=10.4"
export OPTIONS2="-DNOINLINE -bundle -undefined dynamic_lookup -force_cpusubtype_ALL -mmacosx-version-min=10.4"

#export OPTIONS1="-O2 -g -fno-common -c -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch i386 -arch ppc -arch ppc64"
#export OPTIONS2="-bundle -undefined dynamic_lookup -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch i386 -arch ppc -arch ppc64"

export EXPORTTO="../lib"

# delete *.o files not deleted by make clean
for i in ads.o fractals.o phq.o net.o interp.o moon.o sunriset.o astro.o skycrane.o hashes.o factory.o fastmath.o dual.o utf8.o charbuf.o luasys.o com.o heaps.o rbtree.o  regex.o testlib.o double.o bloom.o cuckoo.o clock.o zx.o bimaps.o curses.o cordic.o
do
   if [ -f i ]; then
      rm i
   fi
done

printf "Compiling curses ... "
gcc $OPTIONS1 -o curses.o curses.c
gcc $OPTIONS2 -o curses.so curses.o -lncurses
mv -f curses.so $EXPORTTO
printf "done.\n"

printf "Compiling ADS ... "
gcc $OPTIONS1 -o ads.o ads.c
gcc $OPTIONS2 -o ads.so ads.o vecoff64.o
mv -f ads.so $EXPORTTO
printf "done.\n"

if [ -f ../phq/phq.c ]; then
   printf "Compiling phonetiQs ... "
   gcc $OPTIONS1 -o phq.o ../phq/phq.c
   gcc $OPTIONS2 -o phq.so phq.o
   mv -f phq.so ../phq
   printf "done.\n"
fi

printf "Compiling fractals ... "
gcc $OPTIONS1 -o fractals.o fractals.c
gcc $OPTIONS2 -o fractals.so fractals.o
mv -f fractals.so $EXPORTTO
printf "done.\n"

printf "Compiling astro ... "
gcc $OPTIONS1 -o moon.o moon.c
gcc $OPTIONS1 -o sunriset.o sunriset.c
gcc $OPTIONS1 -o astro.o astro.c
gcc $OPTIONS2 -o astro.so astro.o moon.o sunriset.o
mv -f astro.so $EXPORTTO
printf "done.\n"

printf "Compiling net ... "
gcc $OPTIONS1 -o net.o net.c
gcc $OPTIONS2 -o net.so net.o
mv -f net.so $EXPORTTO
printf "done.\n"

printf "Compiling skycrane ... "
gcc $OPTIONS1 -o skycrane.o skycrane.c
gcc $OPTIONS2 -o skycrane.so skycrane.o
mv -f skycrane.so $EXPORTTO
printf "done.\n"

printf "Compiling hashes ... "
gcc $OPTIONS1 -o hashes.o hashes.c
gcc $OPTIONS2 -o hashes.so hashes.o
mv -f hashes.so $EXPORTTO
printf "done.\n"

printf "Compiling zx ... "
gcc $OPTIONS1 -o zx.o zx.c
gcc $OPTIONS2 -o zx.so zx.o
mv -f zx.so $EXPORTTO
printf "done.\n"

printf "Compiling bloom ... "
gcc $OPTIONS1 -o bloom.o bloom.c
gcc $OPTIONS2 -o bloom.so bloom.o
mv -f bloom.so $EXPORTTO
printf "done.\n"

printf "Compiling cuckoo ... "
gcc $OPTIONS1 -o cuckoo.o cuckoo.c
gcc $OPTIONS2 -o cuckoo.so cuckoo.o
mv -f cuckoo.so $EXPORTTO
printf "done.\n"

printf "Compiling clock ... "
gcc $OPTIONS1 -o clock.o clock.c
gcc $OPTIONS2 -o clock.so clock.o
mv -f clock.so $EXPORTTO
printf "done.\n"

printf "Compiling fastmath ... "
gcc $OPTIONS1 -Wno-strict-aliasing -o fastmath.o fastmath.c
gcc $OPTIONS2 -Wno-strict-aliasing -o fastmath.so fastmath.o
mv -f fastmath.so $EXPORTTO
printf "done.\n"

printf "Compiling dual ... "
gcc $OPTIONS1 -o dual.o dual.c
gcc $OPTIONS2 -o dual.so dual.o
mv -f dual.so $EXPORTTO
printf "done.\n"

printf "Compiling cordic ... "
gcc $OPTIONS1 -o cordic.o cordic.c
gcc $OPTIONS2 -o cordic.so cordic.o
mv -f cordic.so $EXPORTTO
printf "done.\n"

printf "Compiling com ... "
gcc $OPTIONS1 -DPLUS -o charbuf.o charbuf.c
gcc $OPTIONS1 -o luasys.o luasys.c
gcc $OPTIONS1 -o com.o com.c
gcc $OPTIONS2 -o com.so com.o luasys.o charbuf.o
mv -f com.so $EXPORTTO
printf "done.\n"

printf "Compiling regex ... "
gcc $OPTIONS1 -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regex_f.o regex_f.c
gcc $OPTIONS1 -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regexcom.o regexcom.c
gcc $OPTIONS1 -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regex.o regex.c
gcc $OPTIONS2 -o regex.so regex.o regex_f.o regexcom.o -lpcre2-posix -lpcre2-8
mv -f regex.so $EXPORTTO
printf "done.\n"

printf "Compiling heaps ... "
gcc $OPTIONS1 -o heaps.o heaps.c
gcc $OPTIONS2 -o heaps.so heaps.o
mv -f heaps.so $EXPORTTO
printf "done.\n"

printf "Compiling rbtree ... "
gcc $OPTIONS1 -o rbtree.o rbtree.c
gcc $OPTIONS2 -o rbtree.so rbtree.o
mv -f rbtree.so $EXPORTTO
printf "done.\n"

printf "Compiling bimaps ... "
gcc $OPTIONS1 -o bimaps.o bimaps.c
gcc $OPTIONS2 -o bimaps.so bimaps.o
mv -f bimaps.so $EXPORTTO
printf "done.\n"

printf "Compiling testlib ... "
gcc $OPTIONS1 -o testlib.o testlib.c
gcc $OPTIONS2 -o testlib.so testlib.o
mv -f testlib.so $EXPORTTO
printf "done.\n"

printf "Compiling double ... "
gcc $OPTIONS1 -o double.o double.c
gcc $OPTIONS2 -o double.so double.o
mv -f double.so $EXPORTTO
printf "done.\n"

# can't get GMP 6.2.1 compiled with Apple's GCC 4.2.1
#printf "Compiling mp ... "
#gcc $OPTIONS1 -o mp.o mp.c -lgmp
#gcc $OPTIONS2 -o mp.so mp.o
#mv -f utf8.so $EXPORTTO
#printf "done.\n"

echo Installing all libraries into /lib folder ...
echo All done.

