/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ASSERT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void _assert(char *condition, char *filename, long linenr)

	Display an assertation message:
		Assertation failed "<condition>" in file <filename> line <linenr>
	then terminate the program with the default error exit code.

	Usually invoked by the macro:
		assert(condition);
	This macro inserts the _assert() call, if the macro NDEBUG (no
	debugging) is _not_ defined.

	Input:
		condition != NULL
		filename != NULL

	Return:
		will never return

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		abort, exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/01/29 07:10:14  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_errstr.h>
#include <assert.h>
#include <limits.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ASSERT.C 1.3 1998/01/29 07:10:14 ska Exp $";
#endif

void _CLibFunc
_assert(char const * const condition
       ,char const * const filename
       ,long linenr)
{	
#ifndef NDEBUG 			/* Debugging active? -> a recursion may occur! */
	static boolean recurs = false;

	/* prevent any recursive assert fails from the following code
		of the _assert() function itself and the CLib function used by
		it */
	if(recurs) return;		/* prevent any recursive assert fails from
								printf() */

	recurs = true;
#endif		/* NDEBUG */

	assert(condition != NULL);
	assert(filename != NULL);

	/* Perhaps we should not use printf() here, but use fputs()
		to emit the strings and itoa() to convert the linenummer.
		Just to make sure, the huge bulk of functions accompanying
		printf() is not included by using _assert() only?
			- 1997/10/10 ska*/
#if 1
	fprintf(stderr, ERR_assert, condition, filename, linenr);
#else
	fputs("Assertation failed \"", stderr);
	fputs(condition, stderr);
	fputs("\" in file ", stderr);
	fputs(filename, stderr);
	fputs(" line ", stderr);
	{	char buf[sizeof(long) * 8 + 3];

		ultoa(linenr, buf, 10);
		fputs(buf, stderr);
		putc('\n', stderr);
	}
#endif

	_abort(NULL);			/* standard failure termination */
}
