/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CLOSEDIR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void closedir(DIR *dirp)

	Close the directory scan and free any allocated resources.

	Input:
		dirp != NULL, must be returned by opendir()

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		POSIX

	See also:
		opendir

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <alloc.h>
#include <dirent.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CLOSEDIR.C 1.1 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc void
closedir(DIR *dirp)
{	assert(dirp != NULL);

	findstop(&dirp->dd_dta);
	free(dirp);
}
