/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: GETCURDI.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int getcurdir(int drive, char *dir)

	Retrieve current working directory of specified drive.
	Omited are: drive, leading & trailing backslash

	Input:
		dir != NULL, must large enough to receive directory
		drive:	0 == current working disk
				1 == A:
				2 == B:
				 ...

	Return:
		0 on success
		else on failure

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		getcwd, getdisk, chdir

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dir.h>
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GETCURDI.C 1.2 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
getcurdir(int drive 
	,char * const dir)
{	struct REGPACK rp;

	rp.r_si = FP_OFF(dir);
	rp.r_ds = FP_SEG(dir);
	rp.r_dx = drive;
	rp.r_ax = 0x4700;

	return _callDOS(&rp);
}
