/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _DELAY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _delay(uint32 microseconds)

	Delay process execution for microseconds. The accuracy depends on the
	computer's timer interrupt and background tasks, that might interfere
	with that timer.

	If microseconds == 0, the functions returns immediately. This might be
	changed in the future.

	Input:
		<none>

	Return:
		== 0: if wait process finished || microseconds == 0
		!= 0: if wait process interrupted or not started at all

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		delay

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 08:29:37  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _DELAY.C 1.1 1997/10/13 08:29:37 ska Exp $";
#endif

_CLibFunc int
_delay(uint32 microseconds)
{	
	struct REGPACK r;

	if(!microseconds) return 0;

	r.r_cx = HIWORD(microseconds);
	r.r_dx = LOWORD(microseconds);
	r.r_ax = 0x8600;
	intr(0x15, &r);

	return r.r_flags & FLAG_CARRY;
}
