/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: GETDISK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int getdisk(void)

	Return the current drive.

	Input:
		<none>

	Return:
		0 == A:, 1 == B:

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		setdisk

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:05:48  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GETDISK.C 1.1 1997/10/13 07:05:48 ska Exp $";
#endif

_CLibFunc int
getdisk(void)
{	struct REGPACK r;

	r.r_ax = 0x1900;
	_callDOS(&r);
	return LOBYTE(r.r_ax);
}
