/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: GETS.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *gets(char *buf, FILE *fp)

	Read a string from a stream.

	The '\n' is removed.

	BEWARE: Because there is no check if the buffer overflows the
	program might crash, if a long line is fed into gets().
	Any useage of gets() is strongly discouraged! Use fgets() instead!

	Input:
		buf != NULL
		fp != NULL; a valid FILE pointer

	Return:
		NULL: EOF or error
		buf: otherwise

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		fgets

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GETS.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc char *
gets(char *str)
{
   /* Auwlright it will work but of course _your_ program will crash */
   /* if it's given a too long line */
   REG char *p = str;
   REG int c;

   assert(str != NULL);

   while (((c = getc(stdin)) != EOF) && (c != '\n'))
      *p++ = c;
   *p = '\0';
   return (((c == EOF) && (p == str)) ? NULL : str);	/* NULL == EOF */
}
