/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _HPSEARC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void *_heapsearch(size_t size)

	Search for an unused block of size bytes.

	Input:
		<none>

	Return:
		pointer to a node, if node is unused, this can be used;
		if node is end of heap, a security check must be performed
		by caller
		if the node's type is something else, the heap has been corrupted.

	Note:
		Local heap only

	Conforms to:
		<none>

	See also:
		free, realloc, calloc, malloc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.4  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>
#include <_errstr.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _HPSEARC.C 1.4 1998/02/11 07:40:34 ska Exp ska $";
#endif

_CLibFunc _pHeapNode
_heapsearch(const size_t size)
{	REG _pHeapNode p, q;	/* pointer to this / previous node */

	assert(_heap != NULL);		/* security check if heap is initialized */

	p = _heap;			/* begin of the local heap */

#if _IN_ALLOC == 0			/* local heap */
#define ADVANCE_AND_TEST	(p = nxtNode(p)) > q
#else
#ifdef DEBUG_HEAP
#define ADVANCE_AND_TEST	_frgident(p = nxtNode(p))
#else
#define ADVANCE_AND_TEST	(p = nxtNode(p)) != NULL
#endif
#endif 

	/* check for unused space */
	do if(p->type == HEAP_UNUSED && nodeLength(p) >= size)
		return p;
	while((q = p)->type != HEAP_END && ADVANCE_AND_TEST);

	return q;	/* to return the previous node will make sure the
					error condition is returned */
}
