/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: ALLOC.H 1.5 1998/02/11 07:40:39 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	Allocation functions for local & far heap

*/

#ifndef __ALLOC_H
#define __ALLOC_H

#include <stddef.h>

/* far heap functions with huge interface */
extern _CLibFunc void huge *_hcalloc(const hsize_t num       ,const hsize_t size);
extern _CLibFunc int _hfree(void huge * const poi);
extern _CLibFunc void huge *_hmalloc(const hsize_t size);
extern _CLibFunc void huge *_hrealloc(void huge *poi        ,hsize_t size);

/* far heap functions */
extern _CLibFunc void far*_fcalloc(const size_t num       ,const size_t size);
extern _CLibFunc int _ffree(void far* const poi);
extern _CLibFunc void far*_fmalloc(const size_t size);
extern _CLibFunc void far*_frealloc(void far*poi        ,size_t size);

/* Local heap functions */
extern _CLibFunc void  *_lcalloc(const size_t num       ,const size_t size);
extern _CLibFunc int _lfree(void * const poi);
extern _CLibFunc void  *_lmalloc(const size_t size);
extern _CLibFunc void  *_lrealloc(void *poi        ,size_t size);

/* Out of dynamic memory handler */
/* for the local heap */
typedef void *_lnomem_handler_t(size_t);
extern _CLibVar _lnomem_handler_t *_lnomem_handler;

/* for the far heap */
/* Note: This handler has an huge interface! */
typedef void huge *_fnomem_handler_t(hsize_t);
extern _CLibVar _fnomem_handler_t *_fnomem_handler;


#ifndef _IN_ALLOC				/* detect what mapping is to be made */
#ifdef _NEARDATA
#define _IN_ALLOC 0
#else 		/* _NEARDATA */
#ifdef _HUGEDATA
#define _IN_ALLOC 2
#else		/* _HUGEDATA */
#define _IN_ALLOC 1
#endif		/* _HUGEDATA */
#endif		/* _NEARDATA */
#endif 		/* _IN_ALLOC */


#if _IN_ALLOC == 0
#define calloc _lcalloc
#define free _lfree
#define malloc _lmalloc
#define realloc _lrealloc
#define _nomem_handler_t _lnomem_handler_t
#define _nomem_handler _lnomem_handler
#endif

#if _IN_ALLOC == 1
#define calloc _fcalloc
#define free _ffree
#define malloc _fmalloc
#define realloc _frealloc
#define _nomem_handler_t _fnomem_handler_t
#define _nomem_handler _fnomem_handler
#endif

#if _IN_ALLOC == 2
#define calloc _hcalloc
#define free _ffree
#define malloc _hmalloc
#define realloc _hrealloc
#define _nomem_handler_t _fnomem_handler_t
#define _nomem_handler _fnomem_handler
#endif

#endif
