/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: STDLIB.H 1.2 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	General utilites.

	According ISO9899.

*/

#ifndef __STDLIB_H
#define __STDLIB_H


#include <stddef.h>
#include <process.h>


/*************** exit codes ************************************/
#define EXIT_SUCCESS 0		/* program terminates successfully */
#define EXIT_FAILURE 1		/* program terminates unsuccessfully */

/*************** string <-> value conversation *****************/

/*
 *	__tostrbuf[] is the result buffer for all "_*tostr()" 
 *	functions. That means that it is overwritten each time such
 *	function is invoked.
 */
extern char_t __tostrbuf[];

/*
 *	utoa() convert a (unsigned int) value into a character string.
 *
 *	It is save to use _ultoa() because of the double cast. It will ensure
 *	that a signed value does not keep its sign, thus, generating a
 *	(long) value.
 *
 *	The question is if to implement a utoa() for reason of
 *	speed - 1997/11/12 ska*/
#define utoa(value,buf,radix)	\
	_ultoa((unsigned long)(unsigned)(value), (buf), (radix))

/*
 *	_*tostr() functions are equal to the [_]*toa() functions,
 *	except that they use the internal buffer __tostrbuf[].
 */
#define _ltostr(value,radix)	\
	_ltoa((value), __tostrbuf, (radix))
#define _ultostr(value,radix)	\
	_ultoa((value), __tostrbuf, (radix))
#define _itostr(value,radix)	\
	itoa((value), __tostrbuf, (radix))
#define _utostr(value,radix)	\
	utoa((value), __tostrbuf, (radix))

extern char_t *itoa(int value, char_t * str, int radix);
extern char_t *_ltoa(long value, char_t * str, int radix);
extern char_t *_ultoa(unsigned long value, char_t * str, int radix);

#endif
