/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRING.H $
   $Locker:  $	$Name:  $	$State: Exp $

	String & memory functions

	According ISO9899

*/

#ifndef __STRING_H
#define __STRING_H

#include <stddef.h>

/*
 * typedefinitions for PString
 */

/* The currently supported PStrings look like this:
			<length><char1>...<charN>
	all of type byte, N == <length>
*/
typedef byte pstrlen_t;			/* the type of <length> itself*/
typedef unsigned pstr_t;		/* type to save a PString's <length> in */


/*
 * Compatibility macros
 */

/* The case-insensitive compare functions tend to vary either with
	inbound 'i' or appended 'i'. We treat the 'i' inbound, but provide
	macros for the appended 'i' version.
*/
#define strcmpi stricmp
#define memcmpi memicmp
#define strncmpi strnicmp
#define _fstrcmpi _fstricmp
#define _fmemcmpi _fmemicmp
#define _fstrncmpi _fstrnicmp
#define _hstrcmpi _hstricmp
#define _hmemcmpi _hmemicmp
#define _hstrncmpi _hstrnicmp

/*
 *	Prototypes of the CLib string/memory functions
 */

#include "..\memory\string.inc"		/**EXPAND**/

#endif
