/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: LOCKING.H 1.2 1997/10/27 12:27:33 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Declaration for locking

*/

#ifndef __LOCKING_H
#define __LOCKING_H

/*
 *	Commands for locking()
 */
#define LK_NOBLOCK	0x10		/* don't block process on failure */
#define LK_LOCK		0x01		/* lock a region */
#define LK_RLCK		LK_LOCK
#define LK_NBLCK	(LK_LOCK | LK_NOBLOCK)
#define LK_NBRLCK	(LK_RLCK | LK_NOBLOCK)
#define LK_UNLCK	(0x02 | LK_NOBLOCK)
#define LK_UNLOCK	LK_UNLCK

extern int _lockRetryCount;		/* how many attempts are made */
extern int _lockDelay;			/* how many seconds to wait */

#endif
