/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: DUP2.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int dup2(int oldfd, int newfd)

	Force duplicate old file descriptor to new file descriptor.
	If "newfd" is an already assigned file descriptor, the
	associated file is closed.

	If oldfd == newfd, no operation is performed.

	Input:
		<none>

	Return:
		0: on success
		else: on failure

	Note:
		<none>

	Conforms to:
		Posix

	See also:

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:06:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#include <io.h>


#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DUP2.C 1.1 1997/10/13 07:06:59 ska Exp $";
#endif

_CLibFunc int
dup2(const int oldfd
    ,const int newfd)
{	struct REGPACK r;

	r.r_ax = 0x4600;
	r.r_bx = oldfd;
	r.r_cx = newfd;

	return oldfd == newfd? 0: _callDOS(&r);
}
