/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: READ.C $
   $Locker:  $	$Name:  $	$State: Exp $

	size_t read(int fd, void *buf, size_t length)

	Read length bytes from the file from its current fileppointer
	into the buffer. The filepointer is updated and points behind
	the read data.

	Input:
		buf != NULL, sizeof(buf) >= length
		length < UINT_MAX, may be 0

	Return:
		(size_t)-1: on failure
		else: number of read bytes

	Note:
		The return value of "0" (zero) means that there was no pending
		data in the file, but one cannot decide whether or not the
		EOF condition has been reached for sure.
		Consider fd is associated with the console, but no enter key has
		been pressed. If the keyboard driver has been set to timeout
		requests without reporting an error, read() must and will return
		0. But this does not mean that the console has been closed,
		thus, that the no key press may come in future.
		
	Conforms to:
		Posix

	See also:
		open, write

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/11/18 04:24:50  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: READ.C 1.2 1997/11/18 04:24:50 ska Exp $";
#endif

_CLibFunc size_t
read(const int fd
    ,void * const buf
    ,const size_t length)
{	assert(buf != NULL);
	assert(length != _IO_err);

	return _rw(_READ_HANDLE, fd, buf, length);
}
