/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: SETMODE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int setmode(int mode)

	Change the mode (binary or text) of the file descriptor.
	mode either O_BINARY or O_TEXT.
	If mode == -1, the current mode is requested only.

	Input:
		mode == O_BINARY || mode == O_TEXT || mode == -1

	Return:
		O_BINARY: fd was in binary mode before
		O_TEXT: fd was in text mode before
		-1: on error

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		isatty

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:50  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <fcntl.h>
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: SETMODE.C 1.1 1997/11/18 04:24:50 ska Exp $";
#endif

_CLibFunc int
setmode(int fd, int mode)
{	
	int omode;

	assert(mode == (int)O_BINARY || mode == (int)O_TEXT || mode == -1);

	if((omode = ioctl(fd, 0)) == -1
	 || (mode != -1 && ioctl(fd, 1
						, mode == (int)O_TEXT
							? (omode & ~(1 << 5)) & 0xff
							: (omode | (1 << 5)) & 0xff) == -1))
		return -1;

	return (omode & (1 << 5))? O_BINARY: O_TEXT;
}
