/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ATEXIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int atexit(atexit_t fct)

	Register another function to be executed before terminating the
	process. This is the first task of exit(), prior closing files,
	free'ing memory etc.

	Input:
		fct != NULL

	Return:
		0 if registration succeeded
		else if failed; the CLib is required to store _at least_ 32
			functions

	Note:
		The functions are invoked in LIFO (Last In First Out) manner

	Conforms to:
		ANSI

	See also:
		exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/11/18 04:24:53  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ATEXIT.C 1.2 1997/11/18 04:24:53 ska Exp $";
#endif

_CLibFunc int atexit(atexit_t fct)
{	assert(fct != (atexit_t)NULL);

	/* idx will never be greater than MAX_ATEXIT + STD_ATEXIT */
	if(__atexitIdx == MAX_ATEXIT + STD_ATEXIT)
		return 1;			/* no more room to register the function */

	__atexitFcts[__atexitIdx++] = fct;
	return 0;
}
