/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _EXIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void _exit(int exitcode)

	Terminate process. Only absolutely necessary steps are performed before
	terminating, e.g. no IO buffers are flushed, no memory free'ed. This
	routine assumes that the user or the OS take care of these steps.

	Input:
		0 <= exitcode <= 255

	Return:
		will never return

	Note:
		The really exit code returned to the parent process is
		(unsigned)(exitcode & 0xFF)

	Conforms to:
		Posix

	See also:
		exit, _c_exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 12:27:29  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#include <process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _EXIT.C 1.2 1997/10/27 12:27:29 ska Exp $";
#endif

_CLibFunc void _exit(const int exitcode)
{	struct REGPACK r;

	_c_exit();		/* Perform light-weight cleanup */

	/* Prepare "real" terminate of process by the DOS API */
	r.r_ax = 0x4c00 | (exitcode & 0xff);
	_callDOS(&r);
}
