; Copyright (C) 2021 Jerome Shidel
; BSD 3-Clause License

; NASM 2.14rc0 for DOS

use16

cpu 8086

%include "TPASCAL.INC"

section PASCAL_DATA

section PASCAL_SHARED

    extern DrvError       ; dw 0

section PASCAL_CODE

struc TDriveParams
    .COUNT      resw 1
    .KIND       resw 1
    .HEADS      resw 1
    .SECTORS    resw 1
    .CYLINDERS  resw 1
    .PARAMS     resd 1
endstruc

; procedure SetDrvError (ERROR : word);
pascal_proc SetDrvError, word
	mov		ax, PARAM_1
    mov     [DrvError], ax
pascal_end

; function GetDrvError : word;
pascal_func GetDrvError, word
    mov     RESULT, [DrvError]
pascal_end

; function AsciizStr(const addr) : string;
pascal_func AsciizStr, pointer, string
    push    ds
	lds		si, PARAM_1
	les     di, RESULT
	xor     cx, cx
	push    di
	inc     di
	cld
.CopyLoop:
    cmp     cx, 255
    je      .CopyDone
    lodsb
    cmp     al, 0
    je      .CopyDone
    inc     cx
    stosb
    jmp     .CopyLoop
.CopyDone:
	pop     di
	mov     al, cl
	stosb
    pop     ds
pascal_end

; function GetEquipmentList : word;
pascal_func GetEquipmentList, word
    xor     ax, ax
    mov     [DrvError], ax
    int     0x11
    ;       mov     RESULT, ax  ; not needed
pascal_end

; function GetDriveParams(Drive : word; var Params : TDriveParams ) : boolean;
pascal_func GetDriveParams, word, record, boolean
    mov     ah, 0x08
    mov     dx, PARAM_1
    xor     di, di              ; Clear ES:DI
    mov     [DrvError], di
    push    di
    pop     es
    int     0x13
    sti
    jnc     .NoError
    mov     [DrvError], ah
    mov     al, FALSE
    jmp     .Done
.NoError:
    push    ds
    lds     si, PARAM_2
    xor     ah, ah
    mov     al, dl
    mov     [si + TDriveParams.COUNT], ax
    mov     al, bl
    mov     [si + TDriveParams.KIND], ax
    mov     al, dh
    mov     [si + TDriveParams.HEADS], ax
    mov     al, cl
    and     al, 00111111b
    mov     [si + TDriveParams.SECTORS], ax
    mov     al, cl
    mov     cl, 2
    shl     ax, cl
    mov     al, ch
    mov     [si + TDriveParams.CYLINDERS], ax
    mov     [si + TDriveParams.PARAMS], di
    mov     [si + TDriveParams.PARAMS + 2], es
    pop     ds
    mov     al, TRUE
.Done:
pascal_end

; function DriveRemovable (Drive :word) : boolean;
pascal_func DriveRemovable, word, boolean
    xor     ax, ax
    mov     [DrvError], ax
    mov     ax, 0x4408
    mov     bx, PARAM_1
    int     0x21
    jc      .Error
    cmp     ax, 0
    jne     .NotRemovable
.Removable:
    mov     al, True
    jmp     .Done
.Error:
    mov     [DrvError], ax
.NotRemovable:
    mov     al, FALSE
.Done:
pascal_end

; function DriveRemote (Drive :word) : word;
pascal_func DriveRemote, word, word
    xor     ax, ax
    mov     [DrvError], ax
    mov     ax, 0x4409
    mov     bx, PARAM_1
    int     0x21
    jc      .Error
    mov     ax, dx
    jmp     .Done
.Error:
    mov     [DrvError], ax
    xor     ax, ax
.Done:
pascal_end

; function CDDrive(var Drive : Word) : boolean;
pascal_func CDDrive, word, boolean
    xor     ax, ax
    mov     [DrvError], ax
    mov     ax, 0x1500
    xor     bx, bx
    int     0x2F
    ; jc      .Error
    cmp     bx, 0
    je      .NotCD
    mov     ax, PARAM_1
    dec     ax
    add     bx, cx
    cmp     ax, cx
    jb      .NotCD
    cmp     ax, bx
    jae     .NotCD
    mov     al, TRUE
    jmp     .Done
.Error:
    mov     [DrvError], ax
 .NotCD:
    mov     al, FALSE
.Done:
pascal_end
