; Copyright (C) 2021 Jerome Shidel
; BSD 3-Clause License

; NASM 2.14rc0 for DOS

%ifdef TP55
    %warning Forcing Turbo Pascal version 5.5 compatibility.
    %include "TP55.INC"
%else
    %include "TP70.INC"
%endif

; Turbo Pacal units will use FAR CALLS
;    %idefine CALL_MODEL    CALL
;    %idefine CALL_RETURN   RET
;    %idefine STACKBP       BP + 4

%idefine CALL_MODEL     CALL FAR
%idefine CALL_RETURN    RETF
%idefine STACKBP        BP + 6

%idefine FALSE  00h
%idefine TRUE   01h

%imacro pascal_setparameter 3
        %define PARAM_%2 [STACKBP + %3]
%endmacro

%imacro pascal_unsetparameter 1
        %undef PARAM_%1
%endmacro

%imacro pascal_end 0
    pop bp
    %if pascal_return_pop = 0
        CALL_RETURN
    %else
        CALL_RETURN pascal_return_pop
    %endif
    %assign punidx 0
    ; %warning end pascal_export_name pascal_param_count, pascal_return_pop
    %rep pascal_param_count
        %assign punidx punidx+1
        pascal_unsetparameter punidx
    %endrep
    %undef pascal_export_name
    %undef pascal_result_type
    %undef pascal_return_pop
    %undef pascal_param_count
    %undef pascal_param_sbp
    %undef RESULT
%endmacro

%imacro pascal_incparameter 1
    %ifidni %1, boolean
        %assign pascal_param_sbp pascal_param_sbp+2
    %elifidni %1, byte
        %assign pascal_param_sbp pascal_param_sbp+2
    %elifidni %1, char
        %assign pascal_param_sbp pascal_param_sbp+2
    %elifidni %1, word
        %assign pascal_param_sbp pascal_param_sbp+2
    %elifidni %1, integer
        %assign pascal_param_sbp pascal_param_sbp+2
    %elifidni %1, dword
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, long
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, longint
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, pointer
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, record
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, string
        %assign pascal_param_sbp pascal_param_sbp+4
    %elifidni %1, real
        %assign pascal_param_sbp pascal_param_sbp+8
    %else
        %error unknown parameter type %1
    %endif
%endmacro

%imacro pascal_proc 1-*
    %define pascal_export_name %1
    %undef RESULT
    global %1
    %1:
        %assign pascal_return_pop 0
        %assign pascal_param_sbp 0
        %assign pascal_param_count %0
        %rep %0 - 1
            %rotate -1
            %assign pascal_param_count pascal_param_count-1
            pascal_setparameter %1, pascal_param_count, pascal_param_sbp
            ; %undef pascal_return_type
            pascal_incparameter %1
            %assign pascal_return_pop pascal_param_sbp
        %endrep

        ; %warning proc %1 pascal_param_count, pascal_return_pop
        ; %stacksize large  ; not using %arg
        push bp
        mov  bp, sp
        ; %ifdef FARCALLS   ; This would be needed if %arg worked
        ;    add bp, 2      ; inside macros, but it does not so
        ; %endif            ; we don't need it.
%endmacro

%imacro pascal_func 2-*
    %define pascal_export_name %1
    %undef RESULT
    global %1
    %1:
        %assign pascal_return_pop 0
        %assign pascal_param_sbp 0
        %assign pascal_param_count %0 - 1

        %rotate -1
        %define pascal_result_type %1

        %rep %0 - 2
            %rotate -1
            %assign pascal_param_count pascal_param_count-1
            pascal_setparameter %1, pascal_param_count, pascal_param_sbp
            pascal_incparameter %1
            %assign pascal_return_pop pascal_param_sbp
        %endrep

        %ifidni pascal_result_type, boolean
            %define RESULT al
        %elifidni pascal_result_type, byte
            %define RESULT al
        %elifidni pascal_result_type, char
            %define RESULT al
        %elifidni pascal_result_type, word
            %define RESULT ax
        %elifidni pascal_result_type, integer
            %define RESULT ax
        %elifidni pascal_result_type, dword
            %define RESULT dx:ax    ; will cause compile error :-)
        %elifidni pascal_result_type, long
            %define RESULT dx:ax    ; will cause compile error :-)
        %elifidni pascal_result_type, longint
            %define RESULT dx:ax    ; will cause compile error :-)
        %elifidni pascal_result_type, pointer
            %define RESULT dx:ax    ; will cause compile error :-)
        %elifidni pascal_result_type, record
            %define RESULT forbidden ; will cause compile error :-)
        %elifidni pascal_result_type, string
            %define RESULT [STACKBP + pascal_param_sbp]
        %elifidni pascal_result_type, real
            %define RESULT something ; will cause compile error :-)
        %else
            %error unknown parameter type pascal_result_type
        %endif

        ; %warning func %1 pascal_param_count, pascal_return_pop
        ; %stacksize large  ; not using %arg
        push bp
        mov  bp, sp
        ; %ifdef FARCALLS   ; This would be needed if %arg worked
        ;    add bp, 2      ; inside macros, but it does not so
        ; %endif            ; we don't need it.
%endmacro

