unit grpfile;
interface
uses objects;

const
     grpOK        = 0;                      {vse v poradku}

     grpCreate    = $3c00;                  {vytvori novy soubor}
     grpOpenRead  = $3d00;                  {jen pro cteni}
     grpOpenWrite = $3d01;                  {jen pro zapis}
     grpOpen      = $3d02;                  {cteni i zapis}

     {$IFNDEF FPC}
     stOpenError = -8;
     {$ENDIF}

     MAX_GRP_CISLOVANYCH_SOUBORU = 99;
     GRP_DEF_VEL_POLE_PRO_READSTRING = 256;

type
     PGrpStream = ^TGrpStream;
     TGrpStream = object (TDOSStream)
     is_grp:boolean;
     numfiles:longint;
     StartPos:longint;
     LocalSize:longint;
     pole_pro_readstring:pchar;
     prednacteno,jiz_zpracovano:longint;
     zkoumej_z10:boolean;
     grp_vel_pole_pro_readstring:longint;
     Constructor Init (FileName: FNameStr; Mode:word);
     Procedure NactiVnitrek(name:string;poz:longint);
     Destructor Done;virtual;
     Procedure Seek (Poz: LongInt);Virtual;
     {$IFDEF FPC}
     Procedure Read (Var Buf; Count: longint);Virtual;
     {$ELSE}
     Procedure Read (Var Buf; Count: word);Virtual;
     {$ENDIF}
     Function GetSize:longint;virtual;
     Function GetPos:longint;virtual;
     Function ReadStream(var Buf; Count:longint):longint;
     Procedure ReadString_Internal(buf:pchar;var skut_delka:longint;limit_delky:longint);
     Function ReadString:string;
     Function Jsem_v_GRP:boolean;
     Function Jsem_ja_GRP:boolean;
     Function Kolik_ja_mam_v_GRP:longint;
     end;

Function GRPExistFile(s:string):boolean;


implementation
uses Dos;

const MAGIC = 'KenSilverman';
      VELIKOSTZAHLAVI = 12+4;

Function Convert_Up(s:string):string;
var a:byte;
begin
for a:=1 to Length(s) do s[a]:=UpCase(s[a]);
Convert_Up:=s;
end;

function SkipEndSpaces(s:string):string;
var i:byte;
begin
i:=Length(S);
while (S[i] in [' ',#0]) and (i>0) do Dec (i);
s[0]:=char(i);
SkipEndSpaces:=s;
end;  { SkipEndSpaces }


Constructor TGrpStream.Init(FileName: FNameStr; Mode: Word);
var a:byte;
    s:string;
begin
is_grp:=false;
pole_pro_readstring:=nil;
prednacteno:=0;
jiz_zpracovano:=0;
zkoumej_z10:=false;
grp_vel_pole_pro_readstring:=GRP_DEF_VEL_POLE_PRO_READSTRING;
FileName:=FExpand(Convert_UP(FileName));

a:=Pos('#',Filename);                     {budeme to otevirat jako normalni}
if a=0 then
   begin
   inherited Init(FileName,mode); {soubor nebo jako soubor v archivu?}
   StartPos:=inherited GetPos;
   LocalSize:=inherited GetSize;
   end
   else begin
   s:=Copy(FileName,1,a-1);
   inherited Init(s,mode);
   if status<>stOK then Exit;           {nepodarilo se otevrit .GRP archiv}

   filename:=Copy(filename,a+1,255);
   NactiVnitrek(filename,0);
   end;
end;


Procedure TGrpStream.NactiVnitrek(name:string;poz:longint);
{Rekurzivni procedura, ktera se prokouse zapisem jako:
'ARCHIV.GRP#BITMPFNT.MFN#size12.fn'}
var n:string[12];
    a,b:byte;
    ourname,nextname:string;

begin
inherited Read(n[1],12);
n[0]:=#12;
if MAGIC<>n then begin
   status:=stOpenError; {nejde o Duke3D .GRP format}
   Exit;
   end;

{overili jsme "magic" archivu}
is_grp:=true;
a:=Pos('#',name);
if a=0 then
   begin
   ourname:=name;
   nextname:='';
   end
   else begin
   ourname:=Copy(name,1,a-1);
   nextname:=Copy(name,a+1,255);
   end;
inherited Read(numfiles,4);
for b:=1 to numfiles do
    begin
    n[0]:=#12;
    inherited Read(n[1],12);
    n:=Convert_Up(SkipEndSpaces(n));
    inherited Read(localsize,4);
    if n=ourname then
       begin
       startpos:=VELIKOSTZAHLAVI+numfiles*16+poz;
       inherited Seek(startpos);
       if a=0 then status:=stOK
              else NactiVnitrek(nextname,startpos);
       Exit;
       end;
    inc(poz,localsize);
    end;
status:=stOpenError;             {soubor tohoto jmena v archivu neni}
end;


Destructor TGrpStream.Done;
begin
{Close;}
inherited Done;
if pole_pro_readstring<>nil then
   begin
   FreeMem(pole_pro_readstring,GRP_VEL_POLE_PRO_READSTRING);
   pole_pro_readstring:=nil;
   end;
end;


Procedure TGrpStream.Seek(poz:longint);
begin
if Poz<0 then Poz:=0;
if Poz>LocalSize then Poz:=LocalSize;
inc(poz,StartPos);
inherited Seek(poz);
prednacteno:=0;
jiz_zpracovano:=0;
zkoumej_z10:=false;
end;


{$IFDEF FPC}
Procedure TGrpStream.Read (Var Buf; Count: longint);
{$ELSE}
Procedure TGrpStream.Read (Var Buf; Count: word);
{$ENDIF}
var local:longint;
begin
if is_grp=false then inherited Read(buf,count)
   else begin
   local:=inherited GetPos - StartPos;

   if local+count>LocalSize
      then status:=stReadError
      else inherited Read(buf,count);
   end;
end;


Function TGrpStream.GetSize:longint;
begin
GetSize:=LocalSize;
end;


Function TGrpStream.GetPos:longint;
var i:longint;
begin
if is_grp=false then GetPos:=inherited GetPos
   else begin
   i:=inherited GetPos;
   GetPos:=i-StartPos;
   end;
end;


Function TGrpStream.ReadStream(var Buf; Count:longint):longint;
var l,v:longint;

begin
l:=GetPos;
v:=GetSize;
if l+count>v then l:=v-l else l:=count;
Read(buf,l);
ReadStream:=l;
end;


Function TGrpStream.ReadString:string;
var s:string;
    delka:longint;
begin
ReadString_Internal(@s[1],delka,255);
if delka=0 then begin ReadString:='';Exit;end;
s[0]:=char(delka);
ReadString:=s;
end;


Procedure TGrpStream.ReadString_Internal(buf:pchar;var skut_delka:longint;limit_delky:longint);
var b:longint;
    r,r2:char;

begin
skut_delka:=0;

if pole_pro_readstring=nil then
   begin
   GetMem(pole_pro_readstring,grp_vel_pole_pro_readstring);
   prednacteno:=0;
   end;

repeat
if jiz_zpracovano>=prednacteno then
   begin
   prednacteno:=ReadStream(pole_pro_readstring[0],grp_vel_pole_pro_readstring-1);
   jiz_zpracovano:=0;
   if prednacteno=0 then
      begin
      status:=stReadError;
      Exit;  {s tim, ze skut_delka=0}
      end;

   if zkoumej_z10 then
      if pole_pro_readstring[0]=#10 then jiz_zpracovano:=1;
   end;


for b:=jiz_zpracovano to prednacteno-1 do
    begin
    r:=pole_pro_readstring[b];
    if (r=#13) or (r=#10) then
       begin
       jiz_zpracovano:=b+1;
       if (r=#13) then
          begin
          if b=prednacteno-1 then zkoumej_z10:=true else
             begin
             r2:=pole_pro_readstring[b+1];
             if r2=#10 then inc(jiz_zpracovano);
             end;
          end;

       if (jiz_zpracovano>=prednacteno) then
          if GetPos=GetSize then status:=stReadError;

       {Mame prubezne vyplnovane pole BUF a promennou skut_delka}
       Exit;
       end
    else if skut_delka<limit_delky then begin buf[skut_delka]:=r;inc(skut_delka);end;
    end;

jiz_zpracovano:=b+1;

until 1=2;
end;



Function TGrpStream.Jsem_v_GRP:boolean;
begin
Jsem_v_GRP:=is_grp;
end;


Function TGrpStream.Jsem_ja_GRP:boolean;
var l:longint;
    n:string[12];
begin
if GetSize<20 then begin Jsem_ja_GRP:=false;Exit;end;
l:=GetPos;
Seek(0);
Read(n[1],12);
n[0]:=#12;
Jsem_ja_GRP:=MAGIC=n;
Seek(l);
end;


Function TGrpStream.Kolik_ja_mam_v_GRP:longint;
var l,m:longint;
    n:string[12];
begin
if GetSize<20 then begin Kolik_ja_mam_v_GRP:=0;Exit;end;
l:=GetPos;
Seek(0);
Read(n[1],12);
n[0]:=#12;
if n<>MAGIC then begin Seek(l);Kolik_ja_mam_v_GRP:=0;Exit;end;
Read(m,4);
Seek(l);
Kolik_ja_mam_v_GRP:=m;
end;


Function GRPExistFile(s:string):boolean;
var grp:TGRPstream;
begin
grp.Init(s,GRPopenRead);
GRPExistFile:=grp.status=grpOK;
grp.Done;
end;

end.
