unit nvidia;
{$CALLING OLDFPCCALL}

interface

Function SetupDriver:byte;
Function NV_GetMemory:longint;
Function NV_memory_type:string[3];
Function NV_memory_width:longint;
Function NV_get_architecture:string[4];
Function NV_get_gpu_pci_id:word;
Procedure NV_SetBank(bank:byte);
Procedure NV_Get_Mode_Info(var xr,yr:longint;var bpp:byte);
Function NV_Init_Graph(mode:byte):byte;

implementation
uses Pci,Go32,lacrt;



type

   VGA_regs = record
   crt:array[0..24] of byte;
   att:array[0..20] of byte;
   gra:array[0..8] of byte;
   seq:array[0..4] of byte;
   mor:byte
   end;


   RIVA_HW_inst = record
     Architecture,
     Version,
     CrystalFreqKHz,
     RamAmountKBytes,
     MaxVClockFreqKHz,
     RamBandwidthKBytesPerSec,
     EnableIRQ,
     IO,
     LockUnlockIO,
     LockUnlockIndex,
     VBlankBit,
     FifoFreeCount:dword;
     {Non-FIFO registers.}
      PCRTC,
      PRAMDAC,
      PFB,
      PFIFO,
      PGRAPH,
      PEXTDEV,
      PTIMER,
      PMC,
      PBUS,
      PRAMIN,
      FIFO,
      PVIDEO,
      CURSOR,
      CURSORPOS,
      VBLANKENABLE,
      VBLANK:dword;
   end;


  NV_videomode = record
     vesa:word;
     bpp:byte;
     w,h:longint;
     nv_screen,nv_horiz,nv_arb0,nv_arb1,nv_vpll:longint;
     vga:VGA_regs;
  end;


const
   NVIDIA_ID = $10DE;

   err_NO_PCI_BIOS = 1;
   err_NO_NVIDIA   = 2;

   ports_table:array[0..48] of word =($3B0, $3B1, $3B2, $3B3, $3B4, $3B5, $3B6,
                                    $3B7, $3B8, $3B9, $3BA, $3BB, $3BC, $3BD,
                                    $3BE, $3BF, $3C0, $3C1, $3C2, $3C3, $3C4,
                                    $3C5, $3C6, $3C7, $3C8, $3C9, $3CA, $3CB,
                                    $3CC, $3CD, $3CE, $3CF, $3D0, $3D1, $3D2,
                                    $3D3, $3D4, $3D5, $3D6, $3D7, $3D8, $3D9,
                                    $3DA, $3DB, $3DC, $3DD, $3DE, $3DF, $FFFF);

   NUM_MODES = 23;

   const NV_mode_regs:array[1..2] of VGA_regs =
      (
      (crt:(45, 39, 39, 145, 42, 159, 191, 31, 0, 192, 0, 0, 0, 0, 0, 0, 156, 14, 143, 40, 0, 143, 192, 227, 255);
       att:(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0);
       gra:(0, 0, 0, 0, 0, 64, 5, 15, 255);
       seq:(3, 1, 15, 0, 14);
       mor:(99)
      ),
      (crt:(127, 99, 99, 131, 106, 26, 114, 240, 0, 96, 0, 0, 0, 0, 0, 0, 89, 13, 87, 200, 0, 87, 115, 227, 255);
       att:(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0);
       gra:(0, 0, 0, 0, 0, 64, 5, 15, 255);
       seq:(3, 1, 15, 0, 14);
       mor:(43)
      )
      );



(*
   mode_list:array[1..1] of NV_videomode =
     (
     (vesa:$130;bpp:8;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$134;bpp:8;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$131;bpp:8;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$100;bpp:8;w:640;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$101;bpp:8;w:640;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$103;bpp:8;w:800;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$105;bpp:8;w:1024;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$107;bpp:8;w:1280;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$10e;bpp:16;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$135;bpp:16;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),
     (vesa:$132;bpp:16;w:320;h:200;
      nv_screen:0;nv_horiz:0;nv_arb0:3;nv_arb1:16;nv_vpll:312590),

      );




VIDEO_MODE mode_list[NUM_MODES] =
(
   ( $130, 8,  320,  200,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 192, 0, 0, 0, 0, 0, 0, 156, 14, 143, 40, 0, 143, 192, 227, 255  ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $134, 8,  320,  240,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 11, 62, 0, 192, 0, 0, 0, 0, 0, 0, 234, 12, 223, 40, 0, 223, 12, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 227 ) ),
   ( $131, 8,  320,  400,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 40, 0, 143, 192, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $100, 8,  640,  400,  0,  0, 3,   16, 247054, ( ( 95, 79, 79, 131, 83, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 80, 0, 143, 192, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $101, 8,  640,  480,  0,  0, 131, 16, 247054, ( ( 95, 79, 79, 131, 83, 159, 11, 62, 0, 64, 0, 0, 0, 0, 0, 0, 234, 12, 223, 80, 0, 223, 12, 227, 255     ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) ),
   ( $103, 8,  800,  600,  0,  0, 3,   16, 162571, ( ( 127, 99, 99, 131, 106, 26, 114, 240, 0, 96, 0, 0, 0, 0, 0, 0, 89, 13, 87, 100, 0, 87, 115, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 43  ) ),
   ( $105, 8,  1024, 768,  0,  0, 3,   16, 95757,  ( ( 163, 127, 127, 135, 132, 149, 36, 245, 0, 96, 0, 0, 0, 0, 0, 0, 3, 9, 255, 128, 0, 255, 37, 227, 255  ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) ),
   ( $107, 8,  1280, 1024, 21, 0, 3,   16, 115981, ( ( 207, 159, 159, 147, 169, 25, 40, 90, 0, 96, 0, 0, 0, 0, 0, 0, 1, 4, 255, 160, 0, 255, 41, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 43  ) ),
   ( $10E, 16, 320,  200,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 192, 0, 0, 0, 0, 0, 0, 156, 14, 143, 80, 0, 143, 192, 227, 255  ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $135, 16, 320,  240,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 11, 62, 0, 192, 0, 0, 0, 0, 0, 0, 234, 12, 223, 80, 0, 223, 12, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 227 ) ),
   ( $132, 16, 320,  400,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 80, 0, 143, 192, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $13D, 16, 640,  400,  0,  0, 3,   16, 247054, ( ( 95, 79, 79, 131, 83, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 160, 0, 143, 192, 227, 255  ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $111, 16, 640,  480,  0,  0, 131, 16, 247054, ( ( 95, 79, 79, 131, 83, 159, 11, 62, 0, 64, 0, 0, 0, 0, 0, 0, 234, 12, 223, 160, 0, 223, 12, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) ),
   ( $114, 16, 800,  600,  0,  0, 3,   16, 162571, ( ( 127, 99, 99, 131, 106, 26, 114, 240, 0, 96, 0, 0, 0, 0, 0, 0, 89, 13, 87, 200, 0, 87, 115, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 43  ) ),
   ( $117, 16, 1024, 768,  0,  0, 3,   16, 95757,  ( ( 163, 127, 127, 135, 132, 149, 36, 245, 0, 96, 0, 0, 0, 0, 0, 0, 3, 9, 255, 0, 0, 255, 37, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) ),
   ( $11A, 16, 1280, 1024, 21, 0, 3,   16, 115981, ( ( 207, 159, 159, 147, 169, 25, 40, 90, 0, 96, 0, 0, 0, 0, 0, 0, 1, 4, 255, 64, 0, 255, 41, 227, 255     ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 43  ) ),
   ( $10F, 32, 320,  200,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 192, 0, 0, 0, 0, 0, 0, 156, 14, 143, 160, 0, 143, 192, 227, 255 ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $136, 32, 320,  240,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 11, 62, 0, 192, 0, 0, 0, 0, 0, 0, 234, 12, 223, 160, 0, 223, 12, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 227 ) ),
   ( $133, 32, 320,  400,  0,  0, 3,   16, 312590, ( ( 45, 39, 39, 145, 42, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 160, 0, 143, 192, 227, 255  ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $13E, 32, 640,  400,  0,  0, 3,   16, 247054, ( ( 95, 79, 79, 131, 83, 159, 191, 31, 0, 64, 0, 0, 0, 0, 0, 0, 156, 14, 143, 64, 0, 143, 192, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 99  ) ),
   ( $112, 32, 640,  480,  0,  0, 131, 16, 247054, ( ( 95, 79, 79, 131, 83, 159, 11, 62, 0, 64, 0, 0, 0, 0, 0, 0, 234, 12, 223, 64, 0, 223, 12, 227, 255     ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) ),
   ( $115, 32, 800,  600,  0,  0, 3,   16, 162571, ( ( 127, 99, 99, 131, 106, 26, 114, 240, 0, 96, 0, 0, 0, 0, 0, 0, 89, 13, 87, 144, 0, 87, 115, 227, 255   ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 43  ) ),
   ( $118, 32, 1024, 768,  0,  0, 3,   17, 95757,  ( ( 163, 127, 127, 135, 132, 149, 36, 245, 0, 96, 0, 0, 0, 0, 0, 0, 3, 9, 255, 0, 0, 255, 37, 227, 255    ), ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 65, 0, 15, 0, 0 ), ( 0, 0, 0, 0, 0, 64
, 5, 15, 255 ), ( 3, 1, 15, 0, 14 ), 235 ) )
);


short available_modes[NUM_MODES+1] =
(
   1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
   17, 18, 19, 20, 21, 22, 23, -1
);
*)



var orig_regs:VGA_regs;
    MMIO_base:dword;
    LFB_base:dword;
    MMIO:dword;

    riva:RIVA_hw_inst;

Function Read_CRT(index:byte):byte;
begin
outportB($3d4,index);
Read_CRT:=InportB($3d5);
end;

Function Read_GRA(index:byte):byte;
begin
outportB($3ce,index);
Read_GRA:=InportB($3cf);
end;

Function Read_SEQ(index:byte):byte;
begin
outportB($3c4,index);
Read_SEQ:=InportB($3c5);
end;

Function Read_ATT(index:byte):byte;
begin
inportB($3da);
outportB($3c0,index);
Read_ATT:=InportB($3c1);
end;


Procedure Write_CRT(index,value:byte);
begin
outportB($3d4,index);
outportB($3d5,value);
end;

Procedure Write_GRA(index,value:byte);
begin
outportB($3ce,index);
outportB($3cf,value);
end;

Procedure Write_SEQ(index,value:byte);
begin
outportB($3c4,index);
outportB($3c5,value);
end;

Procedure Write_ATT(index,value:byte);
begin
outportB($3c0,index);
outportB($3c0,value);
end;

Function Read_MOR:byte;
begin
Read_MOR:=inportB($3cc);
end;

Procedure Write_MOR(value:byte);
begin
outportB($3c2,value);
end;


Procedure ATT_end_reads;
begin
inportb($3DA);
outportb($3C0,$20);
end;


Procedure Unload_VGA_regs(var regs:VGA_regs);
{Saves a VGA register set into a structure.}
var i,mor_val:byte;
begin
mor_val := read_mor;
write_mor(mor_val or 1);
regs.mor:=mor_val;
for i:=0 to 24 do regs.crt[i]:=read_crt(i);
for i:=0 to 20 do regs.att[i]:=read_att(i);
ATT_end_reads;
for i:=0 to 8 do regs.gra[i]:=read_gra(i);
for i:=0 to 4 do regs.seq[i]:=read_seq(i);
write_mor(mor_val);
end;



Procedure Load_VGA_regs(regs:VGA_regs);
{Loads a VGA register set from a structure}
var i,crt11,mor_val:byte;
begin
mor_val:=read_mor;
write_mor(mor_val or 1);

while inportB($3da) and 8<>0 do begin end;
while inportB($3da) and 8=0 do begin end;

write_seq(1, regs.seq[1] or $20);
write_seq(0,1);

for i:=2 to 4 do write_seq(i,regs.seq[i]);
write_seq(0, regs.seq[0]);

crt11 := regs.crt[$11];
write_crt($11, crt11 and $7F);

for i:=0 to 24 do
    if i<>$11 then write_crt(i, regs.crt[i]);
write_crt($11, crt11);

for i:=0 to 8 do write_gra(i, regs.gra[i]);
inportb($3DA);

for i:=0{8} to 20 do write_att(i, regs.att[i]);
att_end_reads;
write_mor(regs.mor);
write_seq(1,regs.seq[1]);
end;


Function MMIO_Mount_memory(where:dword):dword;
{Maps physical region of memory into normal address space}
var r,s,t:longint;
begin
Set_segment_limit(get_ds,$FFFFFFFF);
t:=longint(where);
r:=Get_Linear_Addr(t,16*1024*1024); {16MB adress space should be enough}
s:=get_segment_base_address(get_ds);
MMIO_Mount_memory:=dword(r-s);
end;


Function SetupDriver:byte;
const MAX_INSTALLED_VIDEOCARDS = 5;
var i:byte;
    l:dword;
    p:pointer;
    ppkey:pci_config_s;
    nvidia_found:boolean;

begin
if If_PCI_bios=false then EXIT(err_NO_PCI_BIOS);
nvidia_found:=false;
for i:=0 to MAX_INSTALLED_VIDEOCARDS do   {scan all videocards in computer}
    begin
    Identify_Device(display_controller,i,ppkey);
    if ppkey.vendor_id=0 then Break       {no more graphics cards?}
       else
       if ppkey.vendor_ID = NVIDIA_ID then
          begin
          nvidia_found:=true;
          Break;
          end;
    end;

if not nvidia_found then EXIT(err_NO_NVIDIA);

MMIO_base:=Read_Configuration_dword(ppkey,16) and $FF800000;
LFB_base:=Read_Configuration_dword(ppkey,20) and $FF800000;

mmio:=MMIO_mount_memory(MMIO_base);
SetupDriver:=0;
{----------------------------------------------------------------------}
riva.PRAMDAC := mmio+$00680000;
riva.PFB     := mmio+$00100000;
riva.PFIFO   := mmio+$00002000;
riva.PGRAPH  := mmio+$00400000;
riva.PEXTDEV := mmio+$00101000;
riva.PTIMER  := mmio+$00009000;
riva.PMC     := mmio+$00000000;
riva.FIFO    := mmio+$00800000;
riva.PVIDEO  := mmio+$00008000;
riva.PBUS    := riva.PMC+$1800;

if (ppkey.device_id=$18) or (ppkey.device_id=$19) then  {$2d}
   begin
   riva.Architecture:=3;             {Riva 128}
   riva.PRAMIN:=LFB_base+$00C00000;
   end
   else begin                        {newer cards}
   riva.Architecture:=4;
   riva.PRAMIN:=mmio+$00710000;
   riva.PCRTC:=mmio+$00600000;
   end;

end; {SetupDriver}


Function NV_GetMemory:longint;
var p:^dword;
    i:dword;
begin
if NV_get_architecture='NV01' then
   begin
   p:=pointer(riva.PFB);
   if p^ and $100<>0 then NV_GetMemory:=((p^ shr 12) and $F)*2+2
      else case (p^ and 3) of
           0:NV_GetMemory:=32;
           1:NV_GetMemory:=4;
           2:NV_GetMemory:=8;
           3:NV_GetMemory:=16;
           end {case}
   end
   else begin
   p:=pointer(riva.PFB+$20c);
   NV_GetMemory:=(p^ shr 20) and $0FFF;
   end;
end;


Function NV_memory_type:string[3];
var p:^dword;
begin
p:=pointer(riva.PFB+$200);
if (p^ and 1)=1 then NV_memory_type:='DDR' else NV_memory_type:='SDR';
end;

Function NV_memory_width:longint;
var p:^dword;
begin
p:=pointer(riva.PEXTDEV);
if (p^ and $17)<>0 then NV_memory_width:=128 else NV_memory_width:=64;
end;

Function NV_read_pbus8(index:dword):byte;
{Read a byte from the pci bus}
var p:^dword;
    shift:longint;
begin
shift := index mod 4*8;
p:=pointer(riva.PBUS+index);
NV_read_pbus8:=(p^ shr shift) and $FF;
end;

Function NV_read_pbus16(index:dword):word;
{Read an unsigned short from the pci bus}
var p:^dword;
    shift:longint;
begin
shift:=index mod 2*16;
p:=pointer(riva.PBUS+index);
NV_read_pbus16:=(p^ shr shift) and $FFFF;
end;

Function NV_read_pbus(index:dword):dword;
begin
NV_read_pbus:=dword(pointer(riva.PBUS+index)^);
end;

Function NV_get_architecture:string[4];
var p:^dword;
    b:byte;
begin
p:=pointer(riva.PMC+0);
b:=(p^ shr 20) and $FF;
NV_get_architecture:='NV'+HexStr(b,2);
end;


Function NV_get_gpu_pci_id:word;
begin
NV_get_gpu_pci_id:=nv_read_pbus16(2);
end;


Procedure NV_SetBank(bank:byte);assembler;
asm
push ax
push bx
push dx
mov bh,0
mov bl,bank
shl bx,1
mov dx,3d4h
mov ax,571fh
out dx,ax
mov ah,bl
mov al,1dh
out dx,ax
mov al,1eh
out dx,ax
or bh,bh
jz @skip
mov ah,bh
mov al,29h
or ah,3
out dx,ax
@skip:
pop dx
pop bx
pop ax
end;


Procedure NV_Get_Mode_Info(var xr,yr:longint;var bpp:byte);
var w,h,val:longint;
    p:^dword;

begin
w:=(Read_CRT(1)+1)*8;                   {CRTC_HORIZ_DISPLAY_END}
h:=Read_CRT($12);                       {CRTC_VERT_DISPLAY_END}  {8 bits read}
h:=h or ((Read_CRT(7) and 2) shl 7);    {CRTC_OVERFLOW}          {read 9.bit}
h:=h or ((InportB($3d5) and $40) shl 3);                         {read 10.bit}
xr:=w;
yr:=h+1;
bpp:=Read_CRT($28) and 3;               {CRTC_PIXEL}
p:=pointer(riva.PVIDEO+$600);
val:=p^ and $1000;
if (bpp=2) and (val=0)
   then bpp:=15
   else bpp:=4 shl bpp;
end;


Function NV_Init_Graph(mode:byte):byte;
var linear,noclear:boolean;
    used_vram,i:longint;
begin
Load_VGA_regs(NV_mode_regs[mode]);
end;





begin

end.
