/* Linker script for ELKS executables with separate data and text segments,
   without startup files, and without default libraries.  Generated
   from elk-ms.ld.in.  */

OUTPUT_FORMAT(binary)
ENTRY(_start)
MEMORY
  {
    /* Place header VMA outside of program address space.  */
    hdrlma  (r)	 : ORIGIN = 0x00000, LENGTH = 32
    hdrvma  (r)  : ORIGIN = 0x20000, LENGTH = 32

    /* Account for the 32-byte header.  */
    bseglma (wx) : ORIGIN = 0x00020, LENGTH = 0x20000
    csegvma (wx) : ORIGIN = 0x00000, LENGTH = 0x10000
    dsegvma (wx) : ORIGIN = 0x00000, LENGTH = 0x10000
  }

SECTIONS
  {
    /* There's no binutils configuration which directly supports the ELKS
       binary format, but's it's easy to create the necessary header.  */
    .hdr : {
		LONG (0x04300301);	/* Magic.  */
		LONG (32);		/* Header length.  */
		LONG (__ltext_padded);
		LONG (__ldata);
		LONG (__lbss);
		LONG (_start);
		LONG (0);		/* chmem field.  */
		LONG (0);
	} >hdrvma AT>hdrlma

    /* Target text sections.  */
    .text : {
		__stext = .;
		*(.startupA)
		*(.init)
		*(.startupB)
		*(.fini)
		*(.startupC)
		*(.text) *(.text.*)
		__etext = .;

		/* Work around linker bug.  The linker will 4-byte align the VMA
		 * without being asked to do so, but won't do the same for the
		 * LMA.  Result: VMA out of sync with LMA.
		 * GNU ld version 2.17.50.0.12-3 20070128  */
		. = ALIGN(4);
		__etext_padded = .;
	} >csegvma AT>bseglma
	__ltext = __etext - __stext;
	__ltext_padded = __etext_padded - __stext;

    /* Target data sections.  */
    .data : {
		__sdata = .;

		/* Build lists of constructors and destructors.  */
		KEEP (*crtbegin*.o(.ctors))
		KEEP (*(EXCLUDE_FILE (*crtend*.o ) .ctors))
		KEEP (*(SORT(.ctors.*)))
		KEEP (*(.ctors))

		KEEP (*crtbegin*.o(.dtors))
		KEEP (*(EXCLUDE_FILE (*crtend*.o ) .dtors))
		KEEP (*(SORT(.dtors.*)))
		KEEP (*(.dtors))

		*(.rodata) *(.rodata.*)
		*(.data) *(.data.*)
		__edata = .;

		__sbss = .;
		*(.bss) *(.bss.*)
		*(COMMON)
		__ebss = .;

		/* Minimum address allowed for sbrk() to use.  */
		__heap_end_minimum = .;
	} >dsegvma AT>bseglma
	__ldata = __edata - __sdata;
	__lbss  = __ebss  - __sbss;

    /DISCARD/ : { *(.*) }
  }
