#! /bin/bash

# Public Domain

. cfg.sh

file="$1"
shift

if [[ "$file" == extpak ]]
then
  origfile="$file"
  file=packlib
  "$NASM" -I "$LDEBUG_DIR" -I "$LMACROS_DIR" -I "$BIN_DIR" \
    "$file".asm -w+reloc-rel -w+error=reloc-rel \
    -o "$BIN_DIR$file".bin \
    -l "$LST_DIR$file".lst -D_ELD_LISTING="'$file.lst'" "$@" && \
  "$NASM" -I "$LDEBUG_DIR" -I "$LMACROS_DIR" -I "$BIN_DIR" \
    "$file".asm -w+reloc-rel -w+error=reloc-rel \
    -o "$BIN_DIR$file".xbi \
    -l "$LST_DIR$file".xls -D_ELD_LISTING="'$file.xls'" \
    -D_ELD_DATA_VSTART=0 -D_ELD_CODE_VSTART=0 -D_ELD_RELOC_VSTART=0 \
    -D_ELD_LINKER_PASSES=0 -D_XLD=1 "$@"
  heatshrink -v -w "$HEATSHRINK_W" -l "$HEATSHRINK_L" "$BIN_DIR$file.bin" "$BIN_DIR$file.ets" && \
    (printf "\x$(printf "%02X" "$HEATSHRINK_W")\x$(printf "%02X" "$HEATSHRINK_L")";
    cat "$BIN_DIR$file.ets") > "$BIN_DIR$file.ehs"
  heatshrink -v -w "$HEATSHRINK_W" -l "$HEATSHRINK_L" "$BIN_DIR$file.xbi" "$BIN_DIR$file.xts" && \
    (printf "\x$(printf "%02X" "$HEATSHRINK_W")\x$(printf "%02X" "$HEATSHRINK_L")";
    cat "$BIN_DIR$file.xts") > "$BIN_DIR$file.xhs"
  file="$origfile"
fi

  "$NASM" -I "$LDEBUG_DIR" -I "$LMACROS_DIR" -I "$BIN_DIR" \
    "$file".asm -w+reloc-rel -w+error=reloc-rel \
    -o "$BIN_DIR$file".eld \
    -l "$LST_DIR$file".lst -D_ELD_LISTING="'$file.lst'" "$@" && \
  "$NASM" -I "$LDEBUG_DIR" -I "$LMACROS_DIR" -I "$BIN_DIR" \
    "$file".asm -w+reloc-rel -w+error=reloc-rel \
    -o "$BIN_DIR$file".xld \
    -l "$LST_DIR$file".xls -D_ELD_LISTING="'$file.xls'" \
    -D_ELD_DATA_VSTART=0 -D_ELD_CODE_VSTART=0 -D_ELD_RELOC_VSTART=0 \
    -D_ELD_LINKER_PASSES=0 -D_XLD=1 "$@"

if [[ "$file" == extpak && -f "$BIN_DIR$file.eld" ]]
then
  truncate -c \
    -s "$(tail --bytes=4 "$BIN_DIR$file.eld" | od -An --endian=little -t u4)" \
    "$BIN_DIR$file.eld"
  truncate -c \
    -s "$(tail --bytes=4 "$BIN_DIR$file.xld" | od -An --endian=little -t u4)" \
    "$BIN_DIR$file.xld"
fi
