// define the module for __config outside of the top level 'std' module
// since __config may be included from C headers which may create an
// include cycle.
module std_config [system] [extern_c] {
    header "__config"
}

module std [system] {
  export std_config
  // FIXME: The standard does not require that each of these submodules
  // re-exports its imported modules. We should provide an alternative form of
  // export that issues a warning if a name from the submodule is used, and
  // use that to provide a 'strict mode' for libc++.

  // Deprecated C-compatibility headers. These can all be included from within
  // an 'extern "C"' context.
  module depr [extern_c] {
    // <assert.h> provided by C library.
    module ctype_h {
      header "ctype.h"
      export *
    }
    module errno_h {
      header "errno.h"
      export *
    }
    module fenv_h {
      header "fenv.h"
      export *
    }
    // <float.h> provided by compiler or C library.
    module inttypes_h {
      header "inttypes.h"
      export stdint_h
      export *
    }
    // <iso646.h> provided by compiler.
    // <limits.h> provided by compiler or C library.
    module locale_h {
      header "locale.h"
      export *
    }
    module math_h {
      header "math.h"
      export *
    }
    module setjmp_h {
      header "setjmp.h"
      export *
    }
    // FIXME: <stdalign.h> is missing.
    // <signal.h> provided by C library.
    // <stdarg.h> provided by compiler.
    // <stdbool.h> provided by compiler.
    module stddef_h {
      // <stddef.h>'s __need_* macros require textual inclusion.
      textual header "stddef.h"
    }
    module stdint_h {
      header "stdint.h"
      export *
      // FIXME: This module only exists on OS X and for some reason the
      // wildcard above doesn't export it.
      export Darwin.C.stdint
    }
    module stdio_h {
      // <stdio.h>'s __need_* macros require textual inclusion.
      textual header "stdio.h"
      export *
      export Darwin.C.stdio
    }
    module stdlib_h {
      // <stdlib.h>'s __need_* macros require textual inclusion.
      textual header "stdlib.h"
      export *
    }
    module string_h {
      header "string.h"
      export *
    }
    // FIXME: <uchar.h> is missing.
    // <time.h> provided by C library.
    module wchar_h {
      // <wchar.h>'s __need_* macros require textual inclusion.
      textual header "wchar.h"
      export *
    }
    module wctype_h {
      header "wctype.h"
      export *
    }
  }

  // <complex.h> and <tgmath.h> are not C headers in any real sense, do not
  // allow their use in extern "C" contexts.
  module complex_h {
    header "complex.h"
    export ccomplex
    export *
  }
  module tgmath_h {
    header "tgmath.h"
    export ccomplex
    export cmath
    export *
  }

  // C compatibility headers.
  module compat {
    module cassert {
      // <cassert>'s use of NDEBUG requires textual inclusion.
      textual header "cassert"
    }
    module ccomplex {
      header "ccomplex"
      export complex
      export *
    }
    module cctype {
      header "cctype"
      export *
    }
    module cerrno {
      header "cerrno"
      export *
    }
    module cfenv {
      header "cfenv"
      export *
    }
    module cfloat {
      header "cfloat"
      export *
    }
    module cinttypes {
      header "cinttypes"
      export cstdint
      export *
    }
    module ciso646 {
      header "ciso646"
      export *
    }
    module climits {
      header "climits"
      export *
    }
    module clocale {
      header "clocale"
      export *
    }
    module cmath {
      header "cmath"
      export *
    }
    module csetjmp {
      header "csetjmp"
      export *
    }
    module csignal {
      header "csignal"
      export *
    }
    // FIXME: <cstdalign> is missing.
    module cstdarg {
      header "cstdarg"
      export *
    }
    module cstdbool {
      header "cstdbool"
      export *
    }
    module cstddef {
      header "cstddef"
      export *
    }
    module cstdint {
      header "cstdint"
      export depr.stdint_h
      export *
    }
    module cstdio {
      header "cstdio"
      export *
    }
    module cstdlib {
      header "cstdlib"
      export *
    }
    module cstring {
      header "cstring"
      export *
    }
    module ctgmath {
      header "ctgmath"
      export ccomplex
      export cmath
      export *
    }
    module ctime {
      header "ctime"
      export *
    }
    // FIXME: <cuchar> is missing.
    module cwchar {
      header "cwchar"
      export depr.stdio_h
      export *
    }
    module cwctype {
      header "cwctype"
      export *
    }
  }

  module algorithm {
    header "algorithm"
    export initializer_list
    export *
  }
  module any {
    header "any"
    export *
  }
  module array {
    header "array"
    export initializer_list
    export *
  }
  module atomic {
    header "atomic"
    export *
  }
  module bit {
    header "bit"
    export *
  }
  module bitset {
    header "bitset"
    export string
    export iosfwd
    export *
  }
  // No submodule for cassert. It fundamentally needs repeated, textual inclusion.
  module charconv {
    header "charconv"
    export *
  }
  module chrono {
    header "chrono"
    export *
  }
  module codecvt {
    header "codecvt"
    export *
  }
  module compare {
    header "compare"
    export *
  }
  module complex {
    header "complex"
    export *
  }
  module condition_variable {
    header "condition_variable"
    export *
  }
  module deque {
    header "deque"
    export initializer_list
    export *
  }
  module exception {
    header "exception"
    export *
  }
  module execution {
    header "execution"
    export *
  }
  module filesystem {
    header "filesystem"
    export *
  }
  module forward_list {
    header "forward_list"
    export initializer_list
    export *
  }
  module fstream {
    header "fstream"
    export *
  }
  module functional {
    header "functional"
    export *
  }
  module future {
    header "future"
    export *
  }
  module initializer_list {
    header "initializer_list"
    export *
  }
  module iomanip {
    header "iomanip"
    export *
  }
  module ios {
    header "ios"
    export iosfwd
    export *
  }
  module iosfwd {
    header "iosfwd"
    export *
  }
  module iostream {
    header "iostream"
    export ios
    export streambuf
    export istream
    export ostream
    export *
  }
  module istream {
    header "istream"
    // FIXME: should re-export ios, streambuf?
    export *
  }
  module iterator {
    header "iterator"
    export *
  }
  module limits {
    header "limits"
    export *
  }
  module list {
    header "list"
    export initializer_list
    export *
  }
  module locale {
    header "locale"
    export *
  }
  module map {
    header "map"
    export initializer_list
    export *
  }
  module memory {
    header "memory"
    export *
  }
  module mutex {
    header "mutex"
    export *
  }
  module new {
    header "new"
    export *
  }
  module numeric {
    header "numeric"
    export *
  }
  module optional {
    header "optional"
    export *
  }
  module ostream {
    header "ostream"
    // FIXME: should re-export ios, streambuf?
    export *
  }
  module queue {
    header "queue"
    export initializer_list
    export *
  }
  module random {
    header "random"
    export initializer_list
    export *
  }
  module ratio {
    header "ratio"
    export *
  }
  module regex {
    header "regex"
    export initializer_list
    export *
  }
  module scoped_allocator {
    header "scoped_allocator"
    export *
  }
  module set {
    header "set"
    export initializer_list
    export *
  }
  module sstream {
    header "sstream"
    // FIXME: should re-export istream, ostream, ios, streambuf, string?
    export *
  }
  module stack {
    header "stack"
    export initializer_list
    export *
  }
  module stdexcept {
    header "stdexcept"
    export *
  }
  module streambuf {
    header "streambuf"
    export *
  }
  module string {
    header "string"
    export initializer_list
    export string_view
    export __string
    export *
  }
  module string_view {
    header "string_view"
    export initializer_list
    export __string
    export *
  }
  module strstream {
    header "strstream"
    export *
  }
  module system_error {
    header "system_error"
    export *
  }
  module thread {
    header "thread"
    export *
  }
  module tuple {
    header "tuple"
    export *
  }
  module type_traits {
    header "type_traits"
    export *
  }
  module typeindex {
    header "typeindex"
    export *
  }
  module typeinfo {
    header "typeinfo"
    export *
  }
  module unordered_map {
    header "unordered_map"
    export initializer_list
    export *
  }
  module unordered_set {
    header "unordered_set"
    export initializer_list
    export *
  }
  module utility {
    header "utility"
    export initializer_list
    export *
  }
  module valarray {
    header "valarray"
    export initializer_list
    export *
  }
  module variant {
    header "variant"
    export *
  }
  module vector {
    header "vector"
    export initializer_list
    export *
  }
  module version {
    header "version"
    export *
  }

  // FIXME: These should be private.
  module __bit_reference { header "__bit_reference" export * }
  module __debug { header "__debug" export * }
  module __errc { header "__errc" export * }
  module __functional_base { header "__functional_base" export * }
  module __hash_table { header "__hash_table" export * }
  module __locale { header "__locale" export * }
  module __mutex_base { header "__mutex_base" export * }
  module __split_buffer { header "__split_buffer" export * }
  module __sso_allocator { header "__sso_allocator" export * }
  module __std_stream { header "__std_stream" export * }
  module __string { header "__string" export * }
  module __tree { header "__tree" export * }
  module __tuple { header "__tuple" export * }
  module __undef_macros { header "__undef_macros" export * }
  module __node_handle { header "__node_handle" export * }

  module experimental {
    requires cplusplus11

    module algorithm {
      header "experimental/algorithm"
      export *
    }
     module coroutine {
      requires coroutines
      header "experimental/coroutine"
      export *
    }
    module deque {
      header "experimental/deque"
      export *
    }
    module filesystem {
      header "experimental/filesystem"
      export *
    }
    module forward_list {
      header "experimental/forward_list"
      export *
    }
    module functional {
      header "experimental/functional"
      export *
    }
    module iterator {
      header "experimental/iterator"
      export *
    }
    module list {
      header "experimental/list"
      export *
    }
    module map {
      header "experimental/map"
      export *
    }
    module memory_resource {
      header "experimental/memory_resource"
      export *
    }
    module propagate_const {
      header "experimental/propagate_const"
      export *
    }
    module regex {
      header "experimental/regex"
      export *
    }
    module simd {
      header "experimental/simd"
      export *
    }
    module set {
      header "experimental/set"
      export *
    }
    module span {
      header "span"
      export *
    }
    module string {
      header "experimental/string"
      export *
    }
    module type_traits {
      header "experimental/type_traits"
      export *
    }
    module unordered_map {
      header "experimental/unordered_map"
      export *
    }
    module unordered_set {
      header "experimental/unordered_set"
      export *
    }
    module utility {
      header "experimental/utility"
      export *
    }
    module vector {
      header "experimental/vector"
      export *
    }
    // FIXME these should be private
    module __memory {
      header "experimental/__memory"
      export *
    }
  } // end experimental
}
